DROP TABLE IF EXISTS `newsletter_fields`;
CREATE TABLE IF NOT EXISTS `newsletter_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `newsletter_multi_lang`;
CREATE TABLE IF NOT EXISTS `newsletter_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(100) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(100) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `newsletter_options`;
CREATE TABLE IF NOT EXISTS `newsletter_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `newsletter_roles`;
CREATE TABLE IF NOT EXISTS `newsletter_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `newsletter_users`;
CREATE TABLE IF NOT EXISTS `newsletter_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `newsletter_groups`;
CREATE TABLE IF NOT EXISTS `newsletter_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_title` varchar(255) DEFAULT NULL,
  `subscribed_fields` varchar(255) NOT NULL DEFAULT 'first_name,email',
  `send_confirm` enum('T','F') NOT NULL DEFAULT 'F',
  `confirm_subject` varchar(255) DEFAULT NULL,
  `confirm_message` text DEFAULT NULL,
  `send_response` enum('T','F') NOT NULL DEFAULT 'F',
  `response_subject` varchar(255) DEFAULT NULL,
  `response_message` text DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `newsletter_groups_subscribers`;
CREATE TABLE IF NOT EXISTS `newsletter_groups_subscribers` (
  `group_id` int(10) unsigned NOT NULL,
  `subscriber_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`group_id`, `subscriber_id`),
  UNIQUE KEY `group_id` (`group_id`,`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `newsletter_subscribers`;
CREATE TABLE IF NOT EXISTS `newsletter_subscribers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `gender` enum('F','M') DEFAULT NULL,
  `age` int(3) DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `country_id` int(10) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `subscribed` enum('T','F') DEFAULT 'F',
  `ip` varchar(255) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `newsletter_messages`;
CREATE TABLE IF NOT EXISTS `newsletter_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) DEFAULT NULL,
  `tinymce_message` text DEFAULT NULL,
  `plain_message` text DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `newsletter_files`;
CREATE TABLE IF NOT EXISTS `newsletter_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message_id` int(10) DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `file_path` varchar(255) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `newsletter_queues`;
CREATE TABLE IF NOT EXISTS `newsletter_queues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message_id` int(10) unsigned DEFAULT NULL,
  `subscriber_id` int(10) unsigned DEFAULT NULL,
  `date_sent` datetime DEFAULT NULL,
  `status` enum('completed','inprogress') NOT NULL DEFAULT 'inprogress',
  PRIMARY KEY (`id`)		
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `newsletter_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 1, 1, NULL),
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 2, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 3, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 5, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 6, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 7, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 8, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL);

INSERT INTO `newsletter_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T');

INSERT INTO `newsletter_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(147, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(254, 'pj_delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(255, 'pj_delete_confirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
(256, 'menuGroups', 'backend', 'Menu / Groups', 'script', NULL),
(257, 'menuSubscribers', 'backend', 'Menu / Subscribers', 'script', NULL),
(258, 'pj_same_group', 'backend', 'Label / Group in use', 'script', NULL),
(259, 'lblAddGroup', 'backend', 'Label / Add group', 'script', NULL),
(260, 'lblGroup', 'backend', 'Label / Group', 'script', NULL),
(261, 'lblSubscribers', 'backend', 'Label / Subscribers', 'script', NULL),
(262, 'lblActive', 'backend', 'Label / Active', 'script', NULL),
(263, 'lblInactive', 'backend', 'Label / Inactive', 'script', NULL),
(264, 'error_titles_ARRAY_AG01', 'arrays', 'error_titles_ARRAY_AG01', 'script', NULL),
(265, 'error_bodies_ARRAY_AG01', 'arrays', 'error_bodies_ARRAY_AG01', 'script', NULL),
(266, 'error_titles_ARRAY_AG03', 'arrays', 'error_titles_ARRAY_AG03', 'script', NULL),
(267, 'error_bodies_ARRAY_AG03', 'arrays', 'error_bodies_ARRAY_AG03', 'script', NULL),
(268, 'error_titles_ARRAY_AG04', 'arrays', 'error_titles_ARRAY_AG04', 'script', NULL),
(269, 'error_bodies_ARRAY_AG04', 'arrays', 'error_bodies_ARRAY_AG04', 'script', NULL),
(270, 'error_titles_ARRAY_AG08', 'arrays', 'error_bodies_ARRAY_AG08', 'script', NULL),
(271, 'error_bodies_ARRAY_AG08', 'arrays', 'error_bodies_ARRAY_AG08', 'script', NULL),
(272, 'lblUpdateGroup', 'backend', 'Label / Update group', 'script', NULL),
(273, 'error_titles_ARRAY_AS01', 'arrays', 'error_titles_ARRAY_AS01', 'script', NULL),
(274, 'error_bodies_ARRAY_AS01', 'arrays', 'error_bodies_ARRAY_AS01', 'script', NULL),
(275, 'error_titles_ARRAY_AS03', 'arrays', 'error_titles_ARRAY_AS03', 'script', NULL),
(276, 'error_bodies_ARRAY_AS03', 'arrays', 'error_bodies_ARRAY_AS03', 'script', NULL),
(277, 'error_titles_ARRAY_AS04', 'arrays', 'error_titles_ARRAY_AS04', 'script', NULL),
(278, 'error_bodies_ARRAY_AS04', 'arrays', 'error_bodies_ARRAY_AS04', 'script', NULL),
(279, 'error_titles_ARRAY_AS08', 'arrays', 'error_titles_ARRAY_AS08', 'script', NULL),
(280, 'error_bodies_ARRAY_AS08', 'arrays', 'error_bodies_ARRAY_AS08', 'script', NULL),
(281, 'lblAddSubscriber', 'backend', 'Label / Add subscriber', 'script', NULL),
(282, 'lblFirstName', 'backend', 'Label / First name', 'script', NULL),
(283, 'lblLastName', 'backend', 'Label / Last name', 'script', NULL),
(284, 'lblEmail', 'backend', 'Label / Email', 'script', NULL),
(285, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(286, 'lblWebsite', 'backend', 'Label / Website', 'script', NULL),
(287, 'lblGender', 'backend', 'Label / Gender', 'script', NULL),
(288, 'lblAge', 'backend', 'Label / Age', 'script', NULL),
(289, 'lblBirthday', 'backend', 'Label / Birthday', 'script', NULL),
(290, 'lblAddress', 'backend', 'Label / Address', 'script', NULL),
(291, 'lblCity', 'backend', 'Label / City', 'script', NULL),
(292, 'lblState', 'backend', 'Label / State', 'script', NULL),
(293, 'lblCountry', 'backend', 'Label / Country', 'script', NULL),
(294, 'lblZip', 'backend', 'Label / Zip', 'script', NULL),
(295, 'lblCompanyName', 'backend', 'Label / Company name', 'script', NULL),
(296, 'lblUpdateSubscriber', 'backend', 'Label / Update subscriber', 'script', NULL),
(297, 'genderarr_ARRAY_F', 'arrays', 'genderarr_ARRAY_F', 'script', NULL),
(298, 'genderarr_ARRAY_M', 'arrays', 'genderarr_ARRAY_M', 'script', NULL),
(324, 'lblCreatedDateTime', 'backend', 'Label / Date time created', 'script', NULL),
(325, 'lblModifiedDateTime', 'backend', 'Label / Date time modified', 'script', NULL),
(326, 'lblNA', 'backend', 'Label / NA', 'script', NULL),
(327, 'lblSubscribed', 'backend', 'Label / Subscribed', 'script', NULL),
(328, 'lblBetween', 'backend', 'Label / between', 'script', NULL),
(329, 'lblAnd', 'backend', 'Label / and', 'script', NULL),
(330, 'lblDateSubscribed', 'backend', 'Label / Date subscribed', 'script', NULL),
(331, 'lblFrom', 'backend', 'Label / from', 'script', NULL),
(332, 'lblTo', 'backend', 'Label / to', 'script', NULL),
(333, 'subscribed_arr_ARRAY_T', 'arrays', 'subscribed_arr_ARRAY_T', 'script', NULL),
(334, 'subscribed_arr_ARRAY_F', 'arrays', 'subscribed_arr_ARRAY_F', 'script', NULL),
(360, 'lblImport', 'backend', 'Label / Import', 'script', NULL),
(361, 'lblCSVFile', 'backend', 'Label / CSV file', 'script', NULL),
(362, 'lblUpdateSubscribers', 'backend', 'Label / Update subscribers', 'script', NULL),
(363, 'infoImportTitle', 'backend', 'Infobox / Import title', 'script', NULL),
(364, 'infoImportBody', 'backend', 'Infobox / Import body', 'script', NULL),
(365, 'btnImport', 'backend', 'Button / Import', 'script', NULL),
(366, 'error_titles_ARRAY_AS09', 'arrays', 'error_titles_ARRAY_AS09', 'script', NULL),
(367, 'error_bodies_ARRAY_AS09', 'arrays', 'error_bodies_ARRAY_AS09', 'script', NULL),
(368, 'error_titles_ARRAY_AS13', 'arrays', 'error_titles_ARRAY_AS13', 'script', NULL),
(369, 'error_bodies_ARRAY_AS13', 'arrays', 'error_bodies_ARRAY_AS13', 'script', NULL),
(370, 'error_titles_ARRAY_AS12', 'arrays', 'error_titles_ARRAY_AS12', 'script', NULL),
(371, 'error_bodies_ARRAY_AS12', 'arrays', 'error_bodies_ARRAY_AS12', 'script', NULL),
(372, 'error_titles_ARRAY_AS10', 'arrays', 'error_titles_ARRAY_AS10', 'script', NULL),
(373, 'error_bodies_ARRAY_AS10', 'arrays', 'error_bodies_ARRAY_AS10', 'script', NULL),
(374, 'error_titles_ARRAY_AS11', 'arrays', 'error_titles_ARRAY_AS11', 'script', NULL),
(375, 'error_bodies_ARRAY_AS11', 'arrays', 'error_bodies_ARRAY_AS11', 'script', NULL),
(376, 'menuMessages', 'backend', 'Menu / Messages', 'script', NULL),
(377, 'lblAddMessage', 'backend', 'Label / Add message', 'script', NULL),
(378, 'lblSubject', 'backend', 'Label / Subject', 'script', NULL),
(379, 'lblTotalSent', 'backend', 'Label / Total sent', 'script', NULL),
(380, 'lblLastSent', 'backend', 'Label / Last sent', 'script', NULL),
(381, 'lblMessage', 'backend', 'Label / Message', 'script', NULL),
(382, 'lblPlainMessage', 'backend', 'Label / Plain message', 'script', NULL),
(383, 'lblAttachFiles', 'backend', 'Label / Attach file(s)', 'script', NULL),
(384, 'lblUpdateMessage', 'backend', 'Label / Update message', 'script', NULL),
(385, 'lblDownload', 'backend', 'Label / download', 'script', NULL),
(386, 'lblDeleteFileTitle', 'backend', 'Label / Delete file title', 'script', NULL),
(387, 'lblDeleteFileBody', 'backend', 'Label / delete file body', 'script', NULL),
(388, 'lblSend', 'backend', 'Label / Send', 'script', NULL),
(389, 'lblSchedule', 'backend', 'Label / Schedule', 'script', NULL),
(390, 'lblSendNow', 'backend', 'Label / send now', 'script', NULL),
(391, 'lblSendLater', 'backend', 'Label / Send later', 'script', NULL),
(392, 'lblSendOn', 'backend', 'Label / Send on', 'script', NULL),
(393, 'lblSendInBatches', 'backend', 'Label / Send in batches', 'script', NULL),
(394, 'lblEmailsEvery', 'backend', 'Label / emails every', 'script', NULL),
(395, 'lblMinutes', 'backend', 'Label / minutes', 'script', NULL),
(396, 'error_titles_ARRAY_AM09', 'arrays', 'error_titles_ARRAY_AM09', 'script', NULL),
(397, 'error_bodies_ARRAY_AM09', 'arrays', 'error_bodies_ARRAY_AM09', 'script', NULL),
(398, 'error_titles_ARRAY_AM10', 'arrays', 'error_titles_ARRAY_AM10', 'script', NULL),
(399, 'error_bodies_ARRAY_AM10', 'arrays', 'error_bodies_ARRAY_AM10', 'script', NULL),
(400, 'error_titles_ARRAY_AM01', 'arrays', 'error_titles_ARRAY_AM01', 'script', NULL),
(401, 'error_bodies_ARRAY_AM01', 'arrays', 'error_bodies_ARRAY_AM01', 'script', NULL),
(402, 'error_titles_ARRAY_AM03', 'arrays', 'error_titles_ARRAY_AM03', 'script', NULL),
(403, 'error_bodies_ARRAY_AM03', 'arrays', 'error_bodies_ARRAY_AM03', 'script', NULL),
(404, 'error_titles_ARRAY_AM04', 'arrays', 'error_bodies_ARRAY_AM04', 'script', NULL),
(405, 'error_bodies_ARRAY_AM04', 'arrays', 'error_bodies_ARRAY_AM04', 'script', NULL),
(406, 'error_titles_ARRAY_AM08', 'arrays', 'error_titles_ARRAY_AM08', 'script', NULL),
(407, 'error_bodies_ARRAY_AM08', 'arrays', 'error_bodies_ARRAY_AM08', 'script', NULL),
(408, 'lblNeverSent', 'backend', 'Label / never sent', 'script', NULL),
(409, 'lblCurrentServerTime', 'backend', 'Label / Current server time', 'script', NULL),
(410, 'lblHTMLMessage', 'backend', 'Label / HTML message', 'script', NULL),
(411, 'lblAvailableTokens', 'backend', 'Label / Available tokens', 'script', NULL),
(412, 'lblTotalSubscribers', 'backend', 'Label / Total subscribers', 'script', NULL),
(413, 'lblMailQueue', 'backend', 'Label / Mail queue', 'script', NULL),
(414, 'queue_arr_ARRAY_inprogress', 'arrays', 'queue_arr_ARRAY_inprogress', 'script', NULL),
(415, 'queue_arr_ARRAY_completed', 'arrays', 'queue_arr_ARRAY_completed', 'script', NULL),
(416, 'lblInProgress', 'backend', 'label / In progress', 'script', NULL),
(417, 'lblCompleted', 'backend', 'Label / Completed', 'script', NULL),
(418, 'lblMessageID', 'backend', 'Label / Message ID', 'script', NULL),
(419, 'lblDateSent', 'backend', 'Label / Date sent', 'script', NULL),
(420, 'lblPreview', 'backend', 'Label / Preview', 'script', NULL),
(421, 'lblNoGroupFound', 'backend', 'Label / No groups found', 'script', NULL),
(422, 'lblAddAGroup', 'backend', 'Label / Add a group', 'script', NULL),
(423, 'pj_group_required', 'backend', 'Label / Group required', 'script', NULL),
(424, 'pj_csv_allowed', 'backend', 'Label / CSV file allowed', 'script', NULL),
(425, 'lblSendMessage', 'backend', 'Label / Send message', 'script', NULL),
(426, 'lblPrompSelectMessage', 'backend', 'Label / Select message', 'script', NULL),
(427, 'lblSentOK', 'backend', 'Label / Message sent ok', 'script', NULL),
(428, 'lblSentError', 'backend', 'Label / Message sent error', 'script', NULL),
(429, 'lblSendProgress', 'backend', 'Label / Message sending', 'script', NULL),
(430, 'infoAddMessageTitle', 'backend', 'Infobox / Add message title', 'script', NULL),
(431, 'infoAddMessageBody', 'backend', 'Infobox / Add message body', 'script', NULL),
(432, 'infoUpdateMessageTitle', 'backend', 'Infobox / Update message title', 'script', NULL),
(433, 'infoUpdateMessageBody', 'backend', 'Infobox / Update message body', 'script', NULL),
(434, 'lblSendTest', 'backend', 'Label / Send test', 'script', NULL),
(436, 'lblSendTestTitle', 'backend', 'label / Send test title', 'script', NULL),
(437, 'lblPromptEnterEmail', 'backend', 'Label / prompt enter email', 'script', NULL),
(438, 'infoSendTitle', 'backend', 'Infobox / Send message title', 'script', NULL),
(439, 'infoSendBody', 'backend', 'Infobox / Send message body', 'script', NULL),
(440, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(441, 'lblDashSubscribers', 'backend', 'Label / Subscribers', 'script', NULL),
(442, 'lblDashSubscriber', 'backend', 'Label / Subscriber', 'script', NULL),
(443, 'lblDashMessages', 'backend', 'Label / Messages', 'script', NULL),
(444, 'lblDashMessage', 'backend', 'Label / Message', 'script', NULL),
(446, 'lblDashPending', 'backend', 'Label / Pending', 'script', NULL),
(447, 'lblDashLatestSubscribers', 'backend', 'Label / Latest subscribers', 'script', NULL),
(448, 'lblDashLatestSentMessages', 'backend', 'Label / Latest sent messages', 'script', NULL),
(449, 'lblDashToBeSent', 'backend', 'Label / To be sent', 'script', NULL),
(450, 'lblSubscriberNotFound', 'backend', 'Label / Subscriber not found', 'script', NULL),
(451, 'lblDashEmails', 'backend', 'Label / Emails', 'script', NULL),
(452, 'lblDashEmail', 'backend', 'Label / Email', 'script', NULL),
(478, 'infoAddSubscriberTitle', 'backend', 'Infobox / Add subscriber title', 'script', NULL),
(479, 'infoAddSubscriberBody', 'backend', 'Infobox / Add subscriber body', 'script', NULL),
(481, 'infoUpdateSubscriberBody', 'backend', 'Infobox / Update subscriber body', 'script', NULL),
(482, 'infoUpdateSubscriberTitle', 'backend', 'Infobox / Update subscriber title', 'script', NULL),
(483, 'lblMessageTokens', 'backend', 'Label / Message tokens', 'script', NULL),
(484, 'infoMailQueueTitle', 'backend', 'Infobox / Mail queue title', 'script', NULL),
(485, 'infoMailQueueBody', 'backend', 'Infobox / Mail queue body', 'script', NULL),
(486, 'infoGroupTitle', 'backend', 'Infobox / Group list title', 'script', NULL),
(487, 'infoGroupBody', 'backend', 'Infobox / Group list body', 'script', NULL),
(488, 'infoAddGroupTitle', 'backend', 'Infobox / Add group title', 'script', NULL),
(489, 'infoAddGroupBody', 'backend', 'Infobox / Add group body', 'script', NULL),
(490, 'infoUpdateGroupTitle', 'backend', 'Infobox / Update group title', 'script', NULL),
(491, 'infoUpdateGroupBody', 'backend', 'Infobox / Update group body', 'script', NULL),
(492, 'lblID', 'backend', 'Label / ID', 'script', NULL),
(493, 'lblAllowedExt', 'backend', 'Label / File not allowed', 'script', NULL),
(494, 'lblMessageSent', 'backend', 'Label / Messages sent', 'script', NULL),
(495, 'lblDuplicate', 'backend', 'Label / Duplicate', 'script', NULL),
(496, 'lblCopy', 'backend', 'Label / Copy', 'script', NULL),
(497, 'lblDuplicateTitle', 'backend', 'Label / Make a message copy', 'script', NULL),
(498, 'lblDuplicateConfirm', 'backend', 'Label / Duplicate confirm', 'script', NULL),
(499, 'lblAddToGroup', 'backend', 'Label / Add to group', 'script', NULL),
(500, 'lblAssignToGroup', 'backend', 'Label / Assign to group', 'script', NULL),
(501, 'lblAddGroupText', 'backend', 'Label / Add group text', 'script', NULL),
(527, 'lblSendMessageMenu', 'backend', 'Label / Send message', 'script', NULL),
(528, 'lblSubscriberData', 'backend', 'Label / Subscriber data', 'script', NULL),
(529, 'infoSubscriberDataTitle', 'backend', 'Infobox / Subscribers data title', 'script', NULL),
(530, 'infoSubscriberDataBody', 'backend', 'Infobox / Subscriber data body', 'script', NULL),
(531, 'error_titles_ARRAY_AG09', 'arrays', 'error_titles_ARRAY_AG09', 'script', NULL),
(532, 'error_bodies_ARRAY_AG09', 'arrays', 'error_bodies_ARRAY_AG09', 'script', NULL),
(533, 'lblGroupDetails', 'backend', 'Label / Group details', 'script', NULL),
(534, 'lblConfirmation', 'backend', 'Label / Confirmation', 'script', NULL),
(535, 'lblSubsciptionForm', 'backend', 'Label / Subscription form', 'script', NULL),
(536, 'lblSelectField', 'backend', 'Label / Select at least a fields', 'script', NULL),
(537, 'lblSendConfirmMessage', 'backend', 'label / Send confirmation message', 'script', NULL),
(538, 'lblSendAutoResponse', 'backend', 'Label / Send auto response', 'script', NULL),
(539, 'infoSendConfirmTitle', 'backend', 'Infobox / Send confirmation title', 'script', NULL),
(540, 'infoSendConfirmBody', 'backend', 'Infobox / Send confirmation body', 'script', NULL),
(541, 'infoSendResponseTitle', 'backend', 'Infobox / Send response title', 'script', NULL),
(542, 'infoSendResponseBody', 'backend', 'Infobox / Send response body', 'script', NULL),
(543, 'infoSubscritionFormTitle', 'backend', 'Infobox / Subscription form title', 'script', NULL),
(544, 'infoSubscritionFormBody', 'backend', 'Infobox / Subscription form body', 'script', NULL),
(545, 'front_label_form', 'frontend', 'Label / Subscription form', 'script', NULL),
(546, 'front_label_first_name', 'frontend', 'Label / First name', 'script', NULL),
(547, 'front_label_last_name', 'frontend', 'Label / Last name', 'script', NULL),
(548, 'front_label_email', 'frontend', 'Label / email', 'script', NULL),
(549, 'front_label_phone', 'frontend', 'Label / Phone', 'script', NULL),
(550, 'front_label_website', 'frontend', 'Label / Website', 'script', NULL),
(551, 'front_label_gender', 'frontend', 'Label / Gender', 'script', NULL),
(552, 'front_label_age', 'frontend', 'Label / Age', 'script', NULL),
(553, 'front_label_birthday', 'frontend', 'Label / Birthday', 'script', NULL),
(554, 'front_label_address', 'frontend', 'Label / Address', 'script', NULL),
(555, 'front_label_city', 'frontend', 'Label / City', 'script', NULL),
(556, 'front_label_state', 'frontend', 'Label / State', 'script', NULL),
(557, 'front_label_country', 'frontend', 'Label / Country', 'script', NULL),
(558, 'front_label_zip', 'frontend', 'Label / Zip', 'script', NULL),
(559, 'front_label_company_name', 'frontend', 'Label / Company name', 'script', NULL),
(560, 'front_label_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(561, 'front_button_subscribe', 'frontend', 'Label / Subscribe', 'script', NULL),
(562, 'front_required_ARRAY_first_name', 'arrays', 'front_required_ARRAY_first_name', 'script', NULL),
(563, 'front_required_ARRAY_last_name', 'arrays', 'front_required_ARRAY_last_name', 'script', NULL),
(564, 'front_required_ARRAY_email', 'arrays', 'front_required_ARRAY_email', 'script', NULL),
(565, 'front_required_ARRAY_phone', 'arrays', 'front_required_ARRAY_phone', 'script', NULL),
(566, 'front_required_ARRAY_website', 'arrays', 'front_required_ARRAY_website', 'script', NULL),
(567, 'front_required_ARRAY_gender', 'arrays', 'front_required_ARRAY_gender', 'script', NULL),
(568, 'front_required_ARRAY_age', 'arrays', 'front_required_ARRAY_age', 'script', NULL),
(569, 'front_required_ARRAY_birthday', 'arrays', 'front_required_ARRAY_birthday', 'script', NULL),
(570, 'front_required_ARRAY_address', 'arrays', 'front_required_ARRAY_address', 'script', NULL),
(571, 'front_required_ARRAY_city', 'arrays', 'front_required_ARRAY_city', 'script', NULL),
(572, 'front_required_ARRAY_state', 'arrays', 'front_required_ARRAY_state', 'script', NULL),
(573, 'front_required_ARRAY_country', 'arrays', 'front_required_ARRAY_country', 'script', NULL),
(574, 'front_required_ARRAY_captcha', 'arrays', 'front_required_ARRAY_captcha', 'script', NULL),
(575, 'front_required_ARRAY_company_name', 'arrays', 'front_required_ARRAY_company_name', 'script', NULL),
(576, 'front_validation_ARRAY_email_invalid', 'arrays', 'front_validation_ARRAY_email_invalid', 'script', NULL),
(577, 'front_validation_ARRAY_email_used', 'arrays', 'front_validation_ARRAY_email_used', 'script', NULL),
(578, 'front_validation_ARRAY_birthday_invalid', 'arrays', 'front_validation_ARRAY_birthday_invalid', 'script', NULL),
(579, 'front_validation_ARRAY_captcha_incorrect', 'arrays', 'front_validation_ARRAY_captcha_incorrect', 'script', NULL),
(580, 'front_label_subscribe_info', 'frontend', 'Label / Subscription form is processing...', 'script', NULL),
(581, 'front_label_subscribe_error', 'frontend', 'Label / Subscription failed to save', 'script', NULL),
(582, 'front_label_subscribe_success', 'frontend', 'Label / Subscription form saved', 'script', NULL),
(583, 'front_label_choose', 'frontend', 'Label / Choose', 'script', NULL),
(584, 'front_required_ARRAY_zip', 'arrays', 'front_required_ARRAY_zip', 'script', NULL),
(587, 'lblConfirmToken', 'backend', 'Label / confirm token', 'script', NULL),
(588, 'front_confirm_ARRAY_FC01', 'arrays', 'front_confirm_ARRAY_FC01', 'script', NULL),
(589, 'front_confirm_ARRAY_FC02', 'arrays', 'front_confirm_ARRAY_FC02', 'script', NULL),
(590, 'front_confirm_ARRAY_FC03', 'arrays', 'front_confirm_ARRAY_FC03', 'script', NULL),
(591, 'front_label_day', 'frontend', 'Label / Day', 'script', NULL),
(592, 'front_label_month', 'frontend', 'Label / Month', 'script', NULL),
(593, 'front_label_year', 'frontend', 'Label / Year', 'script', NULL),
(619, 'lblNoMessageFound', 'backend', 'Label / No message', 'script', NULL),
(620, 'lblAddAMessage', 'backend', 'Label / Add a message', 'script', NULL),
(621, 'btnSaveAndSend', 'backend', 'Buttons / Save and Send', 'script', NULL),
(622, 'infoSubscritionForm2Title', 'backend', 'Infobox / Subscription form 2 title', 'script', NULL),
(623, 'front_label_subscribe_inactive', 'frontend', 'Label / subscribe to inactive group', 'script', NULL),
(624, 'front_unsubscribe_ARRAY_FS02', 'arrays', 'front_unsubscribe_ARRAY_FS02', 'script', NULL),
(625, 'front_unsubscribe_ARRAY_FS03', 'arrays', 'front_unsubscribe_ARRAY_FS03', 'script', NULL),
(626, 'front_unsubscribe_ARRAY_FS01', 'arrays', 'front_unsubscribe_ARRAY_FS01', 'script', NULL),
(694, 'infoCronScriptTitle', 'backend', 'Infobox / Cron script', 'script', NULL),
(695, 'infoCronScriptDesc', 'backend', 'Infobox / Cron script description', 'script', NULL),
(696, 'lblCronScript', 'backend', 'Label / Cron script', 'script', NULL),
(697, 'lblServerPath', 'backend', 'Label / Server Path', 'script', NULL),
(698, 'error_titles_ARRAY_AM11', 'arrays', 'error_titles_ARRAY_AM11', 'script', NULL),
(699, 'error_bodies_ARRAY_AM11', 'arrays', 'error_bodies_ARRAY_AM11', 'script', NULL);

INSERT INTO `newsletter_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Listing Address Body', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Listing Address Title', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Email address was already in use', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Are you sure that you want to delete the selected record(s)?', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Groups', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Subscribers', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'The group name was already in use.', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'Add group', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'Group', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Subscribers', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Group updated!', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'All changes made to the group have been saved.', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'Group added!', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'A new group has been added to the list.', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'Group failed to add!', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'We are sorry that group could not be added.', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'Group not found!', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'Group you are looking for is missing.', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'Update group', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'Subscriber updated', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'All changes made to the subscriber have been saved.', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Subscriber added', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'A new subscriber has been added to the list.', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Subscriber failed to add', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'We are sorry that subscriber could not bee added.', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Subscriber not found', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Subscriber you are looking for is missing.', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Add subscriber', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Gender', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Age', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Birthday', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Company name', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Update subscriber', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Female', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Male', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Date/time created', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Date/time modified', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'n/a', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Subscribed', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'between', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'and', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Date subscribed', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'from', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'to', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Subscribed', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Unsubscribed', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Import', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'CSV file', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Update subscribers', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Import subscribers', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Upload a CSV file with your subscribers. If you check "Update subscribers" then any subscribers which are already in your list will be updated with the new data uploaded via the CSV file. Otherwise each new subscriber will be added to the list and duplicates may be possible. Sample CSV file can be found <a href="import-sample.csv">here</a>.', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Import', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Subscriber imported', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Subscriber list has been imported successfully.', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Subscriber imported', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Subscriber list has been imported, but there are some duplicated emails.', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Subscribers updated', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Subscribers in CSV file have been updated.', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'File type error', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'CSV file missing', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Importing subscribers could not be process because of missing of CSV file.', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Messages', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Add message', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Total sent', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Last sent', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Plain text message', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Attach file(s)', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Update message', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'download', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Delete file', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Are you sure that you really want to delete this file?', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Schedule', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'send now', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'send later', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Send on', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Send in batches', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'emails every', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'minutes', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Message sent', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'The message has been sent to subscribers of the group(s).', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Message saved', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'The message has been saved to the queue and waited for sending to subscribers.', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Message updated', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'All changes made to the message have been saved.', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Message added', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'A new message has been added to the list.', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Message failed to add', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'We are sorry that the message could not be saved.', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Message not found', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'Message you are looking for is missing.', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'never sent', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Current server time', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'HTML message', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Available tokens', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Total subscribers', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Mail queue', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'In progress', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Completed', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'In progress', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Completed', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Message ID', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Date sent', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'There are no groups.', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Add a group', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Subscriber must be assigned to at least one group.', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Send message to subscriber', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Select a message and send it to the selected subscriber.', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'The message has been sent successfully.', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'We sorry that the message could not be sent.', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Message is sending...', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Create a message', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'You can create a message using the form below. Just fill in message subject and body, attach files and save it. You have the option to add both HTML and Plain text version for your email message.', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Edit message', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'You can change your email message. Please, note that all the messages in the queue will be sent using that new message. We advise you to create a new message every time you need to send different message to your subscribers instead of editing existing messages.', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Send test', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Send test message', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Quickly send a test message to your email address. Please, note that any tokens used in the message will be empty.', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Send a message', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Using the form below you can send an email message to one of multiple subscribers'' groups. First you need to select the message that will be sent. There are two icons to edit and preview the message. Then you need to select the group(s) and a new line with total subscribers for the selected group(s) will show up so you know how many subscribers will receive the message.<br /><br />\r\n\r\nWith the "Schedule" option you can set the message to be sent right after you click the Send button or select a date/time when the message should be sent.<br /><br />\r\n\r\nWith the "Send in batches" option you can split the subscribers in portions and send the message to each portion in equal intervals. This is useful if you have to send many emails but your server limits the number of outgoing messages.', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Subscribers', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Subscriber', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Messages', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'Latest subscribers', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'Latest sent messages', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'Mail queue', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'Subscriber not found', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Add а subscriber', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Fill in the form below to add a subscriber. You can assign the subscriber to one or multiple different groups.', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Fill in the form below to add a subscriber. You can assign the subscriber to one or multiple different groups.', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Update subscriber', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'These tokens will be replaced by the actual subscriber''s data.<br /><br />\r\n<label>{FirstName}</label>\r\n<label>{LastName}</label>\r\n<label>{Email}</label>\r\n<label>{Phone}</label>\r\n<label>{Website}</label>\r\n<label>{Gender}</label>\r\n<label>{Age}</label>\r\n<label>{Birthday}</label>\r\n<label>{Address}</label>\r\n<label>{City}</label>\r\n<label>{State}</label>\r\n<label>{Country}</label>\r\n<label>{Zip}</label>\r\n<label>{CompanyName}</label>\r\n<label>{Unsubscribe}</label>', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'E-Mail queue', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'This is the queue for your messages. You can find messages which have already been sent and messages which are still not sent but will be in the future. You can delete any of the messages from the queue.', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Groups', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'You can organize the subscribers in groups. Create as many groups as you want and assign each subscriber to one or multiple groups. Later you can send messages to specific groups only. Each group has own registration form so people can subscribe to specific group only.', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Add a group', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Enter group name and click on "Save" button. On next screen you will be able to set various option for the group - subscribers'' data to be collected, confirmation and autoresponder messages, subscription form code.', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Update group', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'Open the tabs below to change different settings for this group.', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'ID', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'File with extension is not allowed to upload.', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Messages sent', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'Duplicate', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Copy', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'Make a message copy', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'Are you sure that you want to make a copy of the message?', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Add to group', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Assign to group', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'Please select group(s) below to assign selected subscribers into.', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'Send message', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'Subscribers data', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'Subscribers data', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'Select the fields that this group''s subscribers should fill in on the subscription form.', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'Subscriber data saved', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'All changes made to subscriber data have been saved.', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'Group details', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'Subscription form', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Please select at least one field.', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Confirm subscription', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Send autoresponder', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'Confirm subscription', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'If you check "Confirm subscription" then people who subscribe for this group will receive a confirmation message you a link in it. They should click on the link to confirm their subscription.', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'Autoresponder', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'You can send a message to every person who subscribes for this group. Check "Send autoresponder" and fill in message details and the message will be sent to everyone who fill in and submit the subscription form.', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'Subscription form', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Copy the code below and put it on your web page. It will show a subscription form which people will use to subscribe to this group. Make sure the code is put on a web page on the same domain where script is installed or it will not load correctly.', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Subscription form', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Gender', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Age', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Birthday', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Company name', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Subscribe', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'First name is required.', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Last name is required.', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Email is required.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Phone is required.', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'Website is required.', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Gender is required.', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Age is required.', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'Birthday is required.', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Address is required.', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'City is required.', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'State is required.', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Country is required.', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'Captcha is required.', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Company name is required.', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Email address is invalid.', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Email address was already in use.', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Birthday is invalid.', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Subscription form is processing...', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'Subscription form was failed to save.', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Subscription form has been saved.', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Zip is required.', 'script'),
(NULL, 587, 'pjField', 1, 'title', '<label>{ConfirmURL}</label>', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Your subscription has been confirmed successfully.', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Sorry! we cannot find out your subscription on the system.', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Your subscription was already confirmed.', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Day', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'Month', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Year', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'There are no messages.', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Add a message', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'Save and Send', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Please set the status of this group to be active if you want to see the installation code. It is because we cannot show the subscription form of an inactive group on the front-end.', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'The form could not be loaded because the group you subscribe for is not active.', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Sorry! we cannot find out your subscription on the system.', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Your subscription was already un-subscribed.', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'Your subscription has been un-subscribed.', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'Cron script', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'You need to set up a cron job using your hosting account control panel which should execute every 5 or 10 minutes. On most hosting accounts you should use the line next to "Cron script" to set up the cron job.', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'Cron script', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'Server Path', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'Message not sent', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'The message could not be sent because there is no subscribers selected.', 'script');