<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAppController extends pjController
{
	public $models = array();

	public $defaultLocale = 'admin_locale_id';
	
	public $defaultFields = 'fields';
	
	public $defaultFieldsIndex = 'fields_index';
		
	protected function loadSetFields($force=FALSE, $locale_id=NULL, $fields=NULL)
	{
		if (is_null($locale_id))
		{
			$locale_id = $this->getLocaleId();
		}
		
		if (is_null($fields))
		{
			$fields = $this->defaultFields;
		}
		
		$registry = pjRegistry::getInstance();
		if ($force
				|| !isset($_SESSION[$this->defaultFieldsIndex])
				|| $_SESSION[$this->defaultFieldsIndex] != $this->option_arr['o_fields_index']
				|| !isset($_SESSION[$fields])
				|| empty($_SESSION[$fields]))
		{
			pjAppController::setFields($locale_id);
	
			# Update session
			if ($registry->is('fields'))
			{
				$_SESSION[$fields] = $registry->get('fields');
			}
			$_SESSION[$this->defaultFieldsIndex] = $this->option_arr['o_fields_index'];
		}
	
		if (isset($_SESSION[$fields]) && !empty($_SESSION[$fields]))
		{
			# Load fields from session
			$registry->set('fields', $_SESSION[$fields]);
		}
		
		return TRUE;
	}
	
	public function isOneAdminReady()
	{
		return $this->isAdmin();
	}
	
	public static function setTimezone($timezone="UTC")
    {
    	if (in_array(version_compare(phpversion(), '5.1.0'), array(0,1)))
		{
			date_default_timezone_set($timezone);
		} else {
			$safe_mode = ini_get('safe_mode');
			if ($safe_mode)
			{
				putenv("TZ=".$timezone);
			}
		}
    }

	public static function setMySQLServerTime($offset="-0:00")
    {
		pjAppModel::factory()->prepare("SET SESSION time_zone = :offset;")->exec(compact('offset'));
    }
    
	public function setTime()
	{
		if (isset($this->option_arr['o_timezone']))
		{
			$offset = $this->option_arr['o_timezone'] / 3600;
			if ($offset > 0)
			{
				$offset = "-".$offset;
			} elseif ($offset < 0) {
				$offset = "+".abs($offset);
			} elseif ($offset === 0) {
				$offset = "+0";
			}
	
			pjAppController::setTimezone('Etc/GMT' . $offset);
			if (strpos($offset, '-') !== false)
			{
				$offset = str_replace('-', '+', $offset);
			} elseif (strpos($offset, '+') !== false) {
				$offset = str_replace('+', '-', $offset);
			}
			pjAppController::setMySQLServerTime($offset . ":00");
		}
	}
    
    public function beforeFilter()
    {
    	$this->appendJs('jquery.min.js', PJ_THIRD_PARTY_PATH . 'jquery/');
		$dm = new pjDependencyManager(PJ_INSTALL_PATH, PJ_THIRD_PARTY_PATH);
		$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
		$this->appendJs('jquery-migrate.min.js', $dm->getPath('jquery_migrate'), FALSE, FALSE);
		$this->appendJs('pjAdminCore.js');
		$this->appendCss('reset.css');
		 
		$this->appendJs('js/jquery-ui.custom.min.js', PJ_THIRD_PARTY_PATH . 'jquery_ui/');
		$this->appendCss('css/smoothness/jquery-ui.min.css', PJ_THIRD_PARTY_PATH . 'jquery_ui/');
				
		$this->appendCss('pj-all.css', PJ_FRAMEWORK_LIBS_PATH . 'pj/css/');
		$this->appendCss('admin.css');
		
    	if ($_GET['controller'] != 'pjInstaller')
		{
			$this->models['Option'] = pjOptionModel::factory();
			$this->option_arr = $this->models['Option']->getPairs($this->getForeignId());
			$this->set('option_arr', $this->option_arr);
			$this->setTime();
			
			if (!isset($_SESSION[$this->defaultLocale]))
			{
				$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
				if (count($locale_arr) === 1)
				{
					$this->setLocaleId($locale_arr[0]['id']);
				}
			}
			$this->loadSetFields();
		}
    }
    
    public function getForeignId()
    {
    	return 1;
    }
    
    public static function setFields($locale)
    {
    	if(isset($_SESSION['lang_show_id']) && (int) $_SESSION['lang_show_id'] == 1)
		{
			$fields = pjMultiLangModel::factory()
				->select('CONCAT(t1.content, CONCAT(":", t2.id, ":")) AS content, t2.key')
				->join('pjField', "t2.id=t1.foreign_id", 'inner')
				->where('t1.locale', $locale)
				->where('t1.model', 'pjField')
				->where('t1.field', 'title')
				->findAll()
				->getDataPair('key', 'content');
		}else{
			$fields = pjMultiLangModel::factory()
				->select('t1.content, t2.key')
				->join('pjField', "t2.id=t1.foreign_id", 'inner')
				->where('t1.locale', $locale)
				->where('t1.model', 'pjField')
				->where('t1.field', 'title')
				->findAll()
				->getDataPair('key', 'content');
		}
		$registry = pjRegistry::getInstance();
		$tmp = array();
		if ($registry->is('fields'))
		{
			$tmp = $registry->get('fields');
		}
		$arrays = array();
		foreach ($fields as $key => $value)
		{
			if (strpos($key, '_ARRAY_') !== false)
			{
				list($prefix, $suffix) = explode("_ARRAY_", $key);
				if (!isset($arrays[$prefix]))
				{
					$arrays[$prefix] = array();
				}
				$arrays[$prefix][$suffix] = $value;
			}
		}
		require PJ_CONFIG_PATH . 'settings.inc.php';
		$fields = array_merge($tmp, $fields, $settings, $arrays);
		$registry->set('fields', $fields);
    }

    public static function jsonDecode($str)
	{
		$Services_JSON = new pjServices_JSON();
		return $Services_JSON->decode($str);
	}
	
	public static function jsonEncode($arr)
	{
		$Services_JSON = new pjServices_JSON();
		return $Services_JSON->encode($arr);
	}
	
	public static function jsonResponse($arr)
	{
		header("Content-Type: application/json; charset=utf-8");
		echo pjAppController::jsonEncode($arr);
		exit;
	}

	public function getLocaleId()
	{
		return isset($_SESSION[$this->defaultLocale]) && (int) $_SESSION[$this->defaultLocale] > 0 ? (int) $_SESSION[$this->defaultLocale] : false;
	}
	
	public function setLocaleId($locale_id)
	{
		$_SESSION[$this->defaultLocale] = (int) $locale_id;
	}
	
	public function pjActionCheckInstall()
	{
		$this->setLayout('pjActionEmpty');
	
		$result = array('status' => 'OK', 'code' => 200, 'text' => 'Operation succeeded', 'info' => array());
		$folders = array(
				'app/web/upload',
				'app/web/upload/files'
		);
		foreach ($folders as $dir)
		{
			if (!is_writable($dir))
			{
				$result['status'] = 'ERR';
				$result['code'] = 101;
				$result['text'] = 'Permission requirement';
				$result['info'][] = sprintf('Folder \'<span class="bold">%1$s</span>\' is not writable. You need to set write permissions (chmod 777) to directory located at \'<span class="bold">%1$s</span>\'', $dir);
			}
		}
	
		return $result;
	}
	
	public function friendlyURL($str, $divider='-')
	{
		$str = mb_strtolower($str, mb_detect_encoding($str));
		$str = trim($str);
		$str = preg_replace('/[_|\s]+/', $divider, $str);
		$str = preg_replace('/\x{00C5}/u', 'AA', $str);
		$str = preg_replace('/\x{00C6}/u', 'AE', $str);
		$str = preg_replace('/\x{00D8}/u', 'OE', $str);
		$str = preg_replace('/\x{00E5}/u', 'aa', $str);
		$str = preg_replace('/\x{00E6}/u', 'ae', $str);
		$str = preg_replace('/\x{00F8}/u', 'oe', $str);
		$str = preg_replace('/[^a-z\x{0400}-\x{04FF}0-9-]+/u', '', $str);
		$str = preg_replace('/[-]+/', $divider, $str);
		$str = preg_replace('/^-+|-+$/', '', $str);
		return $str;
	}
	
	public function loadCSV($file)
	{
		$pjUpload = new pjUpload();
		$pjUpload->setAllowedExt(array('csv'));

		$data = array();
		if ($pjUpload->load($file))
		{
			$filename = $pjUpload->getFile('tmp_name');
			$i = 1;
			if (($handle = fopen($filename, "r")) !== FALSE)
			{
				while (($values = fgetcsv($handle, 1000, ",")) !== FALSE)
				{
					if ($i == 1)
					{
						$keys = $values;
					} else {
						$data[] = array_combine($keys, $values);
					}
					$i++;
				}
				fclose($handle);
			}
		}
		return $data;
	}
	
	public function getFromEmailInfo()
	{
		$arr = pjUserModel::factory()->where('role_id', 1)->findAll()->getData();
		$email = 'admin@admin.com';
		$name = NULL;
		if(!empty($arr)){
			$email = $arr[0]['email'];
			$name = $arr[0]['name'];
		}
		return compact('email', 'name');
	}
	
	public function getData($subscriber, $option_arr, $salt, $is_plain, $group_id = null)
	{
		$website = '';
		$birthday = '';
		$gender = '';
		if(!empty($subscriber['website']))
		{
			$website = '<a href="'.$subscriber['website'].'">'.$subscriber['website'].'</a>';
		}
		$gender_arr = __('genderarr', true);
		if(!empty($subscriber['gender']))
		{
			$gender = $gender_arr[$subscriber['gender']];
		}
		if(!empty($subscriber['birthday']))
		{
			$birthday = pjUtil::formatDate(date('Y-m-d', strtotime($subscriber['birthday'])), 'Y-m-d', $option_arr['o_date_format']);
		}
		$hash = md5($salt . $subscriber['id']);
		$unsubscribeURL = PJ_INSTALL_URL.'index.php?controller=pjFront&action=pjActionUnsubscribe&id='.$subscriber['id'].'&hash='.$hash;
		$plain_unsubscribeURL = $unsubscribeURL;
		$unsubscribeURL = '<a href="'.$unsubscribeURL.'">'.$unsubscribeURL.'</a>';
		if($group_id != null && intval($group_id) > 0)
		{
			$confirmURL = PJ_INSTALL_URL.'index.php?controller=pjFront&action=pjActionConfirm&id='.$subscriber['id'].'&group_id='.$group_id.'&hash='.$hash;
		}else{
			$confirmURL = '';
		}
		
		$search = array('{FirstName}', '{LastName}', '{Email}', '{Phone}', '{Website}', '{Gender}', '{Age}', '{Birthday}', '{Address}', '{City}', '{State}', '{Country}', '{Zip}', '{CompanyName}', '{Unsubscribe}', '{ConfirmURL}');
		if($is_plain == true)
		{
			$replace = array($subscriber['first_name'], $subscriber['last_name'], $subscriber['email'], $subscriber['phone'], $website, $gender, $subscriber['age'], $birthday, $subscriber['address'], $subscriber['city'], $subscriber['state'], $subscriber['country_title'], $subscriber['zip'], $subscriber['company_name'], $plain_unsubscribeURL, $confirmURL);
		}else{
			$replace = array($subscriber['first_name'], $subscriber['last_name'], $subscriber['email'], $subscriber['phone'], $website, $gender, $subscriber['age'], $birthday, $subscriber['address'], $subscriber['city'], $subscriber['state'], $subscriber['country_title'], $subscriber['zip'], $subscriber['company_name'], $unsubscribeURL, $confirmURL);
		}
		
		return compact('search', 'replace');
	}
	
	public function sendMessage($to, $subject, $message, $plain_message, $option_arr, $file_arr)
	{
		$pjEmail = new pjEmail();
		if ($option_arr['o_send_email'] == 'smtp')
		{
			$pjEmail
				->setTransport('smtp')
				->setSmtpHost($option_arr['o_smtp_host'])
				->setSmtpPort($option_arr['o_smtp_port'])
				->setSmtpUser($option_arr['o_smtp_user'])
				->setSmtpPass($option_arr['o_smtp_pass'])
				->setSender($option_arr['o_smtp_user']);
		}
		
		$from_email_info = $this->getFromEmailInfo();
		
		$pjEmail->setContentType('text/html')
				->setSubject($subject)
				->detach()
				->addPart($plain_message, 'text/plain')
				->setFrom($from_email_info['email'], $from_email_info['name']);
		if(!empty($file_arr))
		{
			foreach($file_arr as $f)
			{
				$pjEmail->attach($f['file_path'], $f['file_name'], $f['mime_type']);
			}
		}
		$pjEmail->setTo($to)
				->send($message);
	}
	
	public function sendConfirm($to, $subject, $message, $option_arr)
	{
		$pjEmail = new pjEmail();
		$pjEmail->setContentType('text/html');
		if ($option_arr['o_send_email'] == 'smtp')
		{
			$pjEmail
				->setTransport('smtp')
				->setSmtpHost($option_arr['o_smtp_host'])
				->setSmtpPort($option_arr['o_smtp_port'])
				->setSmtpUser($option_arr['o_smtp_user'])
				->setSmtpPass($option_arr['o_smtp_pass'])
				->setSender($option_arr['o_smtp_user'])
			;
		}
		
		$from_email_info = $this->getFromEmailInfo();
		
		$pjEmail->setFrom($from_email_info['email'], $from_email_info['name'])
				->setTo($to)
				->setSubject($subject)
				->send(pjUtil::textToHtml($message));
	}
}
?>