<?php
mt_srand();
$index = mt_rand(1, 9999);
$front_required = __('front_required', true);
$front_validation = __('front_validation', true); 

foreach ($front_required as $k => $v) {
	$front_required[$k] = htmlspecialchars($v, ENT_QUOTES);
}
foreach ($front_validation as $k => $v) {
	$front_validation[$k] = htmlspecialchars($v, ENT_QUOTES);
}
$validate = str_replace(array('"', "'"), array('\"', "\'"), __('front_validation', true, true));
$theme = isset($_GET['theme']) ? $_GET['theme'] : $tpl['option_arr']['o_theme'];
if((int) $theme > 0)
{
	$theme = 'theme' . $theme;
}
?>
<div id="pjWrapperNewsletter_<?php echo $theme;?>">
	<div class="container-fluid pjCfContainer nsl-form-container">
		<br>
		<div class="panel panel-default pjCfForm">
			<div class="panel-heading pjCfFormHead">
				<strong class="pjCfFormTitle"><?php __('front_label_form');?></strong>
			</div><!-- /.panel-heading pjCfFormHead -->
			<div class="panel-body pjCfFormBody">
				<form action="" method="post" id="nsl_subscribe_form_<?php echo $index;?>" name="nsl-subscribe-form_<?php echo $index;?>" class="form-horizontal nsl-form" novalidate="true" data-toggle="validator" role="form" >
					<?php
					if(isset($_GET['group_id']))
					{	 
						?>
						<input type="hidden" name="group_id" value="<?php echo $_GET['group_id'];?>"/>
						<?php
					}else{
						?>
						<div class="form-group">
							<label class="col-sm-3 control-label"><?php __('front_label_select_list');?></label>
							
							<div class="col-sm-9">
								<select name="group_id" class="form-control nsl-select required" lang="<?php echo ($front_required['list']); ?>">
									<option value="">-- <?php __('front_label_choose'); ?>--</option>
									<?php
									foreach ($tpl['group_arr'] as $k => $v)
									{
										?><option value="<?php echo $v['id']; ?>"><?php echo $v['group_title']; ?></option><?php
									}
									?>
								</select>
							</div>
						</div>
						<?php
					}
					?>
					<div id="nsl_form_field_<?php echo $index;?>">
						<?php
						include_once PJ_VIEWS_PATH . 'pjFront/elements/fields.php';
						?>
					</div>
				</form>
			</div>
		</div>
	</div>	
</div>

<script type="text/javascript">
	var stivaObj_<?php echo $index;?> = new stivaNSL({
		subscribe_form_name: "nsl-subscribe-form_<?php echo $index;?>",
		subscribe_form_subscribe_name: "nsl_subscribe_form_subscribe_<?php echo $index;?>",

		check_email_url: "<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&action=pjActionCheckEmail",
		check_captcha_url: "<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&action=pjActionCheckCaptcha",
		subscribe_url: "<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&action=pjActionFormSave",
		load_field_url: "<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&action=pjActionLoadField",
		load_captcha_url: "<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&action=pjActionCaptcha&rand=",

		index: "<?php echo $index;?>",
		group_id: "<?php echo isset($_GET['group_id']) ? $_GET['group_id'] : null;?>",
		validate: <?php echo pjAppController::jsonEncode($validate); ?>,		
		validation: {
			error_email_invalid: "<?php echo $front_validation['email_invalid']; ?>",
			error_email_used: "<?php echo $front_validation['email_used']; ?>",
			error_birthday_invalid: "<?php echo $front_validation['birthday_invalid']; ?>",
			error_captcha_incorrect: "<?php echo $front_validation['captcha_incorrect']; ?>"
		},
		message: {
			info: "<?php echo pjSanitize::clean(__('front_label_subscribe_info', true)); ?>",
			success: "<?php echo pjSanitize::clean(__('front_label_subscribe_success', true)); ?>",
			error: "<?php echo pjSanitize::clean(__('front_label_subscribe_error', true)); ?>"
		}
	});
</script>