var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmCreateGallery = $("#frmCreateGallery"),
			$frmUpdateGallery = $("#frmUpdateGallery"),
			chosen = ($.fn.chosen !== undefined),
			gallery = ($.fn.gallery !== undefined),
			$gallery = $("#gallery"),
			tipsy = ($.fn.tipsy !== undefined),
			tabs = ($.fn.tabs !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			$tabs = $("#tabs"),
			tOpt = {
				activate: function (event, ui) {
					$(":input[name='tab_id']").val($(ui.newPanel).prop('id'));
				}
			};
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs(tOpt);
		}
		if (chosen) {
			$("#user_id").chosen();
		}
		if (tipsy) {
			$(".listing-tip").tipsy({
				offset: 1,
				opacity: 1,
				html: true,
				gravity: "nw",
				className: "tipsy-listing"
			});
		}
		$(".field-int").spinner({
			min: 0,
			stop:function(e,ui){
				if($(this).hasClass('pjPgRatioCustom'))
				{
					calculateCustom();
				}
		    }
		});
		if($("#slider").length > 0)
		{
			$( "#slider" ).slider({
				min: 1000,
				max: 10000,
				value: myLabel.slider_value,
				step: 500,
				slide: function( event, ui ) {
					$("#slideshow_speed").val(ui.value);
					$('#slideshow_speed_label').html((ui.value / 1000).toFixed(1));
					
				}
			});
		}
		if ($gallery.length > 0 && gallery) {
			$gallery.gallery({
				compressUrl: "index.php?controller=pjGallery&action=pjActionCompressGallery&model=pjGalleryMain&foreign_id=" + myGallery.foreign_id + "&hash=" + myGallery.hash,
				getUrl: "index.php?controller=pjGallery&action=pjActionGetGallery&model=pjGalleryMain&foreign_id=" + myGallery.foreign_id + "&hash=" + myGallery.hash,
				deleteUrl: "index.php?controller=pjGallery&action=pjActionDeleteGallery",
				emptyUrl: "index.php?controller=pjGallery&action=pjActionEmptyGallery&model=pjGalleryMain&foreign_id=" + myGallery.foreign_id + "&hash=" + myGallery.hash,
				rebuildUrl: "index.php?controller=pjGallery&action=pjActionRebuildGallery&model=pjGalleryMain&foreign_id=" + myGallery.foreign_id + "&hash=" + myGallery.hash,
				resizeUrl: "index.php?controller=pjGallery&action=pjActionCrop&model=pjGalleryMain&id={:id}&foreign_id=" + myGallery.foreign_id + "&hash=" + myGallery.hash + ($frmUpdateGallery.length > 0 ? "&query_string=" + encodeURIComponent("controller=pjAdminGalleries&action=pjActionUpdate&id=" + myGallery.foreign_id + "&tab_id=tabs-1") : ""),
				sortUrl: "index.php?controller=pjGallery&action=pjActionSortGallery",
				updateUrl: "index.php?controller=pjGallery&action=pjActionUpdateGallery",
				uploadUrl: "index.php?controller=pjGallery&action=pjActionUploadGallery&model=pjGalleryMain&foreign_id=" + myGallery.foreign_id + "&hash=" + myGallery.hash,
				watermarkUrl: "index.php?controller=pjGallery&action=pjActionWatermarkGallery&model=pjGalleryMain&foreign_id=" + myGallery.foreign_id + "&hash=" + myGallery.hash
			});
		}
		if ($frmCreateGallery.length > 0) {
			$frmCreateGallery.validate({
				rules: {
					"name": {
						required: true,
						remote: "index.php?controller=pjAdminGalleries&action=pjActionCheckName"
					}
				},
				messages: {
					"name": {
						remote: myLabel.same_gallery
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		if ($frmUpdateGallery.length > 0) {
			$frmUpdateGallery.validate({
				rules: {
					"name": {
						required: true,
						remote: "index.php?controller=pjAdminGalleries&action=pjActionCheckName&id=" + $frmUpdateGallery.find("input[name='id']").val()
					}
				},
				messages: {
					"name": {
						remote: myLabel.same_gallery
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				submitHandler: function(form)
				{
					$('.pjPgBtnSubmit').val($('.pjPgBtnSubmit').attr('data-saving'));
					$frmUpdateGallery.find('.pj-button').attr('disabled', 'disabled');
					form.submit();
				}
			});
			updatePreviewURL(false);
		}
		function formatImage(val, obj) {
			if(val != '')
			{
				return ['<a href="index.php?controller=pjAdminGalleries&action=pjActionUpdate&id=', obj.id ,'" class="pjPgGalleryThumb">'+val+'</a>'].join("");
			}else{
				return ['<a href="index.php?controller=pjAdminGalleries&action=pjActionUpdate&id=', obj.id ,'"><img src="app/web/img/no_image.png" style="width: 100px" /></a>'].join("");
			}
		}
		if ($("#grid").length > 0 && datagrid) {
			var gridOpts = {
				buttons: [{type: "edit", url: "index.php?controller=pjAdminGalleries&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminGalleries&action=pjActionDeleteGallery&id={:id}"},
				          {type: "options", url: "index.php?controller=pjAdminGalleries&action=pjActionUpdate&id={:id}&tab_id=tabs-2"},
				          {type: "install", url: "index.php?controller=pjAdminGalleries&action=pjActionUpdate&id={:id}&tab_id=tabs-3"},
				          {type: "view pj-button", url: "preview.php?id={:id}", target: "_blank"},
				          ],
				columns: [{text: myLabel.thumb, type: "text", width: 225, sortable: false, editable: false, renderer: formatImage},
				          {text: myLabel.name, type: "text", sortable: true, editable: true, width: 170, editableWidth: 150},
				          {text: myLabel.photos, type: "text", sortable: true, editable: false, width: 60, align: 'center'},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 90, options: [
				                                                                                     {label: myLabel.active, value: "T"}, 
				                                                                                     {label: myLabel.inactive, value: "F"}
				                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminGalleries&action=pjActionGetGallery",
				dataType: "json",
				fields: ['image', 'name', 'photos', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminGalleries&action=pjActionDeleteGalleryBulk", render: true, confirmation: myLabel.delete_confirmation},
					   {text: myLabel.revert_status, url: "index.php?controller=pjAdminGalleries&action=pjActionStatusGallery", render: true},
					   {text: myLabel.exported, url: "index.php?controller=pjAdminGalleries&action=pjActionExportGallery", ajax: false}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminGalleries&action=pjActionSaveGallery&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				},
				onRender: function () {
					$("#grid").find('.pj-table-icon-view').text(myLabel.preview);
				}
			};
			if (pjGrid.roleId === 2) {
				gridOpts = {
					buttons: [{type: "edit", url: "index.php?controller=pjAdminGalleries&action=pjActionUpdate&id={:id}"},
					          {type: "options", url: "index.php?controller=pjAdminGalleries&action=pjActionUpdate&id={:id}&tab_id=tabs-2"},
					          {type: "install", url: "index.php?controller=pjAdminGalleries&action=pjActionUpdate&id={:id}&tab_id=tabs-3"},
					          {type: "view pj-button editor", url: "index.php?controller=pjAdminOptions&action=pjActionPreview&id={:id}", target: "_blank"}
					          ],
					columns: [{text: myLabel.thumb, type: "text", width: 225, sortable: false, editable: false, renderer: formatImage},
					          {text: myLabel.name, type: "text", sortable: true, editable: false, width: 170},
					          {text: myLabel.photos, type: "text", sortable: true, editable: false, width: 60, align: 'center'},
					          {text: myLabel.status, type: "select", sortable: true, editable: false, width: 90, options: [
					                                                                                     {label: myLabel.active, value: "T"}, 
					                                                                                     {label: myLabel.inactive, value: "F"}
					                                                                                     ], applyClass: "pj-status"}],
					dataUrl: "index.php?controller=pjAdminGalleries&action=pjActionGetGallery",
					dataType: "json",
					fields: ['image', 'name', 'photos', 'status'],
					paginator: {
						actions: [
						   {text: myLabel.exported, url: "index.php?controller=pjAdminGalleries&action=pjActionExportGallery", ajax: false}
						],
						gotoPage: true,
						paginate: true,
						total: true,
						rowCount: true
					},
					saveUrl: "index.php?controller=pjAdminGalleries&action=pjActionSaveGallery&id={:id}",
					select: {
						field: "id",
						name: "record[]"
					},
					onRender: function () {
						$("#grid").find('.pj-table-icon-view').text(myLabel.preview);
					}
				};
			}
			var $grid = $("#grid").datagrid(gridOpts);
			
		}
		function updatePreviewURL(get_size)
		{
			var layout = $('#layout').val();
			
			if(get_size == true)
			{
				$.get("index.php?controller=pjAdminGalleries&action=pjActionGetSizes&layout=" + layout).done(function (data) {
		    		$('#pjPgRecommendedSizes').html(data);
		    		calculateRatio();
				}).fail(function () {
					
				});
			}
		}
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminGalleries&action=pjActionGetGallery", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminGalleries&action=pjActionGetGallery", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".pj-status-1", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			return false;
		}).on("click", ".pj-status-0", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$.post("index.php?controller=pjAdminGalleries&action=pjActionSetActive", {
				id: $(this).closest("tr").data("object")['id']
			}).done(function (data) {
				$grid.datagrid("load", "index.php?controller=pjAdminGalleries&action=pjActionGetGallery");
			});
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminGalleries&action=pjActionGetGallery", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("focusin", ".textarea_install", function (e) {
			$(this).select();
		}).on("change", "#layout", function (e) {
			updatePreviewURL(true);
			$('#pjPgPreviewHint').css('display', 'inline-block');
			$('#pjPgPreviewButton').css('display', 'none');
			if($(this).val() == '9')
			{
				$('.pjPgSlider').hide();
			}else{
				$('.pjPgSlider').show();
			}
			return false;
		}).on("keydown", ".pjPgDigits", function (e) {
			if (e.shiftKey == true) {
                e.preventDefault();
            }
			if ((e.keyCode >= 48 && e.keyCode <= 57) || (e.keyCode >= 96 && e.keyCode <= 105) || e.keyCode == 8 || e.keyCode == 9 || e.keyCode == 37 || e.keyCode == 39 || e.keyCode == 46) {
				
            } else {
            	e.preventDefault();
            } 
		}).on("change", "input:radio[name='ratio']", function (e) {
			if($(this).val() == 'advanced')
			{
				$('.pjPgCustomWrapper').show();
				$('#custom_width').val(1);
				$('#custom_height').val(1);
				$('#max_width').val(800);
				calculateCustom();
			}else{
				$('.pjPgCustomWrapper').hide();
				calculateRatio();
			}
			return false;
		}).on("click", ".pj-use-theme", function (e) {
			var id = $(this).attr('data-id'),
				layout = $(this).attr('data-layout');
			$('.pj-loader').css('display', 'block');
			$.ajax({
				type: "GET",
				async: false,
				url: 'index.php?controller=pjAdminGalleries&action=pjActionUpdateLayout&id='+id+'&layout=' + layout,
				success: function (data) {
					$('.theme-holder').html(data);
					$('.pj-loader').css('display', 'none');
				}
			});
		}).on("change", ".pjPgRatioCustom", function (e) {
			calculateCustom();
			return false;
		});
		
		function calculateRatio()
		{
			var $checked = $("input[type='radio']").filter(":checked");
			var ratio = parseInt($checked.attr('data-height'), 10) / parseInt($checked.attr('data-width'), 10);
			var medium_width = parseInt($checked.attr('data-max_width'), 10);
			var medium_height = parseInt(medium_width * ratio, 10);
			
			$('#preview_width').val(medium_width);
			$('#preview_height').val(medium_height);
			
			$('#pjPgPreviewHint').css('display', 'inline-block');
			$('#pjPgPreviewButton').css('display', 'none');
		}
		function calculateCustom()
		{
			var ratio = parseInt($('#custom_height').val(), 10) / parseInt($('#custom_width').val(), 10);
			var medium_width = parseInt($('#max_width').val(), 10);
			var medium_height = parseInt(medium_width * ratio, 10);
			
			$('#preview_width').val(medium_width);
			$('#preview_height').val(medium_height);
			
			$('#pjPgPreviewHint').css('display', 'inline-block');
			$('#pjPgPreviewButton').css('display', 'none');
		}
	});
})(jQuery_1_8_2);