(function (window, undefined){
	"use strict";
	
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	
	var document = window.document;
	
	function StivaGallery(opts) {
		if (!(this instanceof StivaGallery)) {
			return new StivaGallery(opts);
		}
		this.reset.call(this);
		this.init.call(this, opts);
		return this;
	}
	
	StivaGallery.prototype = {
		reset: function () {
			this.opts = null;
			this.$container = null;
			this.container = null;
			
			return this;
		},
		init: function (opts) {
			var self = this;
			this.opts = opts;
			this.container = document.getElementById("pjWrapperGallery_" + this.opts.gid);
			this.$container = pjQ.$(this.container);
			
			var container_str = 'pjWrapperGallery_' + self.opts.gid;
			
			this.$container;
			
			if (pjQ.$('#'+container_str+' .pjGalSlider').length) 
			{
				var $slider = pjQ.$('#'+container_str+' .pjGalSlider .pjGalSlides');
				var $sliderControls = pjQ.$('#'+container_str+' .pjGalSlider .pjGalSliderControls');
				var $sliderPrev = $sliderControls.find('.pjGalBtnPrev');
				var $sliderNext = $sliderControls.find('.pjGalBtnNext');
				var $sliderPlayPause = $sliderControls.find('.pjGalBtnPlayPause');
				var $progressBar = $sliderControls.find('.pjGalProgress');
				var playClass = 'pjGalBtnPlay';
				var pauseClass = 'pjGalBtnPause';
				var animationSpeed = 3000;
				var animationTimeOut = animationSpeed + self.opts.slide_speed;
				var progressBarIntervalSpeed = self.opts.slide_speed / 100;

				$slider.owlCarousel({
					margin: 0,
					items: 1,
					loop: true,
					dots: false,
					nav: false,
					autoHeight: true,
					autoplay: true,
					autoplayTimeout: self.opts.slide_speed,
					autoplayHoverPause: false,
					autoplaySpeed: animationSpeed,
					navSpeed: animationSpeed,
					dotsSpeed: animationSpeed,
					onTranslated: function() {
						setIntervalTimes(progressBarIntervalSpeed, 100, 0);
					}
				});

				var interval;
				setIntervalTimes((self.opts.slide_speed / 100), 100, 0);

				$sliderPrev.on('click', function(e) {
					var $currentSlider = pjQ.$(this).parents('.pjGalSlider').find('.pjGalSlides');
					$currentSlider.trigger('prev.owl.carousel', [animationSpeed]);

					e.preventDefault();
				});

				$sliderNext.on('click', function(e) {
					var $currentSlider = pjQ.$(this).parents('.pjGalSlider').find('.pjGalSlides');
					$currentSlider.trigger('next.owl.carousel', [animationSpeed]);

					e.preventDefault();
				});
				
				$sliderPlayPause.on('click', function(e) {
					var $currentBtn = pjQ.$(this);
					var $currentSlider = $currentBtn.parents('.pjGalSlider').find('.pjGalSlides');

					if ($currentBtn.hasClass(playClass)) {
						$currentSlider.trigger('play.owl.autoplay', [animationTimeOut]);
						$currentSlider.trigger('next.owl.carousel', [animationSpeed]);

						$currentBtn.removeClass(playClass).addClass(pauseClass);
					} else if ($currentBtn.hasClass(pauseClass)) {
						$currentSlider.trigger('stop.owl.autoplay');

						$currentBtn.removeClass(pauseClass).addClass(playClass);

						var $progressBarCurrentPosition = $progressBar.css('right');
						$progressBar.css('right', $progressBarCurrentPosition);
						if (interval) {
							clearInterval(interval);
						};
					};

					e.preventDefault();
				});
				
				$slider.on('changed.owl.carousel', function(e) {
					pjQ.$(this).parents('.pjGalSlider').find($sliderPlayPause).removeClass(playClass).addClass(pauseClass);
				});

				$slider.on('change.owl.carousel', function(e) {
					$slider.data('owl.carousel').options.autoplayTimeout = animationTimeOut;
					$slider.data('owl.carousel').settings.autoplayTimeout = animationTimeOut;
				});
				
				function setIntervalTimes(intervalSpeed, intervalStartPosition, intervalResetPosition) {
					if (interval) {
						clearInterval(interval);
					};

					interval = setInterval(function() {
						intervalStartPosition -= 1;

						$progressBar.css('right', (intervalStartPosition + '%'));
					}, intervalSpeed);
				};
			};
		}
	};
	
	// expose
	window.StivaGallery = StivaGallery;
})(window);