(function (window, undefined){
	"use strict";
	
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	
	var document = window.document;
	var $win = pjQ.$(window);
	var $owlSliders = null;
	var gallery_id = null;
	
	var fnDoVisibleItemsCount = function(itemsWrapper, itemWidth) {
		var $itemsWrapperWidth = itemsWrapper.width();
		var visibleItemsNumber = parseInt(parseInt($itemsWrapperWidth) / parseInt(itemWidth));
		
		if (visibleItemsNumber <= 1) {
			return 1;
		} else {
			return visibleItemsNumber;
		};
	};
	function LoadResize() {
		var $slider = pjQ.$('#pjWrapperGallery_'+gallery_id+' .pjGalSlider');
		var $sliderClip = $slider.find('.pjGalSliderClip');
		var $owlSliders = $slider.find('.pjGalSlides');
		
		var newItemsNumber = fnDoVisibleItemsCount($sliderClip, 110);

		$owlSliders.data('owl.carousel').options.items = newItemsNumber;
		$owlSliders.data('owl.carousel').settings.items = newItemsNumber;
		
		$owlSliders.trigger('refresh.owl.carousel');
    }
	function StivaGallery(opts) {
		if (!(this instanceof StivaGallery)) {
			return new StivaGallery(opts);
		}
		this.reset.call(this);
		this.init.call(this, opts);
		return this;
	}
	
	StivaGallery.prototype = {
		reset: function () {
			this.opts = null;
			this.$container = null;
			this.container = null;
			
			this.$preview_container = null;
			this.preview_container = null;
			
			return this;
		},
		init: function (opts) {
			var self = this;
			this.opts = opts;
			
			gallery_id = self.opts.gid;
			var container_str = 'pjWrapperGallery_' + self.opts.gid;
			
			if (pjQ.$('#'+container_str+' .pjGalSlider').length) {
				var $slider = pjQ.$('#'+container_str+' .pjGalSlider');
				var $slides = $slider.find('.pjGalSlides');
				var $sliderClip = $slider.find('.pjGalSliderClip');
				var $mainImage = $slider.find('.pjGalMainImage');
				var $mainImageImg = $mainImage.find('img');
				var $mainImageTitle = $mainImage.find('.pjGalMainImageTitle');
				var $mainImage = $mainImage.find('.pjGalMainImageParagraph');
				var animationSpeed = 3000;
				var animationTimeOut = animationSpeed + self.opts.slide_speed;

				$slides.owlCarousel({
					margin: 10,
					items: fnDoVisibleItemsCount($sliderClip, 110),
					loop: true,
					dots: false,
					nav: true,
					autoHeight: false,
					autoplay: true,
					autoplayTimeout: self.opts.slide_speed,
					autoplaySpeed: animationSpeed,
					autoplayHoverPause: true,
					navSpeed: animationSpeed,
					dotsSpeed: animationSpeed,
					onChange: function() {
						$slides.data('owl.carousel').options.autoplayTimeout = animationTimeOut;
						$slides.data('owl.carousel').settings.autoplayTimeout = animationTimeOut;
					}
				});

				LoadResize();
				pjQ.$(window).bind("resize", LoadResize);
				
				pjQ.$('#'+container_str+' .pjGalSlider').on('click', '.pjGalSlideThumb', function(e) {
					var $currentThumb = pjQ.$(this);
					var $currentImageLargeSrc = $currentThumb.attr('data-imageLg');
					var $currentImageTitle = $currentThumb.attr('data-title');
					var $currentImageContent = $currentThumb.attr('data-paragraph');

					$mainImageImg.attr('src', $currentImageLargeSrc);
					$mainImageTitle.text($currentImageTitle);
					$mainImage.text($currentImageContent);

					e.preventDefault();
				});
			};
			
		}
		
	};
	
	window.StivaGallery = StivaGallery;
})(window);