(function (window, undefined){
	"use strict";
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	var document = window.document;
	
	function StivaGallery(opts) {
		if (!(this instanceof StivaGallery)) {
			return new StivaGallery(opts);
		}
		this.reset.call(this);
		this.init.call(this, opts);
		return this;
	}
	
	StivaGallery.prototype = {
		reset: function () {
			this.opts = null;
			this.$container = null;
			this.container = null;
			
			return this;
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			
			var container_str = 'pjWrapperGallery_' + self.opts.gid;
			
			if (pjQ.$('#'+container_str+' .pjGalSlider').length) 
			{
				var $slider = pjQ.$('#'+container_str+' .pjGalSlider');
				var $slides = $slider.find('.pjGalSlides');
				var $sliderControls = $slider.find('.pjGalSliderControls');
				var $sliderOverlay = $slider.find('.pjGalSliderOverlay');
				var sliderOverlayActiveClass = 'pjGalSliderOverlayActive';
				var $sliderTitle = $slider.find('.pjGalSliderMainTitle');
				var $sliderParagraph = $slider.find('.pjGalSliderMainParagraph');
				var $sliderClip = $slider.find('.pjGalSliderClip');
				var itemsNumber;
				var animationSpeed = 3000;
				var animationTimeOut = animationSpeed + self.opts.slide_speed;

				if ($sliderClip.width() <= 720) {
					itemsNumber = 1

					$slider.addClass('pjGalSliderOnlyOne');
				} else {
					itemsNumber = 2
					$slider.removeClass('pjGalSliderOnlyOne');
				};

				$slider.on('initialized.owl.carousel', function(event) {
					var $firstSlideTitle = $slides.find('.owl-item.active').first().find('.pjGalSlideTitle').text()
					var $firstSlideParagraph = $slides.find('.owl-item.active').first().find('.pjGalSlideParagraph').text();

					$sliderTitle.text($firstSlideTitle);
					$sliderParagraph.text($firstSlideParagraph);
					$sliderOverlay.addClass(sliderOverlayActiveClass);
				});

				$slides.owlCarousel({
					margin: 0,
					loop: true,
					dots: false,
					nav: false,
					autoHeight: true,
					autoplay: true,
					autoplayTimeout: self.opts.slide_speed,
					autoplaySpeed: animationSpeed,
					autoplayHoverPause: true,
					navSpeed: animationSpeed,
					dotsSpeed: animationSpeed,
					responsive: {
						0: {
							items: 1
						},
						720: {
							items: 1
						},
						721: {
							items: itemsNumber
						}
					},
					onChange: function() {
						$slides.data('owl.carousel').options.autoplayTimeout = animationTimeOut;
						$slides.data('owl.carousel').settings.autoplayTimeout = animationTimeOut;
					}
				});

				$slider.on('mouseover mouseout', function(e) {
					if (e.type === 'mouseover') {
						$slides.trigger('stop.owl.autoplay');
						$slides.trigger('play.owl.autoplay', [animationTimeOut]);
						$slides.trigger('stop.owl.autoplay');
					} else if (e.type === 'mouseout') {
						$slides.trigger('play.owl.autoplay', [animationTimeOut]);
					};
				});

				$sliderControls.on('click', '.pjGalBtn', function(e) {
					var $currentBtn = pjQ.$(this);

					if ($currentBtn.hasClass('pjGalBtnPrev')) {
						$slides.trigger('prev.owl.carousel', [animationSpeed]);
					} else if ($currentBtn.hasClass('pjGalBtnNext')) {
						$slides.trigger('next.owl.carousel', [animationSpeed]);
					};

					e.preventDefault();
				});

				$slider.on('translate.owl.carousel', function(event) {
					$sliderTitle.empty();
					$sliderParagraph.empty();
					$sliderOverlay.removeClass(sliderOverlayActiveClass);
				});

				$slider.on('translated.owl.carousel', function(event) {
					var $firstSlideTitle = $slides.find('.owl-item.active').first().find('.pjGalSlideTitle').text()
					var $firstSlideParagraph = $slides.find('.owl-item.active').first().find('.pjGalSlideParagraph').text();

					$sliderTitle.text($firstSlideTitle);
					$sliderParagraph.text($firstSlideParagraph);
					$sliderOverlay.addClass(sliderOverlayActiveClass);
				});
			};
		}
	};
	
	// expose
	window.StivaGallery = StivaGallery;
})(window);