(function (window, undefined){
	"use strict";
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	var document = window.document;
	var $win = pjQ.$(window);
	var gallery_id = null;
	
	function StivaGallery(opts) {
		if (!(this instanceof StivaGallery)) {
			return new StivaGallery(opts);
		}
		this.reset.call(this);
		this.init.call(this, opts);
		return this;
	}

	StivaGallery.prototype = {
		reset: function () {
			this.opts = null;
			
			return this;
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			gallery_id = self.opts.gid;
			var container_str = 'pjWrapperGallery_' + self.opts.gid;
			
			var $popupTrigger = pjQ.$('#'+container_str+' .pjGalPopupTrigger');
			
			if ($popupTrigger.length) {
				var $popup = pjQ.$('#'+container_str+' .pjGalPopup');
				var popupActiveClass = 'pjGalPopupActive';
				var $currentSlider = pjQ.$('#'+container_str+' .pjGalSlider .pjGalSlides');
				
				$popupTrigger.on('click', function(e) {
					var $clickedLink = pjQ.$(this);
					var $clickedLinkHref = $clickedLink.attr('data-href');
					var $currentPopup = $popup.filter($clickedLinkHref);
					var $currentPopupContent = $currentPopup.find('.pjGalPopupContent');
					var $currentPopupContentInner = $currentPopup.find('.pjGalPopupContentInner');
					var $currentImageSrc = $clickedLink.attr('data-largeSrc');
					var $currentPopupImage = $currentPopup.find('.pjGalLargeImage img');
					
					$currentPopupImage.attr('src', $currentImageSrc);
					
					$currentPopup.addClass(popupActiveClass).width($win.width()).height($win.height());

					if (($win.height()) < ($currentPopupContentInner.height() + 90)) {
						$currentPopupContent.height($win.height() - 90);
					};

					$currentSlider.trigger('stop.owl.autoplay');

					e.preventDefault();
				});

				$popup.on('click', '.pjGalBtnPopupRemove', function(e) {
					var $currentPopup = pjQ.$(this).closest($popup);
					$currentPopup.removeClass(popupActiveClass).width(0).height(0);

					$currentSlider.trigger('play.owl.autoplay', [animationTimeOut]);

					e.preventDefault();
				});

				$popup.on('click', function(e) {
					var $currentPopup = pjQ.$(e.target);
					if ($currentPopup.hasClass(popupActiveClass)) {
						$currentPopup.removeClass(popupActiveClass).width(0).height(0);

						$currentSlider.trigger('play.owl.autoplay', [animationTimeOut]);
					};
				});

				$win.on('resize', function() {
					var $currentPopup = $popup.filter(function() {
						return pjQ.$(this).hasClass(popupActiveClass);
					});
					var $currentPopupContent = $currentPopup.find('.pjGalPopupContent');
					var $currentPopupContentInner = $currentPopup.find('.pjGalPopupContentInner');

					$currentPopup.width($win.width()).height($win.height());
					if (($win.height()) < ($currentPopupContentInner.height() + 90)) {
						$currentPopupContent.height($win.height() - 90);
					} else {
						$currentPopupContent.height('auto');
					};
				});
			};
			
			var $slider = pjQ.$('#'+container_str+' .pjGalSlider');
			var $sliderClip = $slider.find('.pjGalSliderClip');
			var $slides = $slider.find('.pjGalSlides');
			var $sliderControls = $slider.find('.pjGalSliderControls');
			var $sliderInMotion;
			var directionOutUpClass = 'slideOutUp';
			var directionInUpClass = 'slideInUp';
			var directionOutRightClass = 'slideOutRight';
			var directionInRightClass = 'slideInRight';
			var directionOutDownClass = 'slideOutDown';
			var directionInDownClass = 'slideInDown';
			var directionOutLeftClass = 'slideOutLeft';
			var directionInLeftClass = 'slideInLeft';
			var animationSpeed = 3000;
			var animationTimeOut = animationSpeed + self.opts.slide_speed;
			var numberOfSliders = $slides.find('.pjGalSlide').length;
			var is_loop = false;
			if(numberOfSliders > 1)
			{
				is_loop = true;
			}
			$slides.owlCarousel({
				items: 1,
				margin: 0,
				loop: is_loop,
				dots: false,
				nav: false,
				autoHeight: true,
				autoplay: true,
				autoplayTimeout: self.opts.slide_speed,
				autoplaySpeed: animationSpeed,
				autoplayHoverPause: true,
				navSpeed: animationSpeed,
				dotsSpeed: animationSpeed,
				onTranslate: function(e) {
					$sliderInMotion = true;
				},
				onTranslated: function(e) {
					$sliderInMotion = false;
				},
				onChange: function() {
					$slides.data('owl.carousel').options.autoplayTimeout = animationTimeOut;
					$slides.data('owl.carousel').settings.autoplayTimeout = animationTimeOut;
				}
			});

			if(numberOfSliders > 1)
			{
				$sliderControls.on('click', '.pjGalBtn', function(e) {
					var $currentBtn = pjQ.$(this);
					if ($sliderInMotion === true) {
						return false;
					} else {
						if ($currentBtn.hasClass('pjGalBtnUp')) {
							$slides.data('owl.carousel').options.animateOut = directionOutUpClass;
							$slides.data('owl.carousel').settings.animateOut = directionOutUpClass;
							$slides.data('owl.carousel').options.animateIn = directionInUpClass;
							$slides.data('owl.carousel').settings.animateIn = directionInUpClass;

							$slides.trigger('next.owl.carousel');
						} else if ($currentBtn.hasClass('pjGalBtnRight')) {
							$slides.data('owl.carousel').options.animateOut = directionOutRightClass;
							$slides.data('owl.carousel').settings.animateOut = directionOutRightClass;
							$slides.data('owl.carousel').options.animateIn = directionInLeftClass;
							$slides.data('owl.carousel').settings.animateIn = directionInLeftClass;

							$slides.trigger('next.owl.carousel');
						}  else if ($currentBtn.hasClass('pjGalBtnDown')) {
							$slides.data('owl.carousel').options.animateOut = directionOutDownClass;
							$slides.data('owl.carousel').settings.animateOut = directionOutDownClass;
							$slides.data('owl.carousel').options.animateIn = directionInDownClass;
							$slides.data('owl.carousel').settings.animateIn = directionInDownClass;

							$slides.trigger('prev.owl.carousel');
						}   else if ($currentBtn.hasClass('pjGalBtnLeft')) {
							$slides.data('owl.carousel').options.animateOut = directionOutLeftClass;
							$slides.data('owl.carousel').settings.animateOut = directionOutLeftClass;
							$slides.data('owl.carousel').options.animateIn = directionInRightClass;
							$slides.data('owl.carousel').settings.animateIn = directionInRightClass;

							$slides.trigger('prev.owl.carousel');
						};
					};

					e.preventDefault();
				});
			}
			
			$win.on('load resize', function() {
				var container_str = 'pjWrapperGallery_' + gallery_id;
				var $slider = pjQ.$('#'+container_str+' .pjGalSlider');
				var $sliderClip = $slider.find('.pjGalSliderClip');
				var $sliderThumbs = $slider.find('.pjGalSlideThumb');
				var sliderThumbsInactive = 'pjGalSlideThumbContentInactive';

				if ((($sliderClip.outerWidth()) < 510) && ((pjQ.$(this).outerWidth()) > 768)) {
					$sliderThumbs.addClass(sliderThumbsInactive);
				} else {
					$sliderThumbs.removeClass(sliderThumbsInactive);
				};
			});
		}
	};
	
	// expose
	window.StivaGallery = StivaGallery;
})(window);