(function (window, undefined){
	"use strict";
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	var document = window.document;
	var $win = pjQ.$(window);
	var gallery_id = null;
	
	function StivaGallery(opts) {
		if (!(this instanceof StivaGallery)) {
			return new StivaGallery(opts);
		}
		this.reset.call(this);
		this.init.call(this, opts);
		return this;
	}
	
	function LoadResize() {
		var $slider = pjQ.$('#pjWrapperGallery_'+gallery_id+' .pjGalSlider');
		var sliderBottomClass = 'pjGalSliderBottom';

		if ((($slider.outerWidth()) < 600) && ((pjQ.$(this).outerWidth()) > 640)) {
			$slider.addClass(sliderBottomClass);
		} else {
			$slider.removeClass(sliderBottomClass);
		};
    }
	
	StivaGallery.prototype = {
		reset: function () {
			this.opts = null;
			
			this.$preview_container = null;
			this.preview_container = null;
			
			return this;
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			
			gallery_id = self.opts.gid;
			var container_str = 'pjWrapperGallery_' + gallery_id;
			
			if (pjQ.$('#'+container_str+' .pjGalSlider').length) {
				var $slider = pjQ.$('#'+container_str+' .pjGalSlider');
				var $slides = $slider.find('.pjGalSlides');
				var $sliderPagination = $slider.find('.pjGalSliderPagination');
				var $sliderArticle = $slider.find('.pjGalSliderArticle');
				var animationSpeed = 3000;
				var animationTimeOut = animationSpeed + self.opts.slide_speed;

				$slides.owlCarousel({
					items: 1,
					margin: 0,
					loop: true,
					nav: false,
					dots: true,
					dotsContainer: $sliderPagination,
					autoHeight: true,
					autoplay: true,
					autoplayTimeout: self.opts.slide_speed,
					autoplaySpeed: animationSpeed,
					autoplayHoverPause: true,
					navSpeed: animationSpeed,
					dotsSpeed: animationSpeed,
					onChange: function() {
						$slides.data('owl.carousel').options.autoplayTimeout = animationTimeOut;
						$slides.data('owl.carousel').settings.autoplayTimeout = animationTimeOut;
					}
				});
			};
			
			$slider.on('translated.owl.carousel', function(event) {
				var $slideTitle = $slides.find('.owl-item.active').first().find('.pjGalSlideTitle').text()
				var $slideParagraph = $slides.find('.owl-item.active').first().find('.pjGalSlideParagraph').text();
				
				$sliderArticle.find('.pjGalSliderArticleTitle').html($slideTitle);
				$sliderArticle.find('.pjGalSliderArticleParagragh').html($slideParagraph);
			});
			
			LoadResize();

            pjQ.$(window).bind("load", LoadResize);
            pjQ.$(window).bind("resize", LoadResize);
		}
	};
	
	// expose
	window.StivaGallery = StivaGallery;
})(window);