<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	
	pjUtil::printNotice(__('infoAddClientTitle', true, false), __('infoAddClientDesc', true, false)); 
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionCreate" method="post" id="frmCreateClient" class="form pj-form" autocomplete="off">
		<input type="hidden" name="client_create" value="1" />
		<?php $locale = isset($_GET['locale']) && (int) $_GET['locale'] > 0 ? (int) $_GET['locale'] : @$tpl['lp_arr'][0]['id']; ?>
	
		<div class="clear_both">
			<p>
				<label class="title"><?php __('lblName'); ?></label>
				<span class="inline_block">
					<input type="text" name="name" id="name" class="pj-form-field w250 required" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblEmail'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
					<input type="text" name="email" id="email" class="pj-form-field required email w200" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblPass'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-password"></abbr></span>
					<input type="password" name="password" id="password" class="pj-form-field required w200" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblClientWebsite'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-url"></abbr></span>
					<input type="text" name="website" id="website" class="pj-form-field w200" placeholder="www.domain.com" value="" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblClientSince'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" name="client_since" id="client_since" class="pj-form-field pointer w80 datepick" value="" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
				</span>
			</p>
			<p style="overflow: visible">
				<label class="title"><?php __('lblClientCountry'); ?></label>
				<span class="inline_block" id="boxCountry">
					<select name="country_id" id="country_id" class="pj-form-field w400">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach ($tpl['country_arr'] as $v)
						{
							
							?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></option><?php
							
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblClientState'); ?></label>
				<span class="inline_block">
					<input type="text" name="state" id="state" class="pj-form-field w250" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblClientCity'); ?></label>
				<span class="inline_block">
					<input type="text" name="city" id="city" class="pj-form-field w250" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblClientAddress'); ?></label>
				<span class="inline_block">
					<input type="text" name="address" id="address" class="pj-form-field w400" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblClientPhone'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
					<input type="text" name="phone" id="phone" class="pj-form-field w150" placeholder="(123) 456-7890" value="" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblClientMobile'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
					<input type="text" name="cell_phone" id="cell_phone" class="pj-form-field w150" placeholder="(123) 456-7890" value="" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblClientFax'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
					<input type="text" name="fax" id="fax" class="pj-form-field w150" placeholder="(123) 456-7890" value="" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblClientNotes'); ?></label>
				<span class="inline_block">
					<textarea name="notes" class="pj-form-field w500 h80"></textarea>
				</span>
			</p>
			
			<p>
				<label class="title"><?php __('lblStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field required">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach (__('u_statarr', true) as $k => $v)
						{
							?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminClients&action=pjActionIndex';" />
			</p>
		</div>
	</form>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.email_taken = "<?php __('ts_email_taken'); ?>";
	myLabel.field_required = "<?php __('ts_field_required'); ?>";
	myLabel.email_invalid = "<?php __('ts_email_invalid'); ?>";
	</script>
	<?php
}
?>