<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {

	pjUtil::printNotice(__('infoAddTicketTitle', true, false), __('infoAddTicketDesc', true, false)); 
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminTickets&amp;action=pjActionCreate" method="post" id="frmCreateTicket" class="form pj-form" autocomplete="off" enctype="multipart/form-data">
		<input type="hidden" name="ticket_create" value="1" />
		
		<div class="clear_both">
			<p>
				<label class="title"><?php __('lblClient'); ?></label>
				<span class="inline_block">
					<select name="client_type" id="client_type" class="pj-form-field w200 required">
						<?php
						foreach (__('client_types', true) as $k => $v)
						{
							if($k != 'existing')
							{
								?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
							}else{
								?><option value="<?php echo $k; ?>" selected="selected"><?php echo $v; ?></option><?php
							}
						}
						?>
					</select>
				</span>
			</p>
			<div id="new_container" style="display:none;">
				<p>
					<label class="title"><?php __('lblName'); ?></label>
					<span class="inline_block">
						<input type="text" name="name" id="name" class="pj-form-field w250" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblEmail'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
						<input type="text" name="email" id="email" class="pj-form-field w200" />
					</span>
				</p>
			</div>
			<div id="existing_container" style="display:block;">
				<p>
					<label class="title">&nbsp;</label>
					<span class="inline_block">
						<select name="client_id" id="client_id" class="pj-form-field w200 required">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['client_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id']; ?>"><?php echo $v['name']; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
			</div>
			<?php
			if($tpl['option_arr']['o_select_departments'] == 'Yes')
			{ 
				?>
				<p>
					<label class="title"><?php __('lblDepartment'); ?></label>
					<?php
					if(!empty($tpl['department_arr']))
					{ 
						?>
						<span class="inline_block">
							<select name="department_id" id="department_id" class="pj-form-field w200 required">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach ($tpl['department_arr'] as $k => $v)
								{
									?><option value="<?php echo $v['id']; ?>"><?php echo $v['name']; ?></option><?php
								}
								?>
							</select>
						</span>
						<?php
					}else{
						$message = __('lblNoDepartmentMessage', true);
						$message = str_replace("{STAG}", '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminDepartments&amp;action=pjActionCreate">', $message);
						$message = str_replace("{ETAG}", '</a>', $message);
						?>
						<span class="inline_block">
							<label class="block t5"><?php echo $message;?></label>
							<input type="hidden" id="department_id" name="department_id" class="required"/>
						</span>
						<?php
					} 
					?>
				</p>
				<?php
			} 
			?>
			<p>
				<label class="title"><?php __('lblAssignedTo'); ?></label>
				<span class="inline_block">
					<select name="user_id" id="user_id" class="pj-form-field w200">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach ($tpl['user_arr'] as $k => $v)
						{
							?><option value="<?php echo $v['id']; ?>"><?php echo $v['name']; ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblSubject'); ?></label>
				<span class="inline_block">
					<input type="text" name="notes" id="notes" class="pj-form-field w400" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblTicketMessage'); ?></label>
				<span class="inline_block">
					<textarea name="message" class="pj-form-field w500 h80"></textarea>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblReplyFiles'); ?></label>
				<span class="inline_block">
					<input name="files[]" type="file" multiple="multiple"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field required">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach (__('ticket_statarr', true) as $k => $v)
						{
							?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminClients&action=pjActionIndex';" />
			</p>
		</div>
	</form>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.email_taken = "<?php __('ts_email_taken'); ?>";
	myLabel.field_required = "<?php __('ts_field_required'); ?>";
	myLabel.email_invalid = "<?php __('ts_email_invalid'); ?>";
	myLabel.file_ext = "<?php __('ts_file_ext'); ?>";
	myLabel.allowed_ext = "<?php echo implode("|", $controller->allowed_ext); ?>";
	</script>
	<?php
}
?>