<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	
	pjUtil::printNotice(__('infoEditTicketTitle', true, false), __('infoEditTicketDesc', true, false)); 
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminTickets&amp;action=pjActionUpdate" method="post" id="frmUpdateTicket" class="form pj-form">
		<input type="hidden" name="ticket_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		
		<div  class="float_left w350">
			<p>
				<label class="title"><?php __('lblDateTime'); ?></label>
				<span class="inline_block">
					<label class="block t5"><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['created'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' '. pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['created'])), 'H:i:s', $tpl['option_arr']['o_time_format']);?></label>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblIp'); ?></label>
				<span class="inline_block">
					<label class="block t5"><?php echo $tpl['arr']['ip'];?></label>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblTicketID'); ?></label>
				<span class="inline_block">
					<label class="block t5"><?php echo $tpl['arr']['ticket_id'];?></label>
				</span>
			</p>
		</div>
		<div class="float_left">
			<?php
			if(!empty($tpl['department_arr']) && $tpl['option_arr']['o_select_departments'] == 'Yes')
			{ 
				?>
				<p>
					<label class="title t5"><?php __('lblDepartment'); ?></label>
					<span class="inline_block">
						<select name="department_id" id="department_id" class="pj-form-field w200 required w142">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['department_arr'] as $k => $v)
							{
								if($tpl['arr']['department_id'] == $v['id'])
								{
									?><option value="<?php echo $v['id']; ?>" selected="selected"><?php echo $v['name']; ?></option><?php
								}else{
									?><option value="<?php echo $v['id']; ?>"><?php echo $v['name']; ?></option><?php
								}
							}
							?>
						</select>
					</span>
				</p>
				<?php
			} 
			?>
			
			<p>
				<label class="title"><?php __('lblAssignedTo'); ?></label>
				<span class="inline_block">
					<select name="user_id" id="user_id" class="pj-form-field w200">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach ($tpl['user_arr'] as $k => $v)
						{
							if($tpl['arr']['user_id'] == $v['id'])
							{
								?><option value="<?php echo $v['id']; ?>" selected="selected"><?php echo $v['name']; ?></option><?php
							}else{
								?><option value="<?php echo $v['id']; ?>"><?php echo $v['name']; ?></option><?php
							}
						}
						?>
					</select>
				</span>
			</p>
				
			<p>
				<label class="title"><?php __('lblClient'); ?></label>
				<span class="inline_block">
					<select name="client_id" id="client_id" class="pj-form-field w168 required">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach ($tpl['client_arr'] as $k => $v)
						{
							if($tpl['arr']['client_id'] == $v['id'])
							{
								?><option value="<?php echo $v['id']; ?>" selected="selected"><?php echo $v['name']; ?></option><?php
							}else{
								?><option value="<?php echo $v['id']; ?>"><?php echo $v['name']; ?></option><?php
							}
						}
						?>
					</select>
					<a href="index.php?controller=pjAdminClients&amp;action=pjActionUpdate&amp;id=<?php echo $tpl['arr']['client_id'];?>" class="pj-table-icon-edit block l10"></a>
				</span>
			</p>
		</div>
		<div class="clear_both"></div>
		
		<div  class="float_left w350">
			<?php
			$statuses = pjUtil::sortArrayByArray(__('ticket_statarr', true), array('New', 'RepliedByClient', 'RepliedBySupport', 'InProgress', 'Closed'));
			?>
			<p>
				<label class="title"><?php __('lblStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field w160 required">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach ($statuses as $k => $v)
						{
							if($tpl['arr']['status'] == $k)
							{
								?><option value="<?php echo $k; ?>" selected="selected"><?php echo $v; ?></option><?php
							}else{
								?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
							}
						}
						?>
					</select>
				</span>
			</p>
		</div>
		<?php
		if(count($tpl['last_rating']) == 1)
		{ 
			$rating_arr = __('rating_arr', true);
			?>
			<div class="float_left">
				<p>
					<label class="title"><?php __('lblLastRating'); ?></label>
					<span class="inline_block t5">
						<?php echo $rating_arr[$tpl['last_rating'][0]['rate']]; ?>
					</span>
				</p>
			</div>
			<?php
		} 
		?>
		<div class="clear_both"></div>
		<p>
			<label class="title"><?php __('lblSubject'); ?></label>
			<span class="inline_block">
				<input type="text" name="notes" id="notes" class="pj-form-field w566" value="<?php echo stripslashes($tpl['arr']['notes'])?>"/>
			</span>
		</p>
		
		<p>
			<label class="title">&nbsp;</label>
			<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
		</p>
	</form>
	<div id="message_container">
		<fieldset class="ticket-message">
			<legend><?php __('lblTicketMessage'); ?></legend>
			<?php echo nl2br(stripslashes(htmlspecialchars($tpl['arr']['message'])));?>
			<?php
			if(!empty($tpl['ticket_file_arr']))
			{
				?>
				<ul class="files">
					<?php
					foreach($tpl['ticket_file_arr'] as $f)
					{
						?>
						<li><a target="_blank" href="<?php echo PJ_INSTALL_URL;?>index.php?controller=pjAdminTickets&action=pjActionDownloadFile&id=<?php echo $f['id']; ?>"><?php echo $f['file_name'];?></a></li>
						<?php 
					}	 
					?>
				</ul>
				<?php 
			}	 
			?>
		</fieldset>
		<?php
		if(!empty($tpl['reply_arr']))
		{ 
			?>
			<fieldset class="ticket-message">
				<legend><?php __('lblAllReplies'); ?></legend>
				<?php
				foreach($tpl['reply_arr'] as $v)
				{
					$rating_arr = __('rating_arr', true);
					
					$by_name = empty($v['user_name']) ? stripslashes($v['client_name']) : stripslashes($v['user_name']);
					$file_arr = isset($tpl['reply_file_arr'][$v['id']]) ? $tpl['reply_file_arr'][$v['id']] : array();

					$rate_text = '';
					if($tpl['option_arr']['o_allow_rating'] == 'Yes')
					{
						if((int) $v['user_id'] > 0 && (int)$v['rate'] > 0)
						{
							$rate_text .= ', <span>' . __('lblRated', true) . ' ' . $rating_arr[$v['rate']] . '</span>';
						}else if((int) $v['user_id'] > 0 && (int)$v['rate'] == 0){
							$rate_text .= ', <span>' . __('lblNotRated', true) . '</span>';
						}
					}
					?>
					<div id="reply_box_<?php echo $v['id'];?>" class="reply-box">
						<div class="title">
							<p class="title-left">
								<i><?php __('lblPostedOn'); ?></i>: <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($v['created'])), "Y-m-d", $tpl['option_arr']['o_date_format']) . ', ' . date('H:i', strtotime($v['created'])); ?> <i><?php __('lblPostedBy'); ?></i> <abbr><?php echo $by_name;?><?php echo $rate_text;?></abbr>
							</p>
							<p class="title-right">
								<a href="javascript:void(0);" class="delete-reply" rev="<?php echo $v['id'];?>"><?php __('lnkDelete'); ?></a>&nbsp;/&nbsp;<a href="javascript:void(0);" class="edit-reply" rev="<?php echo $v['id'];?>"><?php __('lnkEdit'); ?></a>
							</p>
						</div>
						<div id="reply_text_<?php echo $v['id'];?>" class="content t10 b10 l5 overflow"><?php echo nl2br(stripslashes(htmlspecialchars($v['reply_text'])));?></div>
						<?php
						if(!empty($file_arr))
						{
							?>
							<ul class="files">
								<?php
								foreach($file_arr as $f)
								{
									?>
									<li><a target="_blank" href="<?php echo PJ_INSTALL_URL;?>index.php?controller=pjAdminTickets&action=pjActionDownloadFile&id=<?php echo $f['id']; ?>"><?php echo $f['file_name'];?></a></li>
									<?php 
								}	 
								?>
							</ul>
							<?php 
						}	 
						?>
					</div>
					<?php
				}	 
				?>
			</fieldset>
			<?php
		} 
		?>
		<fieldset class="ticket-message">
			<legend><?php __('lblReplyToTicket'); ?></legend>
			<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminTickets&amp;action=pjActionPostReply" method="post" id="frmPostReply" class="form pj-form" enctype="multipart/form-data">
				<p>
					<label class="title">&nbsp;</label>
					<span class="inline_block">
						<a href="#" class="pj-button pj-canned-messages"><?php __('menuCannedMessages'); ?></a>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblReplyMessage'); ?></label>
					<span class="inline_block">
						<textarea id="reply_text" name="reply_text" class="pj-form-field w500 h150 required"></textarea>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblReplyFiles'); ?></label>
					<span class="inline_block">
						<input id="files" name="files[]" type="file" multiple="multiple" />
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="hidden" name="ticket_id" value="<?php echo $tpl['arr']['id']; ?>" />
					<input type="hidden" name="user_id" value="<?php echo (int) $_SESSION[$controller->defaultUser]['id']; ?>" />
					<input type="button" value="<?php __('btnReply'); ?>" class="pj-button post-reply" />
				</p>
			</form>
			<div id="dialogCannedMessages" title="<?php __('menuCannedMessages'); ?>" style="display:none;">
				<div id="category_container">
					<table cellspacing="0" cellpadding="0" class="pj-table" style="width: 100%;">
						<thead>
							<tr>
								<th>
									<?php __('categories'); ?>
								</th>
							</tr>
						</thead>
						<?php
						if(!empty($tpl['category_arr']))
						{
							?>
							<tbody>
								<?php
								foreach($tpl['category_arr'] as $cat)
								{
									?>
									<tr>
										<td><a class="clickable_category" href="javascript:void(0);" rev="<?php echo $cat['id'];?>"><?php echo !empty($cat['category_name']) ? $cat['category_name'] : $cat['category'];?></a></td>
									</tr>
									<?php 
								}	 
								?>
							</tbody>
							<?php 
						}	 
						?>
					</table>
				</div>
				<div id="message_list">
					<table cellspacing="0" cellpadding="0" class="pj-table" style="width: 410px;">
						<thead>
							<tr>
								<th>
									<?php __('messages'); ?>
								</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td><?php __('lblPromptSelecting'); ?></td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
			<div id="dialogEditReply" title="<?php __('lblEditReply'); ?>" style="display:none;">
				<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminTickets&amp;action=pjActionUpdateReply" method="post" id="frmUpdateReply" class="form pj-form">
					<div class="pl5">
						<?php __('lblReplyMessage'); ?>
					</div>
					<p>
						<span class="inline_block">
							<textarea id="edit_reply_text" name="reply_text" class="pj-form-field w500 h150 required"></textarea>
						</span>
					</p>
					<p>
						<input type="hidden" id="edit_reply_id" name="reply_id" value="" />
						<input type="button" value="<?php __('btnEdit'); ?>" class="pj-button update-reply" />
					</p>
				</form>
			</div>
			<div id="dialogDeleteReply" title="<?php __('lblDeleteReply'); ?>" style="display:none;">
				<div class="t15">
					<?php __('lblDeleteReplyConfirmation'); ?>
					<input type="hidden" id="record_id" name="record_id" value="" />
				</div>
			</div>
		</fieldset>
	</div>
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.email_taken = "<?php __('ts_email_taken'); ?>";
	myLabel.field_required = "<?php __('ts_field_required'); ?>";
	myLabel.email_invalid = "<?php __('ts_email_invalid'); ?>";
	myLabel.file_ext = "<?php __('ts_file_ext'); ?>";
	myLabel.allowed_ext = "<?php echo implode("|", $controller->allowed_ext); ?>";
	</script>
	<?php
}
?>