<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	include PJ_VIEWS_PATH . 'pjLayouts/elements/usermenu.php';
	pjUtil::printNotice(__('infoUsersTitle', true, false), __('infoUsersDesc', true, false)); 
	?>
	<div class="b10">
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left pj-form r10">
			<input type="hidden" name="controller" value="pjAdminUsers" />
			<input type="hidden" name="action" value="pjActionCreate" />
			<input type="submit" class="pj-button" value="<?php __('btnAddUser'); ?>" />
		</form>
		<form action="" method="get" class="float_left pj-form frm-filter">
			<input type="text" name="q" class="pj-form-field pj-form-field-search w150" placeholder="<?php __('btnSearch'); ?>" />
		</form>
		<?php
		$filter = __('filter', true);
		?>
		<div class="float_right t5">
			<a href="#" class="pj-button btn-all"><?php __('lblAll');?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="T"><?php echo $filter['active']; ?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="F"><?php echo $filter['inactive']; ?></a>
		</div>
		<br class="clear_both" />
	</div>

	<div id="grid"></div>
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.jsDateFormat = "<?php echo pjUtil::jsDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.currentUserId = <?php echo (int) $_SESSION[$controller->defaultUser]['id']; ?>;
	var myLabel = myLabel || {};
	myLabel.name = "<?php echo pjSanitize::clean(__('lblName', true)); ?>";
	myLabel.email = "<?php echo pjSanitize::clean(__('lblEmail', true)); ?>";
	myLabel.departments = "<?php echo pjSanitize::clean(__('lblDepartments', true)); ?>";
	myLabel.role = "<?php echo pjSanitize::clean(__('lblRole', true)); ?>";
	myLabel.confirmed = "<?php echo pjSanitize::clean(__('lblIsActive', true)); ?>";
	myLabel.revert_status = "<?php echo pjSanitize::clean(__('lblRevertStatus', true)); ?>";
	myLabel.exported = "<?php echo pjSanitize::clean(__('lblExport', true)); ?>";
	myLabel.active = "<?php echo pjSanitize::clean(__('lblActive', true)); ?>";
	myLabel.inactive = "<?php echo pjSanitize::clean(__('lblInactive', true)); ?>";
	myLabel.delete_selected = "<?php echo pjSanitize::clean(__('lblDeleteSelected', true)); ?>";
	myLabel.delete_confirmation = "<?php echo pjSanitize::clean(__('lblDeleteConfirmation', true)); ?>";
	myLabel.status = "<?php echo pjSanitize::clean(__('lblStatus', true)); ?>";
	</script>
	<?php
}
?>