var jQuery_1_8_2 = $.noConflict();
(function ($, undefined) {
	if (window.tinyMCE !== undefined) 
	{
		tinymce.init({
		    selector: "textarea.mceEditor",
		    plugins: [
		        "advlist autolink lists link image charmap print preview anchor",
		        "searchreplace visualblocks code fullscreen",
		        "insertdatetime media table contextmenu paste"
		    ],
		    relative_urls : false,
		    remove_script_host : false,
		    convert_urls : true,
		    contextmenu: false,
		    width: 550,
		    height: 350,
		    toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image",
		    setup: function (editor) {
		    	editor.on('change', function (e) {
		    		editor.editorManager.triggerSave();
		    		$(":input[name='" + editor.id + "']").valid();
		    	});
		    }
		});
	}
	$(function () {
		var datagrid = ($.fn.datagrid !== undefined),
			$frmCreateNotification = $("#frmCreateNotification"),
			$frmUpdateNotification = $("#frmUpdateNotification"),
			tipsy = ($.fn.tipsy !== undefined),
			validate = ($.fn.validate !== undefined),
			chosen = ($.fn.chosen !== undefined);

		if ($frmCreateNotification.length > 0 && validate) {
			$frmCreateNotification.validate({
				messages: {
					"i18n[1][subject]": {
						required: myLabel.field_required
					},
					"i18n[1][message]": {
						required: myLabel.field_required
					},
					"i18n[2][subject]": {
						required: myLabel.field_required
					},
					"i18n[2][message]": {
						required: myLabel.field_required
					},
					"i18n[3][subject]": {
						required: myLabel.field_required
					},
					"i18n[3][message]": {
						required: myLabel.field_required
					},
					"type": {
						required: myLabel.field_required
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
			if (chosen) {
				$("#department_id").chosen();
				$("#user_id").chosen();
			}
		}
		if ($frmUpdateNotification.length > 0 && validate) {
			$frmUpdateNotification.validate({
				messages: {
					"i18n[1][subject]": {
						required: myLabel.field_required
					},
					"i18n[1][message]": {
						required: myLabel.field_required
					},
					"i18n[2][subject]": {
						required: myLabel.field_required
					},
					"i18n[2][message]": {
						required: myLabel.field_required
					},
					"i18n[3][subject]": {
						required: myLabel.field_required
					},
					"i18n[3][message]": {
						required: myLabel.field_required
					},
					"type": {
						required: myLabel.field_required
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
			
			if (chosen) {
				$("#department_id").chosen();
				$("#user_id").chosen();
			}
		}
		
		if (tipsy) {
			$(".tss-tip").tipsy({
				offset: 1,
				opacity: 1,
				html: true,
				gravity: "nw",
				className: "tipsy-tss"
			});
		}
		
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminNotifications&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminNotifications&action=pjActionDeleteNotification&id={:id}"}
				          ],
				columns: [{text: myLabel.subject, type: "text", sortable: false, editable: false, width: 400},
				          {text: myLabel.type, type: "select", sortable: true, editable: true, width: 200, options: [
				                                                                                     {label: myLabel.NewClient, value: "NewClient"}, 
				                                                                                     {label: myLabel.NewTicket, value: "NewTicket"}, 
				                                                                                     {label: myLabel.NewClientReply, value: "NewClientReply"},
				                                                                                     {label: myLabel.NewSupportReply, value: "NewSupportReply"},
				                                                                                     {label: myLabel.AccountActivation, value: "AccountActivation"}
				                                                                                     ], applyClass: "pj-notification-status pj-status"}],
				dataUrl: "index.php?controller=pjAdminNotifications&action=pjActionGetNotification",
				dataType: "json",
				fields: ['subject', 'type'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminNotifications&action=pjActionDeleteNotificationBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminNotifications&action=pjActionSaveNotification&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		$(document).on("change", "#type", function (e) {
			if($(this).val() == 'AccountActivation')
			{
				$('.boxRecipient').hide();
			}else{
				$('.boxRecipient').show();
			}
			return false;
		});
	});
})(jQuery_1_8_2);