DROP TABLE IF EXISTS `ffs_feedback`;
CREATE TABLE IF NOT EXISTS `ffs_feedback` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('suggestion','bug','compliment','complaint') DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `suggestion_type_id` int(10) unsigned DEFAULT NULL,
  `suggestion_description` text DEFAULT NULL,
  `bug_version` varchar(255) DEFAULT NULL,
  `bug_description` text DEFAULT NULL,
  `bug_steps` text DEFAULT NULL,
  `compliment_send_id` int(10) unsigned DEFAULT NULL,
  `compliment_testimonials` text DEFAULT NULL,
  `complaint_from_id` int(10) unsigned DEFAULT NULL,
  `complaint_reason` text DEFAULT NULL,
  `complaint_improve` text DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `suggestion_type_id` (`suggestion_type_id`),
  KEY `compliment_send_id` (`compliment_send_id`),
  KEY `complaint_from_id` (`complaint_from_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ffs_files`;
CREATE TABLE IF NOT EXISTS `ffs_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `feedback_id` int(10) unsigned DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `file_path` varchar(255) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `file_size` int(11) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `feedback_id` (`feedback_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ffs_settings`;
CREATE TABLE IF NOT EXISTS `ffs_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('complaint','compliment','product','suggestion') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ffs_fields`;
CREATE TABLE IF NOT EXISTS `ffs_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ffs_multi_lang`;
CREATE TABLE IF NOT EXISTS `ffs_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ffs_options`;
CREATE TABLE IF NOT EXISTS `ffs_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL,
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ffs_roles`;
CREATE TABLE IF NOT EXISTS `ffs_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ffs_users`;
CREATE TABLE IF NOT EXISTS `ffs_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `ffs_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(2, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(3, 'backend', 'backend', 'Backend titles', 'script', NULL),
(4, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(5, 'btnAddFeedback', 'backend', 'button / + Add feedback', 'script', NULL),
(6, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(7, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(8, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(9, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(10, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(11, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(12, 'btnGetInstallCode', 'backend', 'Button / Get install code', 'script', NULL),
(13, 'btnLogin', 'backend', 'Login', 'script', NULL),
(14, 'btnPreview', 'backend', 'Button / Preview', 'script', NULL),
(15, 'btnReset', 'backend', 'Reset', 'script', NULL),
(16, 'btnSave', 'backend', 'Save', 'script', NULL),
(17, 'btnSearch', 'backend', 'Search', 'script', NULL),
(18, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(19, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(20, 'btnUseThisTheme', 'backend', 'Button / Use this theme', 'script', NULL),
(21, 'created', 'backend', 'Created', 'script', NULL),
(22, 'dash_bug', 'backend', 'Dash / Bug', 'script', NULL),
(23, 'dash_bugs', 'backend', 'Dash / Bugs', 'script', NULL),
(24, 'dash_by', 'backend', 'Dash / by', 'script', NULL),
(25, 'dash_complaint', 'backend', 'Dash / Complaint', 'script', NULL),
(26, 'dash_complaints', 'backend', 'Dash / Complaints', 'script', NULL),
(27, 'dash_compliment', 'backend', 'Dash / Compliment', 'script', NULL),
(28, 'dash_compliments', 'backend', 'Dash / Compliments', 'script', NULL),
(29, 'dash_feedbacks_received', 'backend', 'Dash / feedbacks received', 'script', NULL),
(30, 'dash_feedbacks_today', 'backend', 'Dash / feedbacks today', 'script', NULL),
(31, 'dash_feedback_received', 'backend', 'Dash / feedback received', 'script', NULL),
(32, 'dash_feedback_today', 'backend', 'Dash / feedback today', 'script', NULL),
(33, 'dash_latest_feedback', 'backend', 'Dash / Latest feedback', 'script', NULL),
(34, 'dash_most_popular', 'backend', 'Dash / Most popular', 'script', NULL),
(35, 'dash_no_feedback_found', 'backend', 'Dash / No feedback found.', 'script', NULL),
(36, 'dash_no_records_found', 'backend', 'Dash / No records found.', 'script', NULL),
(37, 'dash_statistic', 'backend', 'Dash / Statistic', 'script', NULL),
(38, 'dash_suggestion', 'backend', 'Dash / Suggestion', 'script', NULL),
(39, 'dash_suggestions', 'backend', 'Dash / Suggestions', 'script', NULL),
(40, 'dash_unique_user', 'backend', 'Dash / unique user', 'script', NULL),
(41, 'dash_unique_users', 'backend', 'Dash / unique users', 'script', NULL),
(42, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(43, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(44, 'email', 'backend', 'E-Mail', 'script', NULL),
(45, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(46, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(47, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(48, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(49, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(50, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(51, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(52, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(53, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(54, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(55, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(56, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(57, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(58, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(59, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(60, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(61, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(62, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(63, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(64, 'infoAddFeedbackDesc', 'backend', 'Infobox / Add feedback', 'script', NULL),
(65, 'infoAddFeedbackTitle', 'backend', 'Infobox / Add feedback', 'script', NULL),
(66, 'infoAddSettingDesc', 'backend', 'Infobox / Add item', 'script', NULL),
(67, 'infoAddSettingTitle', 'backend', 'Infobox / Add item', 'script', NULL),
(68, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(69, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(70, 'infoFeedbackDesc', 'backend', 'Lable / Feedback', 'script', NULL),
(71, 'infoFeedbackTitle', 'backend', 'Lable / Feedback', 'script', NULL),
(72, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(73, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(74, 'infoInstallDesc', 'backend', 'Infobox / Install code', 'script', NULL),
(75, 'infoInstallTitle', 'backend', 'Infobox / Install code', 'script', NULL),
(76, 'infoNotificationsDesc', 'backend', 'Infobox / Notifications', 'script', NULL),
(77, 'infoNotificationsTitle', 'backend', 'Infobox / Notifications', 'script', NULL),
(78, 'infoReportsDesc', 'backend', 'Infobox / Reports', 'script', NULL),
(79, 'infoReportsTitle', 'backend', 'Infobox / Reports', 'script', NULL),
(80, 'infoSettingsDesc', 'backend', 'Infobox / List of items', 'script', NULL),
(81, 'infoSettingsTitle', 'backend', 'Infobox / List of items', 'script', NULL),
(82, 'infoThemeDesc', 'backend', 'Infobox / Preview front end', 'script', NULL),
(83, 'infoThemeTitle', 'backend', 'Infobox / Preview front end', 'script', NULL),
(84, 'infoUpdateFeedbackDesc', 'backend', 'Lable / Update feedback', 'script', NULL),
(85, 'infoUpdateFeedbackTitle', 'backend', 'Lable / Update feedback', 'script', NULL),
(86, 'infoUpdateSettingDesc', 'backend', 'Infobox / Update item', 'script', NULL),
(87, 'infoUpdateSettingTitle', 'backend', 'Infobox / Update item', 'script', NULL),
(88, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(89, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(90, 'infoUsersDesc', 'backend', 'Infobox / Users', 'script', NULL),
(91, 'infoUsersTitle', 'backend', 'Infobox / Users', 'script', NULL),
(92, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(93, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(94, 'lblBugVersion', 'backend', 'Lable / Version', 'script', NULL),
(95, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(96, 'lblComplaintFrom', 'backend', 'Lable / Complain from', 'script', NULL),
(97, 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', NULL),
(98, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(99, 'lblDateTime', 'backend', 'Label / Date / time', 'script', NULL),
(100, 'lblDays', 'backend', 'Days', 'script', NULL),
(101, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(102, 'lblDeleteFile', 'backend', 'Lable / Delete file', 'script', NULL),
(103, 'lblDeleteFileConfirm', 'backend', 'Lable / Delete file', 'script', NULL),
(104, 'lblDescription', 'backend', 'Lable / Description', 'script', NULL),
(105, 'lblError', 'backend', 'Error', 'script', NULL),
(106, 'lblExport', 'backend', 'Export', 'script', NULL),
(107, 'lblExtensionMessage', 'backend', 'Lable / File with extension is allowed to upload. ', 'script', NULL),
(108, 'lblFiles', 'backend', 'Lable / Files', 'script', NULL),
(109, 'lblFilter', 'backend', 'Infobox / Filter', 'script', NULL),
(110, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(111, 'lblInstallNotes', 'backend', 'Label / Install notes', 'script', NULL),
(112, 'lblInstallTheme', 'backend', 'Lable / Choose theme', 'script', NULL),
(113, 'lblInstallUseLink', 'backend', 'Label / Install notes', 'script', NULL),
(114, 'lblIp', 'backend', 'IP address', 'script', NULL),
(115, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(116, 'lblLoadingStyle', 'backend', 'Label / Loading style', 'script', NULL),
(117, 'lblName', 'backend', 'Name', 'script', NULL),
(118, 'lblNo', 'backend', 'No', 'script', NULL),
(119, 'lblNotifications', 'backend', 'Label / Notifications', 'script', NULL),
(120, 'lblOption', 'backend', 'Option', 'script', NULL),
(121, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(122, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(123, 'lblProductService', 'backend', 'Lable / Product / Service', 'script', NULL),
(124, 'lblReasonToComplaint', 'backend', 'Lable / Reason to complaint', 'script', NULL),
(125, 'lblRole', 'backend', 'Role', 'script', NULL),
(126, 'lblSeeAllFeedbacks', 'backend', 'Label / See all {NUM} feedbacks', 'script', NULL),
(127, 'lblSelectTheme', 'backend', 'Lable / Select theme', 'script', NULL),
(128, 'lblSelectType', 'backend', 'Label / Select type', 'script', NULL),
(129, 'lblSelectTypesToCollect', 'backend', 'Label / Select type(s) of feedback to collect', 'script', NULL),
(130, 'lblSendComplimentTo', 'backend', 'Lable / Send compliment to', 'script', NULL),
(131, 'lblSendFeedback', 'backend', 'Label / Send feedback', 'script', NULL),
(132, 'lblStatus', 'backend', 'Status', 'script', NULL),
(133, 'lblStepsToReproduce', 'backend', 'Lable / Steps to reproduce', 'script', NULL),
(134, 'lblStyleTextLink', 'backend', 'Label / Use a text link', 'script', NULL),
(135, 'lblStyleTopRight', 'backend', 'Label / Top right of the web page', 'script', NULL),
(136, 'lblSuggestionType', 'backend', 'Lable / Suggestion type', 'script', NULL),
(137, 'lblTestimonials', 'backend', 'Lable / Testimonials', 'script', NULL),
(138, 'lblTo', 'backend', 'Label / to', 'script', NULL),
(139, 'lblType', 'backend', 'Type', 'script', NULL),
(140, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(141, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(142, 'lblValue', 'backend', 'Value', 'script', NULL),
(143, 'lblWhatToImprove', 'backend', 'Lable / What to improve', 'script', NULL),
(144, 'lblYes', 'backend', 'Yes', 'script', NULL),
(145, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(146, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(147, 'locales', 'backend', 'Languages', 'script', NULL),
(148, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(149, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(150, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(151, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(152, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(153, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(154, 'menuFeedback', 'backend', 'Menu / Feedback', 'script', NULL),
(155, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(156, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(157, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(158, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(159, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(160, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(161, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(162, 'menuPreviewInstall', 'backend', 'Menu / Preview & Install', 'script', NULL),
(163, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(164, 'menuReports', 'backend', 'Menu / Reports', 'script', NULL),
(165, 'menuSettings', 'backend', 'Menu / Settings', 'script', NULL),
(166, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(167, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(168, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(169, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(170, 'opt_o_email_admin', 'backend', 'Options / New feedback email', 'script', NULL),
(171, 'opt_o_email_admin_message', 'backend', 'Options / Email message', 'script', NULL),
(172, 'opt_o_email_admin_message_text', 'backend', 'Options / Email message', 'script', NULL),
(173, 'opt_o_email_admin_subject', 'backend', 'Options / Email subject', 'script', NULL),
(174, 'opt_o_email_admin_text', 'backend', 'Options / New feedback email', 'script', NULL),
(175, 'opt_o_email_bug', 'backend', 'Options / Bug email', 'script', NULL),
(176, 'opt_o_email_bug_message', 'backend', 'Options / Email message', 'script', NULL),
(177, 'opt_o_email_bug_message_text', 'backend', 'Options / Email message', 'script', NULL),
(178, 'opt_o_email_bug_subject', 'backend', 'Options / Email subject', 'script', NULL),
(179, 'opt_o_email_bug_text', 'backend', 'Options / Bug email', 'script', NULL),
(180, 'opt_o_email_comlaint_message', 'backend', 'Options / Email message', 'script', NULL),
(181, 'opt_o_email_comlaint_text', 'backend', 'Options / Complaint email', 'script', NULL),
(182, 'opt_o_email_comliment', 'backend', 'Options / Compliment email', 'script', NULL),
(183, 'opt_o_email_complaint', 'backend', 'Options / Complaint email', 'script', NULL),
(184, 'opt_o_email_complaint_message_text', 'backend', 'Options / Email message', 'script', NULL),
(185, 'opt_o_email_complaint_subject', 'backend', 'Options / Email subject', 'script', NULL),
(186, 'opt_o_email_complaint_text', 'backend', 'Options / Complaint email', 'script', NULL),
(187, 'opt_o_email_compliment', 'backend', 'Options / Compliment email', 'script', NULL),
(188, 'opt_o_email_compliment_message', 'backend', 'Options / Email message', 'script', NULL),
(189, 'opt_o_email_compliment_message_text', 'backend', 'Options / Email message', 'script', NULL),
(190, 'opt_o_email_compliment_subject', 'backend', 'Options / Email subject', 'script', NULL),
(191, 'opt_o_email_compliment_text', 'backend', 'Options / Compliment email', 'script', NULL),
(192, 'opt_o_email_suggestion', 'backend', 'Options / Suggestion email', 'script', NULL),
(193, 'opt_o_email_suggestion_message', 'backend', 'Options / Email message', 'script', NULL),
(194, 'opt_o_email_suggestion_message_text', 'backend', 'Options / Email message', 'script', NULL),
(195, 'opt_o_email_suggestion_subject', 'backend', 'Options / Email subject', 'script', NULL),
(196, 'opt_o_email_suggestion_text', 'backend', 'Options / Suggestion email', 'script', NULL),
(197, 'opt_o_file_allowed', 'backend', 'Lable / File with extension is allowed to upload. ', 'script', NULL),
(198, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(199, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(200, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(201, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(202, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(203, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(204, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(205, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(206, 'pass', 'backend', 'Password', 'script', NULL),
(207, 'pj_email_invalid', 'backend', 'Lable / Email is invalid.', 'script', NULL),
(208, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(209, 'pj_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(210, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(211, 'tabGeneral', 'backend', 'Tab / General', 'script', NULL),
(212, 'tabNotifications', 'backend', 'Tab / Notifications', 'script', NULL),
(213, 'url', 'backend', 'URL', 'script', NULL),
(214, 'user', 'backend', 'Username', 'script', NULL),
(215, 'front_btn_attach', 'frontend', 'Button / Attach', 'script', NULL),
(216, 'front_btn_back', 'frontend', 'Button / Back', 'script', NULL),
(217, 'front_btn_close', 'frontend', 'Button / Close', 'script', NULL),
(218, 'front_btn_next', 'frontend', 'Button / Next', 'script', NULL),
(219, 'front_btn_send_complaint', 'frontend', 'Button / Send complaint', 'script', NULL),
(220, 'front_btn_send_compliment', 'frontend', 'Button / Send compliment', 'script', NULL),
(221, 'front_btn_send_report', 'frontend', 'Button / Send report', 'script', NULL),
(222, 'front_btn_send_suggestion', 'frontend', 'Button / Send suggestion', 'script', NULL),
(223, 'front_bug_step1_desc', 'frontend', 'Label / Bug description', 'script', NULL),
(224, 'front_bug_step2_desc', 'frontend', 'Label / Bug description', 'script', NULL),
(225, 'front_bug_thank_you', 'frontend', 'Label / Thank you for reporting the bug!', 'script', NULL),
(226, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(227, 'front_captcha_incorrect', 'frontend', 'Label / Captcha is not correct.', 'script', NULL),
(228, 'front_complaint_from', 'frontend', 'Button / Complaint from', 'script', NULL),
(229, 'front_complaint_step1_desc', 'frontend', 'Label / Complaint description', 'script', NULL),
(230, 'front_complaint_step2_desc', 'frontend', 'Label / Complaint description', 'script', NULL),
(231, 'front_complaint_thank_you', 'frontend', 'Label / Thank you for the complaint!', 'script', NULL),
(232, 'front_compliment_step1_desc', 'frontend', 'Label / Compliment description', 'script', NULL),
(233, 'front_compliment_step2_desc', 'frontend', 'Label / Compliment description', 'script', NULL),
(234, 'front_compliment_thank_you', 'frontend', 'Label / Thank you for your compliment!', 'script', NULL),
(235, 'front_description', 'frontend', 'Label / Description', 'script', NULL),
(236, 'front_email', 'frontend', 'Label / Email', 'script', NULL),
(237, 'front_email_invalid', 'frontend', 'Label / Email is invalid.', 'script', NULL),
(238, 'front_extionsion_message', 'frontend', 'Lable / File with extension is allowed to upload. ', 'script', NULL),
(239, 'front_feedback_form', 'frontend', 'Label / Feedback Form', 'script', NULL),
(240, 'front_feedback_step0_desc', 'frontend', 'Label / Feedback description', 'script', NULL),
(241, 'front_field_required', 'frontend', 'Label / This field is required.', 'script', NULL),
(242, 'front_files', 'frontend', 'Label / Files', 'script', NULL),
(243, 'front_file_error', 'frontend', 'Label / File error', 'script', NULL),
(244, 'front_make_a_complaint', 'frontend', 'Label / Make a complaint', 'script', NULL),
(245, 'front_make_a_suggestion', 'frontend', 'Label / Make a suggestion', 'script', NULL),
(246, 'front_max_file_size_error', 'frontend', 'Label / Max file size error', 'script', NULL),
(247, 'front_missing_parameters', 'frontend', 'Label / Missing parameters.', 'script', NULL),
(248, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(249, 'front_post_content_error', 'frontend', 'Label / Post content error', 'script', NULL),
(250, 'front_product_or_service', 'frontend', 'Label / Product / Service', 'script', NULL),
(251, 'front_reason_to_complaint', 'frontend', 'Button / Reason to complaint', 'script', NULL),
(252, 'front_report_a_bug', 'frontend', 'Label / Report a bug', 'script', NULL),
(253, 'front_send_a_compliment', 'frontend', 'Label / Send a compliment', 'script', NULL),
(254, 'front_send_compliment_to', 'frontend', 'Button / Send compliment to', 'script', NULL),
(255, 'front_steps_to_reproduce', 'frontend', 'Label / Steps to reproduce', 'script', NULL),
(256, 'front_suggestion_step1_desc', 'frontend', 'Label / Suggestion description', 'script', NULL),
(257, 'front_suggestion_step2_desc', 'frontend', 'Label / Suggestion description', 'script', NULL),
(258, 'front_suggestion_thank_you', 'frontend', 'Label / Thank you for your suggestion!', 'script', NULL),
(259, 'front_suggestion_type', 'frontend', 'Label / Type', 'script', NULL),
(260, 'front_testimonials', 'frontend', 'Button / Testimonials', 'script', NULL),
(261, 'front_thank_you', 'frontend', 'Label / Thank you for your suggestion!', 'script', NULL),
(262, 'front_version', 'frontend', 'Label / Version', 'script', NULL),
(263, 'front_what_to_improve', 'frontend', 'Button / What to improve', 'script', NULL),
(264, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(265, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(266, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(267, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(268, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(269, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(270, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(271, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(272, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(273, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(274, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(275, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(276, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(277, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(278, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(279, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(280, 'day_short_names_ARRAY_0', 'arrays', 'day_short_names_ARRAY_0', 'script', NULL),
(281, 'day_short_names_ARRAY_1', 'arrays', 'day_short_names_ARRAY_1', 'script', NULL),
(282, 'day_short_names_ARRAY_2', 'arrays', 'day_short_names_ARRAY_2', 'script', NULL),
(283, 'day_short_names_ARRAY_3', 'arrays', 'day_short_names_ARRAY_3', 'script', NULL),
(284, 'day_short_names_ARRAY_4', 'arrays', 'day_short_names_ARRAY_4', 'script', NULL),
(285, 'day_short_names_ARRAY_5', 'arrays', 'day_short_names_ARRAY_5', 'script', NULL),
(286, 'day_short_names_ARRAY_6', 'arrays', 'day_short_names_ARRAY_6', 'script', NULL),
(287, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(288, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(289, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(290, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(291, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(292, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(293, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(294, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(295, 'error_bodies_ARRAY_AF01', 'arrays', 'error_bodies_ARRAY_AF01', 'script', NULL),
(296, 'error_bodies_ARRAY_AF03', 'arrays', 'error_bodies_ARRAY_AF03', 'script', NULL),
(297, 'error_bodies_ARRAY_AF04', 'arrays', 'error_bodies_ARRAY_AF04', 'script', NULL),
(298, 'error_bodies_ARRAY_AF05', 'arrays', 'error_bodies_ARRAY_AF05', 'script', NULL),
(299, 'error_bodies_ARRAY_AF08', 'arrays', 'error_bodies_ARRAY_AF08', 'script', NULL),
(300, 'error_bodies_ARRAY_AF09', 'arrays', 'error_bodies_ARRAY_AF09', 'script', NULL),
(301, 'error_bodies_ARRAY_AF10', 'arrays', 'error_bodies_ARRAY_AF10', 'script', NULL),
(302, 'error_bodies_ARRAY_AF11', 'arrays', 'error_bodies_ARRAY_AF11', 'script', NULL),
(303, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(304, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(305, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(306, 'error_bodies_ARRAY_AST01', 'arrays', 'error_bodies_ARRAY_AST01', 'script', NULL),
(307, 'error_bodies_ARRAY_AST03', 'arrays', 'error_bodies_ARRAY_AST03', 'script', NULL),
(308, 'error_bodies_ARRAY_AST04', 'arrays', 'error_bodies_ARRAY_AST04', 'script', NULL),
(309, 'error_bodies_ARRAY_AST08', 'arrays', 'error_bodies_ARRAY_AST08', 'script', NULL),
(310, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(311, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(312, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(313, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(314, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(315, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(316, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(317, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(318, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(319, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(320, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(321, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(322, 'error_titles_ARRAY_AF01', 'arrays', 'error_titles_ARRAY_AF01', 'script', NULL),
(323, 'error_titles_ARRAY_AF03', 'arrays', 'error_titles_ARRAY_AF03', 'script', NULL),
(324, 'error_titles_ARRAY_AF04', 'arrays', 'error_titles_ARRAY_AF04', 'script', NULL),
(325, 'error_titles_ARRAY_AF05', 'arrays', 'error_titles_ARRAY_AF05', 'script', NULL),
(326, 'error_titles_ARRAY_AF08', 'arrays', 'error_titles_ARRAY_AF08', 'script', NULL),
(327, 'error_titles_ARRAY_AF09', 'arrays', 'error_titles_ARRAY_AF09', 'script', NULL),
(328, 'error_titles_ARRAY_AF10', 'arrays', 'error_titles_ARRAY_AF10', 'script', NULL),
(329, 'error_titles_ARRAY_AF11', 'arrays', 'error_titles_ARRAY_AF11', 'script', NULL),
(330, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(331, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(332, 'error_titles_ARRAY_AST01', 'arrays', 'error_titles_ARRAY_AST01', 'script', NULL),
(333, 'error_titles_ARRAY_AST03', 'arrays', 'error_titles_ARRAY_AST03', 'script', NULL),
(334, 'error_titles_ARRAY_AST04', 'arrays', 'error_titles_ARRAY_AST04', 'script', NULL),
(335, 'error_titles_ARRAY_AST08', 'arrays', 'error_titles_ARRAY_AST08', 'script', NULL),
(336, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(337, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(338, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(339, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(340, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(341, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(342, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(343, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(344, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(345, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(346, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(347, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(348, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(349, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(350, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(351, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(352, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(353, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(354, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(355, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(356, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(357, 'notify_arr_ARRAY_admin', 'arrays', 'notify_arr_ARRAY_admin', 'script', NULL),
(358, 'notify_arr_ARRAY_bug', 'arrays', 'notify_arr_ARRAY_bug', 'script', NULL),
(359, 'notify_arr_ARRAY_complaint', 'arrays', 'notify_arr_ARRAY_complaint', 'script', NULL),
(360, 'notify_arr_ARRAY_compliment', 'arrays', 'notify_arr_ARRAY_compliment', 'script', NULL),
(361, 'notify_arr_ARRAY_suggestion', 'arrays', 'notify_arr_ARRAY_suggestion', 'script', NULL),
(362, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(363, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(364, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(365, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(366, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(367, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(368, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(369, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(370, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(371, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(372, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(373, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(374, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(375, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(376, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(377, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(378, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(379, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(380, 'role_arr_ARRAY_1', 'arrays', 'role_arr_ARRAY_1', 'script', NULL),
(381, 'role_arr_ARRAY_2', 'arrays', 'role_arr_ARRAY_2', 'script', NULL),
(382, 'setting_types_ARRAY_complaint', 'arrays', 'setting_types_ARRAY_complaint', 'script', NULL),
(383, 'setting_types_ARRAY_compliment', 'arrays', 'setting_types_ARRAY_compliment', 'script', NULL),
(384, 'setting_types_ARRAY_product', 'arrays', 'setting_types_ARRAY_product', 'script', NULL),
(385, 'setting_types_ARRAY_suggestion', 'arrays', 'setting_types_ARRAY_suggestion', 'script', NULL),
(386, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(387, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(388, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(389, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(390, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(391, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(392, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(393, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(394, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(395, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(396, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(397, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(398, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(399, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(400, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(401, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(402, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(403, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(404, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(405, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(406, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(407, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(408, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(409, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(410, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(411, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(412, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(413, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(414, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(415, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(416, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(417, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(418, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(419, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(420, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(421, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(422, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(423, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(424, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(425, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(426, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(427, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(428, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(429, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(430, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(431, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(432, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(433, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(434, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(435, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(436, 'types_ARRAY_bug', 'arrays', 'types_ARRAY_bug', 'script', NULL),
(437, 'types_ARRAY_complaint', 'arrays', 'types_ARRAY_complaint', 'script', NULL),
(438, 'types_ARRAY_compliment', 'arrays', 'types_ARRAY_compliment', 'script', NULL),
(439, 'types_ARRAY_suggestion', 'arrays', 'types_ARRAY_suggestion', 'script', NULL),
(440, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(441, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(442, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(443, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL);

INSERT INTO `ffs_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 1, 'title', '+ Add feedback', 'script'),
(NULL, 6, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 7, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Get install code', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Bug', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Bugs', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'by', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Complaint', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Complaints', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Compliment', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Compliments', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'feedbacks received', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'feedbacks today', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'feedback received', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'feedback today', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Latest feedback', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Most popular', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'No feedback found.', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'No records found.', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Statistic', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Suggestion', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Suggestions', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'unique user', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'unique users', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 61, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'Fill in the form below and click "Save" to add a new feedback.', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Add Feedback', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Add feedback item that users can select when submitting the feedback form.', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Add Feedback Item', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Fill in the form below and click "Save” to add a new user.', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'See all feedback that users submitted. You can edit or delete any of them.', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Feedback Received', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Here you can set the General options for the Feedback Form Script.', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Select the type of feedback and the color theme you need to use and then either preview it or get its installation code. You can preview available themes under Preview menu.', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Email notifications are sent to users after they submit a feedback. You can also define a notification email sent to administrator when a feedback is received.', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'You can see the reports for all 4 types of feedback. You can filter to see data in more details.', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Reports', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Below you can see a list of different settings for the feedback that you receive - products, services, employees, suggestion types.', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Feedback Settings', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'There are multiple color themes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use by default.', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Preview front end', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Change feedback details and save it.', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Update Feedback', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" to edit item information.', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Update Item', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'You can make any changes to the user profile. Just remember to click "Save" in order to update the information.', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Below is the list of users who can access the Feedback Form Script. You can add new users, edit their details, change their status or delete them. ', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Version', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Complain from', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Date / time', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Delete file', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Are sure that you want to delete this file?', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'File with extension is not allowed to upload.', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Files', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'Filter', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'Copy the code below and put it in <head> section of your web page.', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Choose theme', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Use this code to create link on your web page which opens the Feedback Form.', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Loading style', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Product / Service', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'Reason to complaint', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'See all {NUM} feedbacks', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Select theme', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Select type', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Select type(s) of feedback to collect', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Send compliment to', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Send feedback', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Steps to reproduce', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Use a text link', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Top right of the web page', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Suggestion type', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Testimonials', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'to', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'What to improve', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Feedback', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Preview & Install', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Reports', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Settings', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'New feedback email', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 172, 'pjField', 1, 'title', '<u>Available tokens:</u><br/>{Name}<br/>{Email}<br/>{Product/Service}', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Please select "Yes" if you want to send email to administrators after users send a feedback. Otherwise select "No".', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Bug email', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 177, 'pjField', 1, 'title', '<u>Available tokens:</u><br/>{Name}<br/>{Email}<br/>{Product/Service}<br/>{Version}<br/>{Description}<br/>{Steps}<br/>{Files}', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Please select "Yes" if you want to send email to users after they sent a bug report. Otherwise select "No".', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Please select "Yes" if you want to send email to users after  they make a complaint. Otherwise select "No".', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Compliment email', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Complaint email', 'script'),
(NULL, 184, 'pjField', 1, 'title', '<u>Available tokens:</u><br/>{Name}<br/>{Email}<br/>{Product/Service}<br/>{ComplainFrom}<br/>{Reason}<br/>{WhatToImprove}', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Please select "Yes" if you want to send email to users after  they make complaints. Otherwise select "No".', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Compliment email', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 189, 'pjField', 1, 'title', '<u>Available tokens:</u><br/>{Name}<br/>{Email}<br/>{Product/Service}<br/>{SendTo}<br/>{Testimonials}', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Please select "Yes" if you want to send email to users after  they make compliments. Otherwise select "No".', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Suggestion email', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 194, 'pjField', 1, 'title', '<u>Available tokens:</u><br/>{Name}<br/>{Email}<br/>{Product/Service}<br/>{SuggestionType}<br/>{Description}<br/>{Files}', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Please select "Yes" if you want to send email to users after they sent a suggestion. Otherwise select "No".', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'File with extension is allowed to upload. ', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Attach', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Next', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Send complaint', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Send compliment', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Send report', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Send suggestion', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde ', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde ', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'Thank you for reporting the bug!', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'Captcha is not correct.', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'Complaint from', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde ', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde ', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'Thank you for the complaint!', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde ', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde ', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Thank you for your compliment!', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'File with extension is not allowed to upload.', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'Feedback Form', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'We appreciate the time you have taken to help us improve our site &amp; service. Please use the form below to provide us your feedback.', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'Files', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'Please check your files again.', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Make a complaint', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'Make a suggestion', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'File(s) could not be uploaded because the file size is too big. Maximum allowed size is {MAXSIZE}. Please, upload another file.', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'Missing parameters.', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'The file size is too big. Maximum allowed post content is {SIZE}. Please, upload another file.', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Product / Service', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Reason to complaint', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Report a bug', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Send a compliment', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Send compliment to', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Steps to reproduce', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde ', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde ', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'Thank you for your suggestion!', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'Testimonials', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Thank you for your suggestion!', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'Version', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'What to improve', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'All changes made to the feedback have been saved.', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'New feedback has been added into the system.', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'The feedback could not be added successfully. Please try again.', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Feedback could not be saved because the file size is too big. Maximum allowed size is {SIZE}. Please, upload another file.', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'The feedback you are looking for is missing.', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'The feedback was already saved, but file(s) could not be uploaded because of some error(s) occurred with file(s).', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'The feedback was already saved, but file(s) could not be uploaded because there is/are some file(s) having file extensions not allowed to upload. Please check again.', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Feedback was already save but the file(s) could not be uploaded because the file size is too big. Maximum allowed size is {MAXSIZE}. Please, upload another file.', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'All the changes made to General Options have been saved.', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'All the changes made to Notifications have been saved.', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'All changes made to the item have been saved.', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'New item has been added into the system.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'The item could not be added successfully. Please try again.', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'The item you are looking for is missing.', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'Feedback updated!', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Feedback added', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Feedback failed to add', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'File too big!', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Feedback not found', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'File(s) error!', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'File extension not allowed!', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'File(s) too big!', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Notifications updated!', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Item updated!', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Item added', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Item failed to add', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Item not found', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Admin - New feedback', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Users - Bug email', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Users - Complaint email', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Users - Compliment email', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Users - Suggestion email', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Editor', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Complaint from', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Compliment send to', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Product / Service', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Suggestion type', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Bug', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Complaint', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Compliment', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Suggestion', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 1, 'pjOption', 1, 'o_email_suggestion_subject', 'Thank you for your suggestion', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_suggestion_message', '<p>Dear&nbsp;{Name},</p><p>&nbsp;</p><p>thank you for your suggestion.</p><p>&nbsp;</p><p>Regards,</p><p>Management</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_bug_subject', 'Bug report received', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_bug_message', '<p>Dear&nbsp;{Name},</p><p>&nbsp;</p><p>thank you for your bug report. We will fix it ASAP!</p><p>&nbsp;</p><p>Regards,</p><p>Management</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_compliment_subject', 'Thank you :)', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_compliment_message', '<p>Dear&nbsp;{Name},</p><p>&nbsp;</p><p>thank you for the compliment!</p><p>&nbsp;</p><p>Regards,</p><p>Management</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_complaint_subject', 'We appologize', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_complaint_message', '<p>Dear&nbsp;{Name},</p><p>&nbsp;</p><p>We''ve received your complaint. Please, accept our sincere apology!</p><p>&nbsp;</p><p>Regards,</p><p>Management</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_admin_subject', 'New Feedback', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_admin_message', '<p>New feedback has been posted about&nbsp;{Product/Service}</p>', 'data');

INSERT INTO `ffs_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 1, NULL),
(1, 'o_file_allowed', 1, 'pdf|doc|docx|xls|csv|txt|rtf|zip|mp3|wma|mpg|flv|avi|jpg|jpeg|png|gif', NULL, 'text', 6, 1, NULL),
(1, 'o_theme', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 13, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),

(1, 'o_email_suggestion', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_suggestion_subject', 3, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_suggestion_message', 3, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_bug', 3, '0|1::1', 'No|Yes', 'enum', 4, 1, NULL),
(1, 'o_email_bug_subject', 3, '', NULL, 'string', 5, 1, NULL),
(1, 'o_email_bug_message', 3, '', NULL, 'text', 6, 1, NULL),
(1, 'o_email_compliment', 3, '0|1::1', 'No|Yes', 'enum', 7, 1, NULL),
(1, 'o_email_compliment_subject', 3, '', NULL, 'string', 8, 1, NULL),
(1, 'o_email_compliment_message', 3, '', NULL, 'text', 9, 1, NULL),
(1, 'o_email_complaint', 3, '0|1::1', 'No|Yes', 'enum', 10, 1, NULL),
(1, 'o_email_complaint_subject', 3, '', NULL, 'string', 11, 1, NULL),
(1, 'o_email_complaint_message', 3, '', NULL, 'text', 12, 1, NULL),
(1, 'o_email_admin', 3, '0|1::1', 'No|Yes', 'enum', 13, 1, NULL),
(1, 'o_email_admin_subject', 3, '', NULL, 'string', 14, 1, NULL),
(1, 'o_email_admin_message', 3, '', NULL, 'text', 15, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `ffs_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T');