<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminFeedback extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminFeedback&action=pjActionIndex&err=AF05");
			}
			
			if (isset($_POST['feedback_create']))
			{
				$pjFeedbackModel = pjFeedbackModel::factory();
				
				$data = array();
				$data['type'] = $_POST['type'];
				$data['email'] = $_POST['email'];
				$data['name'] = $_POST['name'];
				$data['product_id'] = $_POST['product_id'];
				switch ($_POST['type']) {
					case 'suggestion':
						$data['suggestion_type_id'] = $_POST['suggestion_type_id'];
						$data['suggestion_description'] = $_POST['suggestion_description'];
					break;
					case 'bug':
						$data['bug_version'] = $_POST['bug_version'];
						$data['bug_description'] = $_POST['bug_description'];
						$data['bug_steps'] = $_POST['bug_steps'];
					break;
					case 'compliment':
						$data['compliment_send_id'] = $_POST['compliment_send_id'];
						$data['compliment_testimonials'] = $_POST['compliment_testimonials'];
					break;
					case 'complaint':
						$data['complaint_from_id'] = $_POST['complaint_from_id'];
						$data['complaint_reason'] = $_POST['complaint_reason'];
						$data['complaint_improve'] = $_POST['complaint_improve'];
					break;
				}
				$data['created'] = date('Y-m-d H:i:s');
				
				$id = $pjFeedbackModel->setAttributes($data)->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AF03';
					
					if($_POST['type'] == 'suggestion' || $_POST['type'] == 'bug')
					{
						if(!empty($_FILES['files']['name'][0]))
						{
							$files = array();
							foreach ($_FILES['files'] as $k => $l) {
								foreach ($l as $i => $v) {
									if (!array_key_exists($i, $files))
									{
										$files[$i] = array();
									}
									$files[$i][$k] = $v;
								}
							}
							$has_error = false;
							foreach ($files as $file)
							{
								if($file['error'] != 4 && $file['error'] != 0)
								{
									$has_error = true;
									$err = 'AF09';
								}
								$path = $file['name'];
								$extension = pathinfo($path, PATHINFO_EXTENSION);
								$allowed_arr = explode("|", $this->option_arr['o_file_allowed']);
								if(!in_array($extension, $allowed_arr))
								{
									$has_error = true;
									$err = 'AF10';
								}
								if($file['error'] == 1 || $file['error'] == 2)
								{
									$has_error = true;
									$err = 'AF11';
								}
							}
							if($has_error == false)
							{
								$pjFileModel = pjFileModel::factory();
								foreach ($files as $file)
								{
									$hash = md5(uniqid(rand(), true));
									$handle = new pjUpload();
									if ($handle->load($file))
									{
										$fdata = array();
										$file_ext = $handle->getExtension();
										$file_path = PJ_UPLOAD_PATH . 'files/' . $id . '_' . $hash . '.' . $file_ext;
										if($handle->save($file_path))
										{
											$fdata['feedback_id'] = $id;
											$fdata['mime_type'] = $file['type'];
											$fdata['file_path'] = $file_path;
											$fdata['file_name'] = $file['name'];
											$fdata['file_size'] = $file['size'];
											$fdata['hash'] = $hash;
										}
										$pjFileModel->reset()->setAttributes($fdata)->insert();
									}
								}
							}
						}
					}
				} else {
					$err = 'AF04';
				}
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminFeedback&action=pjActionIndex&err=$err");
			} else {
				
				$pjSettingModel = pjSettingModel::factory();
				
				$product_arr = $pjSettingModel
					->select("t1.*, t2.content as name")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where("type", 'product')
					->orderBy("name ASC")
					->findAll()->getData();
				
				$type_arr = $pjSettingModel
					->reset()
					->select("t1.*, t2.content as name")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where("type", 'suggestion')
					->orderBy("name ASC")
					->findAll()->getData();
				
				$send_arr = $pjSettingModel
					->reset()
					->select("t1.*, t2.content as name")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where("type", 'compliment')
					->orderBy("name ASC")
					->findAll()->getData();
				
				$from_arr = $pjSettingModel
					->reset()
					->select("t1.*, t2.content as name")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where("type", 'complaint')
					->orderBy("name ASC")
					->findAll()->getData();
				
				$this->set('product_arr', $product_arr);
				$this->set('type_arr', $type_arr);
				$this->set('send_arr', $send_arr);
				$this->set('from_arr', $from_arr);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminFeedback.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
		
	public function pjActionDeleteFeedback()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjFeedbackModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				$pjFileModel = pjFileModel::factory();
				$file_arr = $pjFileModel->where('feedback_id', $_GET['id'])->findAll()->getData();
				foreach($file_arr as $f)
				{
					$file_path = $f['file_path'];
					$thumb_path = $f['thumb_path'];
					if (file_exists(PJ_INSTALL_PATH . $file_path)) {
						@unlink(PJ_INSTALL_PATH . $file_path);
					}
					if (file_exists(PJ_INSTALL_PATH . $thumb_path)) {
						@unlink(PJ_INSTALL_PATH . $thumb_path);
					}
				}
				$pjFileModel->reset()->where('feedback_id', $_GET['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteFeedbackBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjFeedbackModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				$pjFileModel = pjFileModel::factory();
				$file_arr = $pjFileModel->whereIn('feedback_id', $_POST['record'])->findAll()->getData();
				foreach($file_arr as $f)
				{
					$file_path = $f['file_path'];
					$thumb_path = $f['thumb_path'];
					if (file_exists(PJ_INSTALL_PATH . $file_path)) {
						@unlink(PJ_INSTALL_PATH . $file_path);
					}
					if (file_exists(PJ_INSTALL_PATH . $thumb_path)) {
						@unlink(PJ_INSTALL_PATH . $thumb_path);
					}
				}
				$pjFileModel->reset()->whereIn('feedback_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionGetFeedback()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjFeedbackModel = pjFeedbackModel::factory()->join('pjMultiLang', "t2.foreign_id = t1.product_id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left');
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjFeedbackModel->where('t1.name LIKE', "%$q%");
				$pjFeedbackModel->orWhere('t1.email LIKE', "%$q%");
			}
			if (isset($_GET['name']) && !empty($_GET['name']))
			{
				$name = pjObject::escapeString($_GET['name']);
				$pjFeedbackModel->where('t1.name LIKE', "%$name%");
			}
			if (isset($_GET['email']) && !empty($_GET['email']))
			{
				$email = pjObject::escapeString($_GET['email']);
				$pjFeedbackModel->where('email', $email);
			}
			if (isset($_GET['type']) && in_array($_GET['type'], array('suggestion','bug','compliment', 'complaint')))
			{
				$pjFeedbackModel->where('t1.type', $_GET['type']);
			}
			if (isset($_GET['product_id']) && (int) $_GET['product_id'] > 0)
			{
				$pjFeedbackModel->where('t1.product_id', $_GET['product_id']);
			}
			if (isset($_GET['from_date']) && !empty($_GET['from_date']) && isset($_GET['to_date']) && !empty($_GET['to_date']))
			{
				$from_date = pjUtil::formatDate($_GET['from_date'], $this->option_arr['o_date_format']);
				$to_date = pjUtil::formatDate($_GET['to_date'], $this->option_arr['o_date_format']);
				$pjFeedbackModel->where("(t1.created BETWEEN '$from_date' AND '$to_date')");
			}elseif(isset($_GET['from_date']) && !empty($_GET['from_date']) && isset($_GET['to_date']) && empty($_GET['to_date'])){
				$from_date = pjUtil::formatDate($_GET['from_date'], $this->option_arr['o_date_format']);
				$pjFeedbackModel->where("(`created` >= '$from_date')");
			}elseif(isset($_GET['from_date']) && empty($_GET['from_date']) && isset($_GET['to_date']) && !empty($_GET['to_date'])){
				$to_date = pjUtil::formatDate($_GET['to_date'], $this->option_arr['o_date_format']);
				$pjFeedbackModel->where("(`created` <= '$to_date')");
			}
			if (isset($_GET['setting_id']) && (int) $_GET['setting_id'] > 0)
			{
				if (isset($_GET['type']) && in_array($_GET['type'], array('suggestion','bug','compliment', 'complaint')))
				{
					if($_GET['type'] == 'suggestion')
					{
						$pjFeedbackModel->where("(t1.type='suggestion' AND (`t1`.product_id='".$_GET['setting_id']."' OR `t1`.suggestion_type_id='".$_GET['setting_id']."') )");
					}else if($_GET['type'] == 'bug'){
						$pjFeedbackModel->where("(t1.type='bug' AND `t1`.product_id='".$_GET['setting_id']."')");
					}else if($_GET['type'] == 'compliment'){
						$pjFeedbackModel->where("(t1.type='compliment' AND (`t1`.product_id='".$_GET['setting_id']."' OR `t1`.compliment_send_id='".$_GET['setting_id']."') )");
					}else if($_GET['type'] == 'complaint'){
						$pjFeedbackModel->where("(t1.type='complaint' AND (`t1`.product_id='".$_GET['setting_id']."' OR `t1`.complaint_from_id='".$_GET['setting_id']."') )");
					}
				}
			}
			
			$column = 'created';
			$direction = 'Desc';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjFeedbackModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 20;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$data = $pjFeedbackModel
				->select("t1.*, t2.content as product")
				->orderBy("`$column` $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			
			$types = __('types', true);
			foreach($data as $k => $v)
			{
				$v['type'] = $types[$v['type']];
				$v['created'] = date($this->option_arr['o_date_format'], strtotime($v['created'])) . ', ' . date($this->option_arr['o_time_format'], strtotime($v['created']));
				$v['name'] = pjSanitize::html($v['name']) . '<br/>' . pjSanitize::html($v['email']);
				$data[$k] = $v;
			}
			
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$pjSettingModel = pjSettingModel::factory();
			
			$product_arr = $pjSettingModel
				->select("t1.*, t2.content as name")
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->where("type", 'product')
				->orderBy("name ASC")
				->findAll()->getData();
			
			$this->set('product_arr', $product_arr);
			
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminFeedback.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveFeedback()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjFeedbackModel = pjFeedbackModel::factory();
			if (!in_array($_POST['column'], $pjFeedbackModel->getI18n()))
			{
				$pjFeedbackModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			} else {
				pjMultiLangModel::factory()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjFeedback', 'data');
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminFeedback&action=pjActionIndex&err=AF05");
			}
			
			if (isset($_POST['feedback_update']))
			{
				$err = 'AF01';
				
				$data = array();
				$data['type'] = $_POST['type'];
				$data['email'] = $_POST['email'];
				$data['name'] = $_POST['name'];
				$data['product_id'] = $_POST['product_id'];
				
				$data['suggestion_type_id'] = ':NULL';
				$data['suggestion_description'] = ':NULL';
				$data['bug_version'] = ':NULL';
				$data['bug_description'] = ':NULL';
				$data['bug_steps'] = ':NULL';
				$data['compliment_send_id'] = ':NULL';
				$data['compliment_testimonials'] = ':NULL';
				$data['complaint_from_id'] = ':NULL';
				$data['complaint_reason'] = ':NULL';
				$data['complaint_improve'] = ':NULL';
				
				switch ($_POST['type']) {
					case 'suggestion':
						$data['suggestion_type_id'] = $_POST['suggestion_type_id'];
						$data['suggestion_description'] = $_POST['suggestion_description'];
						break;
					case 'bug':
						$data['bug_version'] = $_POST['bug_version'];
						$data['bug_description'] = $_POST['bug_description'];
						$data['bug_steps'] = $_POST['bug_steps'];
						break;
					case 'compliment':
						$data['compliment_send_id'] = $_POST['compliment_send_id'];
						$data['compliment_testimonials'] = $_POST['compliment_testimonials'];
						break;
					case 'complaint':
						$data['complaint_from_id'] = $_POST['complaint_from_id'];
						$data['complaint_reason'] = $_POST['complaint_reason'];
						$data['complaint_improve'] = $_POST['complaint_improve'];
						break;
				}
				$data['modified'] = date('Y-m-d H:i:s');
				pjFeedbackModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($data);
				
				if($_POST['type'] == 'suggestion' || $_POST['type'] == 'bug')
				{
					if(!empty($_FILES['files']['name'][0]))
					{
						$files = array();
						foreach ($_FILES['files'] as $k => $l) {
							foreach ($l as $i => $v) {
								if (!array_key_exists($i, $files))
								{
									$files[$i] = array();
								}
								$files[$i][$k] = $v;
							}
						}
						$has_error = false;
						foreach ($files as $file)
						{
							if($file['error'] != 4 && $file['error'] != 0)
							{
								$has_error = true;
								$err = 'AF09';
							}
							$path = $file['name'];
							$extension = pathinfo($path, PATHINFO_EXTENSION);
							$allowed_arr = explode("|", $this->option_arr['o_file_allowed']);
							if(!in_array($extension, $allowed_arr))
							{
								$has_error = true;
								$err = 'AF10';
							}
							if($file['error'] == 1 || $file['error'] == 2)
							{
								$has_error = true;
								$err = 'AF11';
							}
						}
						
						if($has_error == false)
						{
							$pjFileModel = pjFileModel::factory();
							foreach ($files as $file)
							{
								$hash = md5(uniqid(rand(), true));
								$handle = new pjUpload();
								if ($handle->load($file))
								{
									$fdata = array();
									$file_ext = $handle->getExtension();
									$file_path = PJ_UPLOAD_PATH . 'files/' . $_POST['id'] . '_' . $hash . '.' . $file_ext;
									if($handle->save($file_path))
									{
										$fdata['feedback_id'] = $_POST['id'];
										$fdata['mime_type'] = $file['type'];
										$fdata['file_path'] = $file_path;
										$fdata['file_name'] = $file['name'];
										$fdata['file_size'] = $file['size'];
										$fdata['hash'] = $hash;
									}
									$pjFileModel->reset()->setAttributes($fdata)->insert();
								}
							}
						}
					}
				}else{
					$pjFileModel = pjFileModel::factory();
					$file_arr = $pjFileModel->where('feedback_id', $_POST['id'])->findAll()->getData();
					foreach($file_arr as $f)
					{
						$file_path = $f['file_path'];
						$thumb_path = $f['thumb_path'];
						if (file_exists(PJ_INSTALL_PATH . $file_path)) {
							@unlink(PJ_INSTALL_PATH . $file_path);
						}
						if (file_exists(PJ_INSTALL_PATH . $thumb_path)) {
							@unlink(PJ_INSTALL_PATH . $thumb_path);
						}
					}
					$pjFileModel->reset()->where('feedback_id', $_POST['id'])->eraseAll();
				}
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminFeedback&action=pjActionIndex&err=$err");
				
			} else {
				$pjFeedbackModel = pjFeedbackModel::factory();
				$arr = $pjFeedbackModel->select("t1.*, (SELECT COUNT(`TF`.id) FROM `".$pjFeedbackModel->getTable()."` AS `TF` WHERE `TF`.email=t1.email) AS feedbacks")->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminFeedback&action=pjActionIndex&err=AF08");
				}
				$this->set('arr', $arr);
				
				$pjSettingModel = pjSettingModel::factory();
				$product_arr = $pjSettingModel
					->select("t1.*, t2.content as name")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where("type", 'product')
					->orderBy("name ASC")
					->findAll()->getData();
				
				$type_arr = $pjSettingModel
					->reset()
					->select("t1.*, t2.content as name")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where("type", 'suggestion')
					->orderBy("name ASC")
					->findAll()->getData();
				
				$send_arr = $pjSettingModel
					->reset()
					->select("t1.*, t2.content as name")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where("type", 'compliment')
					->orderBy("name ASC")
					->findAll()->getData();
				
				$from_arr = $pjSettingModel
					->reset()
					->select("t1.*, t2.content as name")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where("type", 'complaint')
					->orderBy("name ASC")
					->findAll()->getData();
				
				$file_arr = pjFileModel::factory()->where('feedback_id', $_GET['id'])->findAll()->getData();
				
				$this->set('product_arr', $product_arr);
				$this->set('type_arr', $type_arr);
				$this->set('send_arr', $send_arr);
				$this->set('from_arr', $from_arr);
				$this->set('file_arr', $file_arr);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminFeedback.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	public function pjActionDeleteFile()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
	
			$pjFileModel = pjFileModel::factory();
			$arr = $pjFileModel->find($_GET['id'])->getData();
			if(!empty($arr))
			{
				if(!empty($arr['file_path']))
				{
					@unlink(PJ_INSTALL_PATH . $arr['file_path']);
				}
				$pjFileModel->reset()->setAttributes(array('id' => $_GET['id']))->erase();
				
				$response['code'] = 200;
			}else{
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
	}
}
?>