<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminReports extends pjAdmin
{
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$pjFeedbackModel = pjFeedbackModel::factory();
			
			$type = isset($_GET['type']) ? ( in_array($_GET['type'], array('suggestion','product','compliment','complaint')) ? $_GET['type'] : NULL ) : NULL;
			
			$pjSettingModel = pjSettingModel::factory()
				->select("t1.*, t2.content as name,
						(SELECT COUNT(`TF`.id) FROM `".$pjFeedbackModel->getTable()."` AS `TF` WHERE `TF`.type='suggestion' AND (`TF`.product_id=t1.id OR `TF`.suggestion_type_id=t1.id) ) AS suggestions,
						(SELECT COUNT(`TF`.id) FROM `".$pjFeedbackModel->getTable()."` AS `TF` WHERE `TF`.type='bug' AND (`TF`.product_id=t1.id) ) AS bugs,
						(SELECT COUNT(`TF`.id) FROM `".$pjFeedbackModel->getTable()."` AS `TF` WHERE `TF`.type='compliment' AND (`TF`.product_id=t1.id OR `TF`.compliment_send_id=t1.id) ) AS compliments,
						(SELECT COUNT(`TF`.id) FROM `".$pjFeedbackModel->getTable()."` AS `TF` WHERE `TF`.type='complaint' AND (`TF`.product_id=t1.id OR `TF`.complaint_from_id=t1.id) ) AS complaints")
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left');
			
			if($type != NULl)
			{
				$pjSettingModel->where('type', $type);
			}
			$setting_arr = $pjSettingModel->orderBy("`type` ASC, `name` ASC")->findAll()->getData();
			
			$this->set('setting_arr', $setting_arr);
			
			$this->appendJs('pjAdminReports.js');
		} else {
			$this->set('status', 2);
		}
	}
}
?>