<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{	
	public $defaultCaptcha = 'pjFFS_Captcha';
	
	public $defaultLocale = 'pjFFS_LocaleId';
	
	public $defaultForm = 'pjFFS_Form';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
		
		self::allowCORS();
	}
	
	public function afterFilter()
	{		
		$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file, t2.title')
			->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
			->where('t2.file IS NOT NULL')
			->orderBy('t1.sort ASC')->findAll()->getData();
		
		$this->set('locale_arr', $locale_arr);
	}
		
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		$this->loadSetFields();
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionLocale()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['locale_id']))
			{
				$this->pjActionSetLocale($_GET['locale_id']);
				
				$this->loadSetFields(true);
				
				$day_names = __('day_names', true);
				ksort($day_names, SORT_NUMERIC);
				
				$months = __('months', true);
				ksort($months, SORT_NUMERIC);
				
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Locale have been changed.', 'opts' => array(
					'day_names' => array_values($day_names),
					'month_names' => array_values($months)
				)));
			}
		}
		exit;
	}
	private function pjActionSetLocale($locale)
	{
		if ((int) $locale > 0)
		{
			$_SESSION[$this->defaultLocale] = (int) $locale;
		}
		return $this;
	}
	
	public function pjActionGetLocale()
	{
		return isset($_SESSION[$this->defaultLocale]) && (int) $_SESSION[$this->defaultLocale] > 0 ? (int) $_SESSION[$this->defaultLocale] : FALSE;
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		header("Cache-Control: max-age=3600, private");
		$Captcha = new pjCaptcha(PJ_WEB_PATH.'obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_IMG_PATH.'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}

	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
		exit;
	}
	
	public function pjActionLoadCss()
	{
		$theme = $this->option_arr['o_theme'];
		$fonts = $this->option_arr['o_theme'];
		if(isset($_GET['theme']) && in_array($_GET['theme'], array('theme1', 'theme2', 'theme3', 'theme4', 'theme5', 'theme6', 'theme7', 'theme8', 'theme9', 'theme10')))
		{
			$theme = $_GET['theme'];
			$fonts = $_GET['theme'];
		}
		$arr = array(
				array('file' => "$fonts.css", 'path' => PJ_CSS_PATH . "fonts/"),
				array('file' => 'style.css', 'path' => PJ_CSS_PATH),
				array('file' => "$theme.css", 'path' => PJ_CSS_PATH . "themes/"),
				array('file' => 'transitions.css', 'path' => PJ_CSS_PATH)
		);
		header("Content-Type: text/css; charset=utf-8");
		foreach ($arr as $item)
		{
			ob_start();
			@readfile($item['path'] . $item['file']);
			$string = ob_get_contents();
			ob_end_clean();
				
			if ($string !== FALSE)
			{
				echo str_replace(
						array('../fonts/glyphicons', "url(images/", "pjWrapper"),
						array(
								PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/fonts/glyphicons',
								"url(".PJ_INSTALL_URL . PJ_IMG_PATH ."frontend/",
								"pjWrapperFeedback_" . $theme
						),
						$string
				) . "\n";
			}
		}
		exit;
	}
	
	public function pjActionLoad()
	{
		ob_start();
		header("Content-Type: text/javascript; charset=utf-8");
	}
	
	public function pjActionStep0()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			unset($_SESSION[$this->defaultForm]);
		}
	}
	
	public function pjActionStep1()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				$text = __('front_post_content_error', true);
				$text = str_replace("{SIZE}", ini_get('post_max_size'), $text);
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 103, 'text' => $text));
			}
			if(isset($_POST['step_1']))
			{
				$has_error = false;
				$code = 100;
				$text = '';
				$files = array();
				$filename_arr = array();
				if($_POST['type'] == 'suggestion' || $_POST['type'] == 'bug')
				{
					if(!empty($_FILES['files']['name'][0]))
					{
						foreach ($_FILES['files'] as $k => $l) {
							foreach ($l as $i => $v) {
								if (!array_key_exists($i, $files))
								{
									$files[$i] = array();
								}
								$files[$i][$k] = $v;
							}
						}
						foreach ($files as $file)
						{
							if($file['error'] != 4 && $file['error'] != 0)
							{
								$has_error = true;
								$code = 101;
								$text = __('front_file_error', true);
							}
							$path = $file['name'];
							$filename_arr[] = $path;
							$extension = pathinfo($path, PATHINFO_EXTENSION);
							$allowed_arr = explode("|", $this->option_arr['o_file_allowed']);
							if(!in_array($extension, $allowed_arr))
							{
								$has_error = true;
								$code = 102;
								$text = __('front_extionsion_message', true);
							}
							if($file['error'] == 1 || $file['error'] == 2)
							{
								$text = __('front_max_file_size_error', true);
								$text = str_replace("{MAXSIZE}", ini_get('upload_max_filesize'), $text);
								pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 104, 'text' => $text));
							}
						}
					}
				}
				if($has_error == false)
				{	
					$_SESSION[$this->defaultForm] = $_POST;
					if(!empty($files))
					{
						$_SESSION[$this->defaultForm][$_POST['type']]['files'] = $files;
						$_SESSION[$this->defaultForm][$_POST['type']]['filenames'] = join("; ", $filename_arr);
					}
					pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200));
				}else{
					pjAppController::jsonResponse(array('status' => 'ERR', 'code' => $code, 'text' => $text));
				}
			}else{
				$pjSettingModel = pjSettingModel::factory();
				
				$product_arr = $pjSettingModel
					->select("t1.*, t2.content as name")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where("type", 'product')
					->orderBy("name ASC")
					->findAll()->getData();
				
				$type_arr = $pjSettingModel
					->reset()
					->select("t1.*, t2.content as name")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where("type", 'suggestion')
					->orderBy("name ASC")
					->findAll()->getData();
				
				$send_arr = $pjSettingModel
					->reset()
					->select("t1.*, t2.content as name")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where("type", 'compliment')
					->orderBy("name ASC")
					->findAll()->getData();
				
				$from_arr = $pjSettingModel
					->reset()
					->select("t1.*, t2.content as name")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where("type", 'complaint')
					->orderBy("name ASC")
					->findAll()->getData();
				
				$this->set('product_arr', $product_arr);
				$this->set('type_arr', $type_arr);
				$this->set('send_arr', $send_arr);
				$this->set('from_arr', $from_arr);
			}
		}
	}
	
	public function pjActionStep2()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			
		}
	}
	public function pjActionStep3()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
				
		}
	}
	public function pjActionSaveForm()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				$text = __('front_post_content_error', true);
				$text = str_replace("{SIZE}", ini_get('post_max_size'), $text);
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 103, 'text' => $text));
			}
			if(isset($_SESSION[$this->defaultForm]) && !empty($_SESSION[$this->defaultForm]))
			{
				if (!isset($_POST['captcha']) || !isset($_SESSION[$this->defaultCaptcha]) || !pjCaptcha::validate($_POST['captcha'], $_SESSION[$this->defaultCaptcha]) || empty($_POST['captcha']) || (isset($_SESSION[$this->defaultCaptcha])  && empty($_SESSION[$this->defaultCaptcha])) )
				{
					pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 104, 'text' => __('front_captcha_incorrect', true)));
				}
				if(isset($_POST['step_2']))
				{
					$FORM = array_merge($_SESSION[$this->defaultForm], $_POST);
					
					$data = array();
					$data['type'] = $FORM['type'];
					$data['email'] = $FORM['email'];
					$data['name'] = $FORM['name'];
					$data['product_id'] = $FORM['product_id'];
					
					$data['suggestion_type_id'] = ':NULL';
					$data['suggestion_description'] = ':NULL';
					$data['bug_version'] = ':NULL';
					$data['bug_description'] = ':NULL';
					$data['bug_steps'] = ':NULL';
					$data['compliment_send_id'] = ':NULL';
					$data['compliment_testimonials'] = ':NULL';
					$data['complaint_from_id'] = ':NULL';
					$data['complaint_reason'] = ':NULL';
					$data['complaint_improve'] = ':NULL';
					
					switch ($FORM['type']) {
						case 'suggestion':
							$data['suggestion_type_id'] = $FORM['suggestion_type_id'];
							$data['suggestion_description'] = $FORM['suggestion_description'];
							break;
						case 'bug':
							$data['bug_version'] = $FORM['bug_version'];
							$data['bug_description'] = $FORM['bug_description'];
							$data['bug_steps'] = $FORM['bug_steps'];
							break;
						case 'compliment':
							$data['compliment_send_id'] = $FORM['compliment_send_id'];
							$data['compliment_testimonials'] = $FORM['compliment_testimonials'];
							break;
						case 'complaint':
							$data['complaint_from_id'] = $FORM['complaint_from_id'];
							$data['complaint_reason'] = $FORM['complaint_reason'];
							$data['complaint_improve'] = $FORM['complaint_improve'];
							break;
					}
					$data['created'] = date('Y-m-d H:i:s');
					
					$pjFeedbackModel = pjFeedbackModel::factory();
					
					$id = $pjFeedbackModel->setAttributes($data)->insert()->getInsertId();
					if ($id !== false && (int) $id > 0)
					{
						if( ($FORM['type'] == 'suggestion' || $FORM['type'] == 'bug'))
						{
							if(!empty($_FILES['files']['name'][0]))
							{
								$files = array();
								foreach ($_FILES['files'] as $k => $l) {
									foreach ($l as $i => $v) {
										if (!array_key_exists($i, $files))
										{
											$files[$i] = array();
										}
										$files[$i][$k] = $v;
									}
								}
								$has_error = false;
								foreach ($files as $file)
								{
									if($file['error'] != 4 && $file['error'] != 0)
									{
										$has_error = true;
										$code = 101;
										$text = __('front_file_error', true);
										pjAppController::jsonResponse(array('status' => 'ERR', 'code' => $code, 'text' => $text));
									}
									$path = $file['name'];
									$filename_arr[] = $path;
									$extension = pathinfo($path, PATHINFO_EXTENSION);
									$allowed_arr = explode("|", $this->option_arr['o_file_allowed']);
									if(!in_array($extension, $allowed_arr))
									{
										$has_error = true;
										$code = 102;
										$text = __('front_extionsion_message', true);
										pjAppController::jsonResponse(array('status' => 'ERR', 'code' => $code, 'text' => $text));
									}
									if($file['error'] == 1 || $file['error'] == 2)
									{
										$text = __('front_max_file_size_error', true);
										$text = str_replace("{MAXSIZE}", ini_get('upload_max_filesize'), $text);
										pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 104, 'text' => $text));
									}
								}
								if($has_error == false)
								{
									$pjFileModel = pjFileModel::factory();
									foreach ($files as $file)
									{
										$hash = md5(uniqid(rand(), true));
										$handle = new pjUpload();
										
										if ($handle->load($file))
										{
											$fdata = array();
											$file_ext = $handle->getExtension();
											$file_path = PJ_UPLOAD_PATH . 'files/' . $id . '_' . $hash . '.' . $file_ext;
											if($handle->save($file_path))
											{
												$fdata['feedback_id'] = $id;
												$fdata['mime_type'] = $file['type'];
												$fdata['file_path'] = $file_path;
												$fdata['file_name'] = $file['name'];
												$fdata['file_size'] = $file['size'];
												$fdata['hash'] = $hash;
											}
											$pjFileModel->reset()->setAttributes($fdata)->insert();
										}
									}
								}
							}
						}
					}
					
					pjAppController::pjActionConfirmSend($this->option_arr, $id, PJ_SALT, $FORM['type'], $this->getLocaleId());
					
					unset($_SESSION[$this->defaultForm]);
					unset($_SESSION[$this->defaultCaptcha]);
					
					pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => ''));
				}else{
					pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 101, 'text' => __('front_missing_parameters', true)));
				}
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => __('front_missing_parameters', true)));
			}
		}
	}
	
	public function isXHR()
	{
		return parent::isXHR() || isset($_SERVER['HTTP_ORIGIN']);
	}
	
	static protected function allowCORS()
	{
		$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '*';
		header('P3P: CP="ALL DSP COR CUR ADM TAI OUR IND COM NAV INT"');
		header("Access-Control-Allow-Origin: $origin");
		header("Access-Control-Allow-Credentials: true");
		header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
		header("Access-Control-Allow-Headers: Origin, X-Requested-With");
	}
}
?>