var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmCreateFeedback = $("#frmCreateFeedback"),
			$frmUpdateFeedback = $("#frmUpdateFeedback"),
			$dialogDelete = $("#dialogDeleteFile"),
			dialog = ($.fn.dialog !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);
		
		function feedbackBox() {
			var type = $("select[name='type']").find("option:selected").val();
			$('.feedbackBox').hide();
			$('.feedbackBox').find('.fakeRequired').removeClass('required');
			$('.'+type+'Box').show();
			$('.'+type+'Box').find('.fakeRequired').addClass('required');
			if(type == 'suggestion' || type == 'bug')
			{
				$('.fileBox').show();
			}else{
				$('.fileBox').hide();
			}
		}
		if ($frmCreateFeedback.length > 0 && validate) {
			$frmCreateFeedback.validate({
				rules: {
					"files[]":{
						extension: myLabel.allowed_extension
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
			feedbackBox.call(null);
		}
		if ($frmUpdateFeedback.length > 0 && validate) {
			$frmUpdateFeedback.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
			feedbackBox.call(null);
		}
		if ($dialogDelete.length > 0 && dialog) 
		{
			$dialogDelete.dialog({
				modal: true,
				autoOpen: false,
				resizable: false,
				draggable: false,
				width: 320,
				buttons: (function () {
					var buttons = {};
					buttons[ffsApp.locale.button.delete] = function () {
						$.ajax({
							type: "GET",
							dataType: "json",
							url: "index.php?controller=pjAdminFeedback&action=pjActionDeleteFile&id=" + $dialogDelete.data('id'),
							success: function (res) {
								if(res.code == 200){
									$dialogDelete.data('row').remove();
									if($('#fileContainer').find('.fileRow').length == 0)
									{
										$('#fileContainer').parent().parent().remove();
									}
									$dialogDelete.dialog('close');
								}
							}
						});
					};
					buttons[ffsApp.locale.button.cancel] = function () {
						$dialogDelete.dialog("close");
					};
					
					return buttons;
				})()
			});
		}
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminFeedback&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminFeedback&action=pjActionDeleteFeedback&id={:id}"}
				          ],
				columns: [{text: myLabel.type, type: "text", sortable: true, editable: false, width: 140},
				          {text: myLabel.product, type: "text", sortable: true, editable: false, width: 160},
				          {text: myLabel.name, type: "text", sortable: true, editable: false, width: 160},
				          {text: myLabel.datetime, type: "text", sortable: true, editable: false, width: 130}],
				dataUrl: "index.php?controller=pjAdminFeedback&action=pjActionGetFeedback" + pjGrid.queryString,
				dataType: "json",
				fields: ['type', 'product', 'name', 'created'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminFeedback&action=pjActionDeleteFeedbackBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminFeedback&action=pjActionSaveFeedback&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: "",
				name: "",
				type: "",
				product_id: "",
				from_date: "",
				to_date: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminFeedback&action=pjActionGetFeedback", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminFeedback&action=pjActionGetFeedback", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val(),
				name: "",
				type: "",
				product_id: "",
				from_date: "",
				to_date: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminFeedback&action=pjActionGetFeedback", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".pj-button-detailed, .pj-button-detailed-arrow", function (e) {
			e.stopPropagation();
			$(".pj-form-filter-advanced").toggle();
		}).on("submit", ".frm-filter-advanced", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var obj = {},
				$this = $(this),
				arr = $this.serializeArray(),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			for (var i = 0, iCnt = arr.length; i < iCnt; i++) {
				obj[arr[i].name] = arr[i].value;
			}
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminFeedback&action=pjActionGetFeedback", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("reset", ".frm-filter-advanced", function (e) {
			$(".pj-button-detailed").trigger("click");
			$("#name").val('');
			$("#search_type").val('');
			$("#search_product_id").val('');
			$("#from_date").val('');
			$("#to_date").val('');
		}).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				$dp.trigger("focusin").datepicker("show");
			}
			
		}).on("focusin", ".datepicker", function (e) {
			var minDate, maxDate,
				$this = $(this),
				custom = {},
				o = {
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev"),
			};
			switch ($this.attr("name")) {
			case "from_date":
				if($(".datepicker[name='to_date']").val() != '')
				{
					maxDate = $(".datepicker[name='to_date']").datepicker({
						firstDay: $this.attr("rel"),
						dateFormat: $this.attr("rev"),
					}).datepicker("getDate");
					$(".datepicker[name='to_date']").datepicker("destroy").removeAttr("id");
					if (maxDate !== null) {
						custom.maxDate = maxDate;
					}
				}
				break;
			case "to_date":
				if($(".datepicker[name='from_date']").val() != '')
				{
					minDate = $(".datepicker[name='from_date']").datepicker({
						firstDay: $this.attr("rel"),
						dateFormat: $this.attr("rev")
					}).datepicker("getDate");
					$(".datepicker[name='from_date']").datepicker("destroy").removeAttr("id");
					if (minDate !== null) {
						custom.minDate = minDate;
					}
				}
				break;
			}
			$(this).datepicker($.extend(o, custom));
			
		}).on("change", "#type", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			feedbackBox.call(null);
			return false;
		}).on("click", ".deleteFile", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$dialogDelete.data('row', $(this).parent()).data('id', $(this).data('id')).dialog("open");
		});
	});
})(jQuery_1_8_2);