var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs"),
			tOpt = {
				activate: function (event, ui) {
					$(":input[name='tab_id']").val(ui.newPanel.attr('id'));
				}
			};
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs(tOpt);
		}
		$(".field-int").spinner({
			min: 0
		});
		
				
		$("#content").on("change", "select[name='value-enum-o_send_email']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'mail|smtp::mail':
				$(".boxSmtp").hide();
				break;
			case 'mail|smtp::smtp':
				$(".boxSmtp").show();
				break;
			}
		}).on("focusin", ".textarea_install", function (e) {
			$(this).select();
		}).on("click", ".pj-use-theme", function (e) {
			var theme = $(this).attr('data-theme'),
				href = $('#pj_preview_install').attr('href');
			$('.pj-loader').css('display', 'block');
			$('#preview_type').attr('data-theme', 'theme' + theme);
			$.ajax({
				type: "GET",
				async: false,
				url: 'index.php?controller=pjAdminOptions&action=pjActionUpdateTheme&theme=' + theme,
				success: function (data) {
					$('.theme-holder').html(data);
					$('.pj-loader').css('display', 'none');
					reDrawCode.call(null, 0);
				}
			});
		}).on("change", "#theme", function (e) {
			reDrawCode.call(null, 1);
		}).on("change", ".pjFfsTypeSelector", function (e) {
			reDrawCode.call(null, 0);
		}).on("change", "#email_notify", function (e) {
			var value = $(this).val();
			$('.boxEmail').hide();
			$('.box' + value).show();
		}).on("change", ".pjFfsStyleSelector", function (e) {
			if($(this).val() == 'link')
			{
				$('#pjUseLinkContainer').show();
			}else{
				$('#pjUseLinkContainer').hide();
			}
			reDrawCode.call(null, 0);
		});
		if ($('#frmNotification').length > 0) 
		{
			var value = $('#email_notify').val();
			$('.box' + value).show();
				
			tinymce.init({
			    selector: "textarea.mceEditor",
			    theme: "modern",
			    width: 500,
			    plugins: [
			         "advlist autolink link image lists charmap print preview hr anchor pagebreak",
			         "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
			         "save table contextmenu directionality emoticons template paste textcolor"
			   ],
			   toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons"
			 });
		}
		function reDrawCode(open) {
			var code = $("#hidden_code").text();
			var type = "";
			var theme = "";
			var link = "";
			var allVals = [];
			$('.pjFfsTypeSelector').each(function() {
				if($(this).is(":checked"))
				{
					allVals.push($(this).val());
				}
			});
			if(allVals.length == 0 || allVals.length == 4)
			{
				$('.pjFfsTypeSelector').each(function() {
					$(this).attr('checked','checked');
				});
			}else{
				type = "&type=" + allVals.join("|");
			}
			$('.pj_preview_install').each(function(){
				if($(this).parent().hasClass('active'))
				{
					theme = $(this).attr('data-theme');
				}
			});
			theme = theme != '' ? "&theme=" + theme : "";
			
			if($('#style_link').is(":checked"))
			{
				link = "&link=1";
			}
			
			code = code.replace(/&action=pjActionLoadCss/g, function(match) {
	            return ["&action=pjActionLoadCss", theme, link].join("");
	        });
			code = code.replace(/&action=pjActionLoadJS/g, function(match) {
	            return ["&action=pjActionLoad", type, theme, link].join("");
	        });
			
			$("#install_code").text(code);
			
			if(type != "")
			{
				$('.pj_preview_install').each(function(){
					var theme = $(this).attr('data-theme');
					$(this).attr('href', 'preview.php?theme=' + theme + type);
				});
			}else{
				$('.pj_preview_install').each(function(){
					var theme = $(this).attr('data-theme');
					$(this).attr('href', 'preview.php?theme=' + theme);
				});
			}
		}
		
	});
})(jQuery_1_8_2);