(function (window, undefined){
	"use strict";
	
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	
	var document = window.document,
		validate = (pjQ.$.fn.validate !== undefined),
		routes = [];
	
	var tests = {
			dnd: 'draggable' in document.createElement('span'),
			formdata: !!window.FormData
		};
	function log() {
		if (window.console && window.console.log) {
			for (var x in arguments) {
				if (arguments.hasOwnProperty(x)) {
					window.console.log(arguments[x]);
				}
			}
		}
	}
	
	function assert() {
		if (window && window.console && window.console.assert) {
			window.console.assert.apply(window.console, arguments);
		}
	}
	
	function hashBang(value) {
		if (value !== undefined && value.match(/^#!\//) !== null) {
			if (window.location.hash == value) {
				return false;
			}
			window.location.hash = value;
			return true;
		}
		
		return false;
	}
	
	function onHashChange() {
		var i, iCnt, m;
		for (i = 0, iCnt = routes.length; i < iCnt; i++) {
			m = window.location.hash.match(routes[i].pattern);
			if (m !== null) {
				pjQ.$(window).trigger(routes[i].eventName, m.slice(1));
				break;
			}
		}
		if (m === null) {
			pjQ.$(window).trigger("loadStep0");
		}
	}
	pjQ.$(window).on("hashchange", function (e) {
    	onHashChange.call(null);
    });
	
	function FeedbackForm(opts) {
		if (!(this instanceof FeedbackForm)) {
			return new FeedbackForm(opts);
		}
				
		this.reset.call(this);
		this.init.call(this, opts);
		
		return this;
	}
	
	FeedbackForm.inObject = function (val, obj) {
		var key;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				if (obj[key] == val) {
					return true;
				}
			}
		}
		return false;
	};
	
	FeedbackForm.size = function(obj) {
		var key,
			size = 0;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				size += 1;
			}
		}
		return size;
	};
	
	FeedbackForm.prototype = {
		reset: function () {
			this.$container = null;
			this.container = null;
			this.$feedbackIcon = null;
			this.type = null;
			this.file_arr = null;
			this.opts = {};
			
			return this;
		},
		disableButtons: function () {
			var $el;
			this.$container.find(".pjFfs-btn-primary").each(function (i, el) {
				$el = pjQ.$(el).attr("disabled", "disabled");
			});
		},
		enableButtons: function () {
			this.$container.find(".pjFfs-btn-primary").removeAttr("disabled");
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			this.container = document.getElementById("pjFfsContainer_" + this.opts.index);
			this.$container = pjQ.$(this.container);
			this.$feedbackIcon = pjQ.$('#pjFfsFeedbackIcon_' + this.opts.index);
			
			this.$feedbackIcon.on('click.ffs', '.pjFfs-head-icon', function(e){
				self.$container.removeClass('pjFfs-hidden');
				self.$feedbackIcon.removeClass('pjFfs-active').addClass('pjFfs-inactive');
			});
			
			this.$container.on('click.ffs', '.pjFfs-head-title', function(e){

				pjQ.$('.pjFfs-head').toggleClass('active');

				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if(self.$container.hasClass('pjFfs-step0'))
				{
					self.$container.removeClass('pjFfs-step0');
				}else{
					self.$container.addClass('pjFfs-step0');
				}
			}).on('click.ffs', '.pjFfs-btn-close', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.$container.addClass('pjFfs-hidden');
				self.$feedbackIcon.removeClass('pjFfs-inactive').addClass('pjFfs-active');
			}).on('click.ffs', '.pjFfs-btn-back', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var step = pjQ.$(this).attr('data-step');
				if(step == '1')
				{
					self.loadStep1.call(self);
				}else if(step == '2'){
					self.loadStep2.call(self);
				}else{
					self.loadStep0.call(self);
				}
			}).on('click.ffs', '.pjFfs-feedback-type', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.type = pjQ.$(this).attr('data-type');
				self.loadStep1.call(self);
			}).on('click.ffs', '#pjFfsCaptchaImage', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $captchaImg = pjQ.$(this);
				if($captchaImg.length > 0){
					var rand = Math.floor((Math.random()*999999)+1); 
					$captchaImg.attr("src", self.opts.folder + 'index.php?controller=pjFront&action=pjActionCaptcha&rand=' + rand);
					pjQ.$('#pjFfsStep2Form').find('input[name="captcha"]').val("");
				}
				return false;
			});
			
			pjQ.$('.pjFfsOpenFeedbackForm').on('click.sp', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if(self.$container.hasClass('pjFfs-hidden'))
				{
					self.$container.removeClass('pjFfs-hidden');
					self.$feedbackIcon.removeClass('pjFfs-active').addClass('pjFfs-inactive');
				}else{
					self.$container.addClass('pjFfs-hidden');
				}
			});
			
			pjQ.$(window).on("loadStep0", this.container, function (e) {
				self.loadStep0.call(self);
			});
			
			if (window.location.hash.length === 0) {
				this.loadStep0.call(this);
			} else {
				onHashChange.call(null);
			}
		},
		bindFileFields: function(){
			var self = this;
			var inputSelector = '.pjFfsFileUploadField';
			var namesSelector = '.pjFfsUploadedFiles';
			var multipleNamesDivider = '; ';
			
			pjQ.$(inputSelector).on('change', function() {
				var input = this,
					files = input.files,
					allowed_ext = pjQ.$(input).attr('data-extension'),
					valid = false;
				
				pjQ.$('#pjFfsFileErrorMessage').html("").parent().hide();
				pjQ.$.map(files, function(file) {
					var file_name = file.name,
						file_extension = file_name.substr( (file_name.lastIndexOf('.') + 1) );
					if(allowed_ext != '')
					{
						var allowed_arr = allowed_ext.split("|");
						if(pjQ.$.inArray(file_extension, allowed_arr) > -1)
						{
							valid = true;
						}
					}
				});
				pjQ.$(namesSelector)
					.text(
						pjQ.$.map(files, function(file) {
							var file_name = file.name;
							return file.name;
						}).join(multipleNamesDivider)
					);
				if(valid == true)
				{
					self.file_arr = files;
				}
			});
		},
		bindSuggestion: function () {
			var self = this;
			
			var $frmSuggestion = pjQ.$('#pjFfsSuggestionForm');
			
			if($frmSuggestion.length > 0)
			{
				self.bindFileFields.call(self);
				
				$frmSuggestion.validate({
					rules: {
						"files[]":{
							extension: self.opts.allowed_extension
						}
					},
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						if(element.attr('name') == 'files[]')
						{
							error.appendTo(element.parent().next().find('ul'));
						}else{
							error.appendTo(element.next().find('ul'));
						}
					},
		            highlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	if(element.attr('name') == 'files[]')
						{
							element.parent().parent().removeClass('pjFfs-has-success').addClass('pjFfs-has-error');
						}else{
							element.parent().removeClass('pjFfs-has-success').addClass('pjFfs-has-error');
						}
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	if(element.attr('name') == 'files[]')
						{
							element.parent().parent().removeClass('pjFfs-has-error').addClass('pjFfs-has-success');
						}else{
							element.parent().removeClass('pjFfs-has-error').addClass('pjFfs-has-success');
						}
		            },
		            submitHandler: function (form) {
						self.disableButtons.call(self);
						var $form = pjQ.$(form);
						
						var formData = tests.formdata ? new FormData() : new FData();
						var files = self.file_arr;
						formData.append('step_1', 1);
						formData.append('type', self.type);
						formData.append('product_id', $form.find('select[name="product_id"]').val());
						formData.append('suggestion_type_id', $form.find('select[name="suggestion_type_id"]').val());
						formData.append('suggestion_description', $form.find('textarea[name="suggestion_description"]').val());
						
						if(files != null)
						{
							for (var i = 0; i < files.length; i++) {
								formData.append('files[]', files[i]);
							}
						}
						var ajax_url = [self.opts.folder, "index.php?controller=pjFront&action=pjActionStep1"].join("");
						if(self.opts.session_id != '')
						{
							ajax_url = [self.opts.folder, "index.php?controller=pjFront&action=pjActionStep1", "&session_id=", self.opts.session_id].join("");
						}
						pjQ.$.ajax({
						    url: ajax_url,
						    type: 'POST',
						    data: formData,
						    dataType: 'json',
						    cache: false,
						    contentType: false,
						    processData: false,
						    success: function(data) {
						    	if(data.status == 'OK')
						    	{
						    		self.loadStep2.call(self);
						    	}else{
						    		pjQ.$('#pjFfsFileErrorMessage').html(data.text).parent().show();
						    		self.enableButtons.call(self);
						    	}
						    }
						});
						return false;
					}
				});
			}
		},
		bindBug: function () {
			var self = this;
			var $frmBug = pjQ.$('#pjFfsBugForm');
			
			if($frmBug.length > 0)
			{
				self.bindFileFields.call(self);
				
				$frmBug.validate({
					rules: {
						"files[]":{
							extension: self.opts.allowed_extension
						}
					},
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						if(element.attr('name') == 'files[]')
						{
							error.appendTo(element.parent().next().find('ul'));
						}else{
							error.appendTo(element.next().find('ul'));
						}
					},
		            highlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	if(element.attr('name') == 'files[]')
						{
							element.parent().parent().removeClass('pjFfs-has-success').addClass('pjFfs-has-error');
						}else{
							element.parent().removeClass('pjFfs-has-success').addClass('pjFfs-has-error');
						}
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	if(element.attr('name') == 'files[]')
						{
							element.parent().parent().removeClass('pjFfs-has-error').addClass('pjFfs-has-success');
						}else{
							element.parent().removeClass('pjFfs-has-error').addClass('pjFfs-has-success');
						}
		            },
		            submitHandler: function (form) {
						self.disableButtons.call(self);
						var $form = pjQ.$(form);
						
						var formData = tests.formdata ? new FormData() : new FData();
						var files = self.file_arr;
						formData.append('step_1', 1);
						formData.append('type', self.type);
						formData.append('product_id', $form.find('select[name="product_id"]').val());
						formData.append('bug_version', $form.find('input[name="bug_version"]').val());
						formData.append('bug_description', $form.find('textarea[name="bug_description"]').val());
						formData.append('bug_steps', $form.find('textarea[name="bug_steps"]').val());
						
						if(files != null)
						{
							for (var i = 0; i < files.length; i++) {
								formData.append('files[]', files[i]);
							}
						}
						var ajax_url = [self.opts.folder, "index.php?controller=pjFront&action=pjActionStep1"].join("");
						if(self.opts.session_id != '')
						{
							ajax_url = [self.opts.folder, "index.php?controller=pjFront&action=pjActionStep1", "&session_id=", self.opts.session_id].join("");
						}
						pjQ.$.ajax({
						    url: ajax_url,
						    type: 'POST',
						    data: formData,
						    dataType: 'json',
						    cache: false,
						    contentType: false,
						    processData: false,
						    success: function(data) {
						    	if(data.status == 'OK')
						    	{
						    		self.loadStep2.call(self);
						    	}else{
						    		pjQ.$('#pjFfsFileErrorMessage').html(data.text).parent().show();
						    	}
						    }
						});
						return false;
					}
				});
			}
		},
		bindCompliment: function () {
			var self = this;
			var $frmCompliment = pjQ.$('#pjFfsComplimentForm');
			
			if($frmCompliment.length > 0)
			{
				$frmCompliment.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
		            highlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().removeClass('pjFfs-has-success').addClass('pjFfs-has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().removeClass('pjFfs-has-error').addClass('pjFfs-has-success');
		            },
		            submitHandler: function (form) {
						self.disableButtons.call(self);
						var $form = pjQ.$(form);
						
						var formData = tests.formdata ? new FormData() : new FData();
						formData.append('step_1', 1);
						formData.append('type', self.type);
						formData.append('product_id', $form.find('select[name="product_id"]').val());
						formData.append('compliment_send_id', $form.find('select[name="compliment_send_id"]').val());
						formData.append('compliment_testimonials', $form.find('textarea[name="compliment_testimonials"]').val());
												
						var ajax_url = [self.opts.folder, "index.php?controller=pjFront&action=pjActionStep1"].join("");
						if(self.opts.session_id != '')
						{
							ajax_url = [self.opts.folder, "index.php?controller=pjFront&action=pjActionStep1", "&session_id=", self.opts.session_id].join("");
						}
						pjQ.$.ajax({
						    url: ajax_url,
						    type: 'POST',
						    data: formData,
						    dataType: 'json',
						    cache: false,
						    contentType: false,
						    processData: false,
						    success: function(data) {
						    	if(data.status == 'OK')
						    	{
						    		self.loadStep2.call(self);
						    	}
						    }
						});
						return false;
					}
				});
			}
		},
		bindComplaint: function () {
			var self = this;
			var $frmComplaint = pjQ.$('#pjFfsComplaintForm');
			
			if($frmComplaint.length > 0)
			{
				$frmComplaint.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
		            highlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().removeClass('pjFfs-has-success').addClass('pjFfs-has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	element.parent().removeClass('pjFfs-has-error').addClass('pjFfs-has-success');
		            },
		            submitHandler: function (form) {
						self.disableButtons.call(self);
						var $form = pjQ.$(form);
						
						var formData = tests.formdata ? new FormData() : new FData();
						formData.append('step_1', 1);
						formData.append('type', self.type);
						formData.append('product_id', $form.find('select[name="product_id"]').val());
						formData.append('complaint_from_id', $form.find('select[name="complaint_from_id"]').val());
						formData.append('complaint_reason', $form.find('input[name="complaint_reason"]').val());
						formData.append('complaint_improve', $form.find('textarea[name="complaint_improve"]').val());
												
						var ajax_url = [self.opts.folder, "index.php?controller=pjFront&action=pjActionStep1"].join("");
						if(self.opts.session_id != '')
						{
							ajax_url = [self.opts.folder, "index.php?controller=pjFront&action=pjActionStep1", "&session_id=", self.opts.session_id].join("");
						}
						pjQ.$.ajax({
						    url: ajax_url,
						    type: 'POST',
						    data: formData,
						    dataType: 'json',
						    cache: false,
						    contentType: false,
						    processData: false,
						    success: function(data) {
						    	if(data.status == 'OK')
						    	{
						    		self.loadStep2.call(self);
						    	}
						    }
						});
						return false;
					}
				});
			}
		},
		bindStep2: function () {
			var self = this,
				index = this.opts.index;
			
			var $frmStep2 = pjQ.$('#pjFfsStep2Form');
			
			if($frmStep2.length > 0)
			{
				var remote_url = self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckCaptcha";
				if(self.opts.session_id != '')
				{
					remote_url += "&session_id=" + self.opts.session_id;
				}
				$frmStep2.validate({
					rules: {
						"captcha": {
							remote: remote_url
						}
					},
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						if(element.attr('name') == 'captcha')
						{
							error.appendTo(element.parent().next().find('ul'));
						}else{
							error.appendTo(element.next().find('ul'));
						}
					},
		            highlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	if(element.attr('name') == 'captcha')
						{
		            		element.parent().parent().removeClass('pjFfs-has-success').addClass('pjFfs-has-error');
						}else{
							element.parent().removeClass('pjFfs-has-success').addClass('pjFfs-has-error');
						}
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var element = pjQ.$(ele);
		            	if(element.attr('name') == 'captcha')
						{
		            		element.parent().parent().removeClass('pjFfs-has-error').addClass('pjFfs-has-success');
						}else{
							element.parent().removeClass('pjFfs-has-error').addClass('pjFfs-has-success');
						}
		            },
		            submitHandler: function (form) {
						self.disableButtons.call(self);
						var $form = pjQ.$(form);
						
						var formData = tests.formdata ? new FormData() : new FData();
						var files = self.file_arr;
						formData.append('step_2', 1);
						formData.append('type', self.type);
						formData.append('name', $form.find('input[name="name"]').val());
						formData.append('email', $form.find('input[name="email"]').val());
						formData.append('captcha', $form.find('input[name="captcha"]').val());
						if(files != null)
						{
							for (var i = 0; i < files.length; i++) {
								formData.append('files[]', files[i]);
							}
						}
						var ajax_url = [self.opts.folder, "index.php?controller=pjFront&action=pjActionSaveForm"].join("");
						if(self.opts.session_id != '')
						{
							ajax_url = [self.opts.folder, "index.php?controller=pjFront&action=pjActionSaveForm", "&session_id=", self.opts.session_id].join("");
						}
						pjQ.$.ajax({
						    url: ajax_url,
						    type: 'POST',
						    data: formData,
						    dataType: 'json',
						    cache: false,
						    contentType: false,
						    processData: false,
						    complete: function() {
						    	
						    },
						    xhr: function() {
				                var myXhr = pjQ.$.ajaxSettings.xhr();
				                if(myXhr.upload){
				                    
				                }
				                return myXhr;
						    },
						    success: function(data) {
						    	if(data.status == 'OK')
						    	{
						    		self.loadStep3.call(self);
						    	}else{
						    		pjQ.$('#pjFfsFormErrorMessage').html(data.text).parent().show();
						    	}
						    },
						    error: function() {
						      
						    }
						});
						
						return false;
					}
				});
			}
		},
		loadStep0: function () {
			var self = this,
				index = this.opts.index,
				params = 	{};
			params.locale = this.opts.locale;
			params.index = this.opts.index;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			if(self.opts.single == 1)
			{
				self.type = self.opts.type;
				self.loadStep1.call(self);
			}else{
				params.type = self.opts.type;
				pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionStep0"].join(""), params).done(function (data) {
					self.$container.html(data);

					setTimeout(function(){
						pjQ.$('.pjFfs').addClass('active');
						
					},1);
				}).fail(function () {
					self.enableButtons.call(self);
				});
			}
		},
		loadStep1: function () {
			var self = this,
				index = this.opts.index,
				params = 	{};
			params.locale = this.opts.locale;
			params.index = this.opts.index;
			params.single = self.opts.single;
			if(self.type != '')
			{
				params.type = self.type;
			}
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionStep1"].join(""), params).done(function (data) {
				self.$container.html(data);
				self.bindSuggestion.call(self);
				self.bindBug.call(self);
				self.bindCompliment.call(self);
				self.bindComplaint.call(self);
				setTimeout(function(){
					pjQ.$('.pjFfs').addClass('active');
					
				},1);
			}).fail(function () {
				self.enableButtons.call(self);
			});
		},
		loadStep2: function () {
			var self = this,
				index = this.opts.index,
				params = 	{};
			params.locale = this.opts.locale;
			params.index = this.opts.index;
			params.single = self.opts.single;
			if(self.type != '')
			{
				params.type = self.type;
			}
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionStep2"].join(""), params).done(function (data) {
				self.$container.html(data);
				self.bindStep2.call(self);
				setTimeout(function(){
					pjQ.$('.pjFfs').addClass('active');
					
				},1);
			}).fail(function () {
				self.enableButtons.call(self);
			});
		},
		loadStep3: function () {
			var self = this,
				index = this.opts.index,
				params = 	{};
			params.locale = this.opts.locale;
			params.index = this.opts.index;
			params.single = self.opts.single;
			if(self.type != '')
			{
				params.type = self.type;
			}
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionStep3"].join(""), params).done(function (data) {
				self.$container.html(data);
				setTimeout(function(){
					pjQ.$('.pjFfs').addClass('active');
					
				},1);
			}).fail(function () {
				self.enableButtons.call(self);
			});
		}
	};
	
	window.FeedbackForm = FeedbackForm;	
})(window);