<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjUtil extends pjToolkit
{	
	static public function uuid()
	{
		return chr(rand(65,90)) . chr(rand(65,90)) . time();
	}
	public static function getTimezoneList()
	{
		$timezone_value_str = "-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800";
		$timezone_label_str = "GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00";
		$timezone_value_arr = explode("|", $timezone_value_str);
		$timezone_label_arr = explode("|", $timezone_label_str);
		
		if(count($timezone_value_arr) != count($timezone_label_arr)) return array();
		
		$timezone_arr = array();
		foreach ($timezone_value_arr as $k => $timezone)
		{
			$timezone_arr[$timezone] = $timezone_label_arr[$k];
		}
		
		return $timezone_arr;
	}
	
	public static function convertTimestamp($timestamp, $from_timezone = 0, $to_timezone = 0)
	{
		if($from_timezone == $to_timezone)  return $timestamp;
		$timezone_list_arr = pjUtil::getTimezoneList();
		
		$offset = $from_timezone / 3600;		
		if ($offset > 0)
		{
			$offset = "-".$offset;
		} elseif ($offset < 0) {
			$offset = "+".abs($offset);
		} elseif ($offset === 0) {
			$offset = "+0";
		}
		$gmt_timestamp = $timestamp + (int) $offset * 3600; 
		
		$offset = $to_timezone / 3600;
		if ($offset > 0)
		{
			$offset = "-".$offset;
		} elseif ($offset < 0) {
			$offset = "+".abs($offset);
		} elseif ($offset === 0) {
			$offset = "+0";
		}
		return $gmt_timestamp - (int) $offset * 3600;
	}
	
	static public function getReferer()
	{
		if (isset($_GET['_escaped_fragment_']))
		{
			if (isset($_SERVER['REDIRECT_URL']))
			{
				return $_SERVER['REDIRECT_URL'];
			}
		}
	
		if (isset($_SERVER['HTTP_REFERER']))
		{
			$pos = strpos($_SERVER['HTTP_REFERER'], "#");
			if ($pos !== FALSE)
			{
				return substr($_SERVER['HTTP_REFERER'], 0, $pos);
			}
			return $_SERVER['HTTP_REFERER'];
		}
	}
	
	static public function getClientIp()
	{
		if (isset($_SERVER['HTTP_CLIENT_IP']))
		{
			return $_SERVER['HTTP_CLIENT_IP'];
		} else if(isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
			return $_SERVER['HTTP_X_FORWARDED_FOR'];
		} else if(isset($_SERVER['HTTP_X_FORWARDED'])) {
			return $_SERVER['HTTP_X_FORWARDED'];
		} else if(isset($_SERVER['HTTP_FORWARDED_FOR'])) {
			return $_SERVER['HTTP_FORWARDED_FOR'];
		} else if(isset($_SERVER['HTTP_FORWARDED'])) {
			return $_SERVER['HTTP_FORWARDED'];
		} else if(isset($_SERVER['REMOTE_ADDR'])) {
			return $_SERVER['REMOTE_ADDR'];
		}
	
		return 'UNKNOWN';
	}
	
	static public function sortArrayByArray(Array $array, Array $orderArray)
	{
		$ordered = array();
		foreach($orderArray as $key) {
			if(array_key_exists($key,$array)) {
				$ordered[$key] = $array[$key];
				unset($array[$key]);
			}
		}
		return $ordered + $array;
	}
	
	static public function textToHtml($content)
	{
		$content = preg_replace('/\r\n|\n/', '<br />', $content);
		return '<html><head><title></title></head><body>'.$content.'</body></html>';
	}
	
	static public function convertStringToUnicode($string, $code = "UTF-8") {
		if (empty($string)) {
			return null;
		}
		if (function_exists('iconv') && function_exists('mb_detect_encoding') && function_exists('mb_detect_order')) {
			$string = trim(iconv(mb_detect_encoding(trim(strip_tags($string)), mb_detect_order(), true), "UTF-8", trim(strip_tags($string))));
		} else {
			$string = trim(preg_replace('/\r\n|\r|\n/', '', trim(strip_tags($string))));
		}
		return $string;
	}
	
	static public function secondsToTime($seconds)
	{
		$hours = floor($seconds / (60 * 60));
	
		$divisor_for_minutes = $seconds % (60 * 60);
		$minutes = floor($divisor_for_minutes / 60);
	
		$divisor_for_seconds = $divisor_for_minutes % 60;
		$seconds = ceil($divisor_for_seconds);

		$obj = array(
				"h" => (int) $hours,
				"m" => (int) $minutes,
				"s" => (int) $seconds,
		);
		return $obj;
	}
}
?>