<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminSurveys extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			if (isset($_POST['survey_create']))
			{
				$pjSurveyModel = pjSurveyModel::factory();
				$data = array();
				$id = $pjSurveyModel->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					pjSurveyFormFieldModel::factory()->initSurveyForm($id, $this->getLocaleId());
					$err = 'ASV03';
					if (isset($_POST['i18n']))
					{
						pjMultiLangModel::factory()->saveMultiLang($_POST['i18n'], $id, 'pjSurvey', 'data');
					}
					
					$data_question = array();
					$data_question['survey_id'] = $id;
					$data_question['status'] = 'F';
					$data_question['parent_id'] = 0;
					$data_question['lft'] = 1;
					$data_question['rgt'] = 2;
					pjSurveyQuestionModel::factory()->setAttributes($data_question)->insert();	
					
					if(isset($_POST['user_id']))
					{
						$pjSurveyAvailableUserModel = pjSurveyAvailableUserModel::factory();
						$pjSurveyAvailableUserModel->begin();
						foreach ($_POST['user_id'] as $user_id){
							$data = array();
							$data['survey_id'] = $id;
							$data['user_id'] = $user_id;
							$pjSurveyAvailableUserModel->reset()->setAttributes($data)->insert();
						}
						$pjSurveyAvailableUserModel->commit();
					}
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminSurveyQuestions&action=pjActionIndex&survey_id=".$id."&err=ASV03");
				} else {
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminSurveys&action=pjActionIndex&err=ASV04");
				}
			} else {
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
						
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				$this->set('user_arr', pjUserModel::factory()->where('t1.role_id', 2)->orderBy('t1.name ASC')->findAll()->getData());
						
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('pjAdminSurveys.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
		
	public function pjActionDeleteSurvey()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjSurveyModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjMultiLangModel::factory()->where('model', 'pjSurvey')->where('foreign_id', $_GET['id'])->eraseAll();
				pjSurveyFormFieldModel::factory()->where('foreign_id', $_GET['id'])->eraseAll();
				pjSurveyAvailableUserModel::factory()->where('survey_id', $_GET['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteSurveyBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjMultiLangModel::factory()->where('model', 'pjSurvey')->whereIn('foreign_id', $_POST['record'])->eraseAll();
				pjSurveyModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				pjSurveyFormFieldModel::factory()->whereIn('foreign_id', $_POST['record'])->eraseAll();
				pjSurveyAvailableUserModel::factory()->whereIn('survey_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionGetSurvey()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjSurveyModel = pjSurveyModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSurvey' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left');
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjSurveyModel->where('t2.content LIKE', "%$q%");
			}
			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjSurveyModel->where('t1.status', $_GET['status']);
			}

			$column = 'id';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjSurveyModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 20;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$data = $pjSurveyModel
				->select('t1.*, t2.content AS `title`,
				(SELECT COUNT(*) FROM `'.pjSurveyQuestionModel::factory()->getTable().'` WHERE `survey_id` = t1.id AND `status` = "T" AND `parent_id` > 0) AS `num_questions`,
				(SELECT COUNT(*) FROM `'.pjSurveyUserModel::factory()->getTable().'` WHERE `survey_id` = t1.id) AS `num_completed`')
				->orderBy("`$column` $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminSurveys.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveSurvey()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjSurveyModel = pjSurveyModel::factory();
			if (!in_array($_POST['column'], $pjSurveyModel->getI18n()))
			{
				$pjSurveyModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			} else {
				pjMultiLangModel::factory()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjSurvey', 'data');
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			$pjSurveyFormFieldModel = pjSurveyFormFieldModel::factory();
			if (isset($_POST['survey_update']))
			{
				$data = array();
				pjSurveyModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjSurvey', 'data');
				}
				
				$pjSurveyAvailableUserModel = pjSurveyAvailableUserModel::factory();
				$pjSurveyAvailableUserModel->where('survey_id', $_POST['id'])->eraseAll();
				if(isset($_POST['user_id']))
				{
					$pjSurveyAvailableUserModel->reset()->begin();
					foreach ($_POST['user_id'] as $user_id){
						$data = array();
						$data['survey_id'] = $_POST['id'];
						$data['user_id'] = $user_id;
						$pjSurveyAvailableUserModel->reset()->setAttributes($data)->insert();
					}
					$pjSurveyAvailableUserModel->commit();
				}
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminSurveys&action=pjActionUpdate&id=".(int)$_POST['id']."&err=ASV01");
				
			} else if (isset($_POST['options_update'])) {
				foreach ($_POST as $key => $value)
				{
					if (preg_match('/value-(string|text|int|float|enum|bool|color)-(.*)/', $key) === 1)
					{
						list(, $type, $k) = explode("-", $key);
						if (!empty($k))
						{
							$pjSurveyFormFieldModel
								->reset()
								->where('foreign_id', $_POST['id'])
								->where('`key`', $k)
								->limit(1)
								->modifyAll(array('value' => $value));
						}
					}
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminSurveys&action=pjActionUpdate&id=".(int)$_POST['id']."&tab_id=".@$_POST['tab_id']."&err=AO02");
			} else if (isset($_POST['email_update'])) {
				foreach ($_POST as $key => $value)
				{
					if (preg_match('/value-(string|text|int|float|enum|bool|color)-(.*)/', $key) === 1)
					{
						list(, $type, $k) = explode("-", $key);
						if (!empty($k))
						{
							$pjSurveyFormFieldModel
								->reset()
								->where('foreign_id', $_POST['id'])
								->where('`key`', $k)
								->limit(1)
								->modifyAll(array('value' => $value));
						}
					}
				}
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjSurveyForm', 'data');
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminSurveys&action=pjActionUpdate&id=".(int)$_POST['id']."&tab_id=".@$_POST['tab_id']."&err=AO02");
			} else {
				$arr = pjSurveyModel::factory()->select('t1.*, t2.content AS `title`')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSurvey' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left')
						->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminSurveys&action=pjActionIndex&err=ASV08");
				}
				$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjSurvey');
				$this->set('arr', $arr);
				
				$survey_form_field_arr = $pjSurveyFormFieldModel->reset()
					->where('t1.foreign_id', $_GET['id'])
					->orderBy('t1.order ASC')
					->findAll()
					->getData();
				
				$this->set('survey_form_field_arr', $survey_form_field_arr);
				
				$data_field_arr = $pjSurveyFormFieldModel->reset()->getPairs($_GET['id']);
				$data_field_arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($_GET['id'], 'pjSurveyForm');
				$this->set('data_field_arr', $data_field_arr);
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file, t2.title')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
				
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file']; 
				}
				
				$this->set('locale_arr', $locale_arr);
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				$this->set('user_arr', pjUserModel::factory()->where('t1.role_id', 2)->orderBy('t1.name ASC')->findAll()->getData());
				$this->set('user_ids_arr', pjSurveyAvailableUserModel::factory()->where('t1.survey_id', $arr['id'])->findAll()->getDataPair(null, 'user_id'));
				
				$this->appendCss('codemirror.css', PJ_THIRD_PARTY_PATH . 'codemirror/');
				$this->appendJs('codemirror.js', PJ_THIRD_PARTY_PATH . 'codemirror/');
			
				$this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
			
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('pjAdminSurveys.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionCompleted()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminSurveys.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetCompletedSurvey()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjSurveyUserModel = pjSurveyUserModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.survey_id AND t2.model = 'pjSurvey' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left')
				->join('pjUser', 't3.id=t1.user_id', 'left outer');
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjSurveyUserModel->where('(t2.content LIKE "%'.$q.'%" OR t3.name LIKE "%'.$q.'%")');
			}
			if (isset($_GET['survey_id']) && (int)$_GET['survey_id'] > 0) {
				$pjSurveyUserModel->where('t1.survey_id', (int)$_GET['survey_id']);
			}
			
			$column = 'created';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			if (isset($_GET['column']) && in_array($_GET['column'], array('date_completion', 'time_completion'))) {
				$column = 'dt_end_survey';
			}
			$total = $pjSurveyUserModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 20;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$data = $pjSurveyUserModel
				->select('t1.*, t2.content AS `survey_title`, t3.name AS `user_name`')
				->orderBy("`$column` $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			foreach ($data as $k => $item) {
				$seconds = strtotime($item['dt_end_survey']) - strtotime($item['dt_start_survey']);
				$obj_time = pjUtil::secondsToTime($seconds);
				$time_completion = array();
				if($obj_time['h'] > 0)
				{
					$time_completion[] = $obj_time['h'] . ' ' . ($obj_time['h'] == 1 ? __('lblHour', true) : __('lblHours', true));
				}
				if($obj_time['m'] > 0)
				{
					$time_completion[] = $obj_time['m'] . ' ' . ($obj_time['m'] == 1 ? __('lblMinute', true) : __('lblMinutes', true));
				}
				if($obj_time['s'] > 0)
				{
					$time_completion[] = $obj_time['s'] . ' ' . ($obj_time['s'] == 1 ? __('lblSecond', true) : __('lblSeconds', true));
				}
				$data[$k]['date_completion'] = date($this->option_arr['o_date_format'], strtotime($item['dt_end_survey'])) . ', ' . date($this->option_arr['o_time_format'], strtotime($item['dt_end_survey']));
				$data[$k]['time_completion'] = implode(" ", $time_completion);
				if ((int)$item['user_id'] == 0) {
					$data[$k]['user_name'] = __('lblAnonymous', true);
				}
			}
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionDeleteCompletedSurvey()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjSurveyUserModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjSurveyUserDetailModel::factory()->where('survey_user_id', $_GET['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteCompletedSurveyBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjSurveyUserModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				pjSurveyUserDetailModel::factory()->whereIn('survey_user_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionGetExample()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() && $this->isLoged())
		{
			$sid = $_GET['sid'];
			$theme = isset($_GET['theme']) ? $_GET['theme'] : 1;
			$search = array('{PJ_INSTALL_URL}', '{SID}', '{THEME}', '{A_TEXT}');
			$replace = array(PJ_INSTALL_URL, $sid, $theme, __('install_link', true));
				
			$content = @file_get_contents(PJ_VIEWS_PATH . 'pjAdminSurveys/elements/example-1.php');
			if ($content !== FALSE)
			{
				$this->set('example_1', str_replace($search, $replace, $content));
			}
			
			$content = @file_get_contents(PJ_VIEWS_PATH . 'pjAdminSurveys/elements/example-3.php');
			if ($content !== FALSE)
			{
				$this->set('example_3', str_replace($search, $replace, $content));
			}
		}
	}
}
?>