<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminItems extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['item_create']))
			{
				$data = array();
				$data['created'] = date('Y-m-d H:i:s');
				$id = pjItemModel::factory(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$pjChoiceModel = pjChoiceModel::factory();
					if(isset($_POST['choice_title']) && count($_POST['choice_title']))
					{
						$pjChoiceModel->reset()->begin();
						foreach($_POST['choice_title'] as $k => $choice_title)
						{
							$cdata = array();
							$cdata['item_id'] = $id;
							$cdata['choice_title'] = $choice_title;
							$pjChoiceModel->reset()->setAttributes($cdata)->insert();
						}
						$pjChoiceModel->commit();
					}
					
					$err = 'AI03';
				} else {
					$err = 'AI04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminItems&action=pjActionIndex&err=$err");
			} else {
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminItems.js');
			}
		} else {
			$this->set('status', 2);
		}
	}

	public function pjActionDeleteItem()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjItemModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjChoiceModel::factory()->where('item_id', $_GET['id'])->eraseAll();
				pjVoteModel::factory()->where('item_id', $_GET['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteItemBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjItemModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				pjChoiceModel::factory()->whereIn('item_id', $_POST['record'])->eraseAll();
				pjVoteModel::factory()->whereIn('item_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionGetItem()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjItemModel = pjItemModel::factory();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjItemModel->where('t1.item_title LIKE', "%$q%");
			}

			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjItemModel->where('t1.status', $_GET['status']);
			}
			
			$column = 'created';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjItemModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			$tbl_votes = pjVoteModel::factory()->getTable();
			$data = $pjItemModel
				->select("t1.*, 
						(SELECT COUNT(TV.id) FROM `".$tbl_votes."` AS TV WHERE TV.item_id=t1.id) AS cnt_ratings,
						(SELECT COUNT(DISTINCT TV.instance_id) FROM `".$tbl_votes."` AS TV WHERE TV.item_id=t1.id) AS cnt_instances")
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			foreach($data as $k => $v)
			{
				$v['thumb'] = PJ_INSTALL_URL . PJ_IMG_PATH . 'backend/layouts/layout.png';
				if(file_exists(PJ_INSTALL_PATH . PJ_IMG_PATH . 'backend/layouts/' . $v['layout'] . '.png'))
				{
					$v['thumb'] = PJ_INSTALL_URL . PJ_IMG_PATH . 'backend/layouts/' . $v['layout'] . '.png';
				}
				$data[$k] = $v;
			}
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminItems.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveItem()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			pjItemModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['item_update']))
			{
				pjItemModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
				
				$pjChoiceModel = pjChoiceModel::factory();
				
				if(isset($_POST['choice_title']) && count($_POST['choice_title']))
				{
					foreach($_POST['choice_title'] as $id => $choice_title)
					{
						$pjChoiceModel->reset()->where('id', $id)->limit(1)->modifyAll(array('choice_title' => $choice_title));
					}
				}
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminItems&action=pjActionUpdate&id=" . $_POST['id'] . "&tab_id=" . $_POST['tab_id'] . "&err=AI01");
			} else {
				$arr = pjItemModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminItems&action=pjActionIndex&err=AI08");
				}
				
				$choice_arr = pjChoiceModel::factory()
					->where('t1.item_id', $_GET['id'])
					->findAll()
					->getData();
				
				$o_arr = $this->models['Option']
					->where('t1.foreign_id', $this->getForeignId())
					->where('`key`', 'o_layout')
					->orderBy('t1.key ASC')
					->findAll()
					->getData();
				
				$instance_arr = pjVoteModel::factory()
                    ->select('DISTINCT t1.instance_id, t1.id')
					->where('t1.item_id', $_GET['id'])
					->where('t1.instance_id <> 0')
					->findAll()
					->getData(null, 'instance_id');
				
				$this->set('arr', $arr);
				$this->set('choice_arr', $choice_arr);
				$this->set('layout_arr', $o_arr[0]);
				$this->set('instance_arr', $instance_arr);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminItems.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionUpdateLayout()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			pjItemModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array('layout' => $_GET['layout']));

			exit;
		}
	}
	
	public function pjActionGetStatistic()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$result = $this->pjActionGetvotes($_GET['id']);
			$this->set('arr', $result['arr']);
			$this->set('vote_arr', $result['vote_arr']);
			$this->set('choice_arr', $result['choice_arr']);
			$this->set('stat_arr',$result['stat_arr'] );
		}
	}
	
	public function pjActionResetVotes()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			pjVoteModel::factory()->where('item_id', $_GET['id'])->where('instance_id', $_GET['instance_id'])->eraseAll();
			
			pjAppController::jsonResponse(array('code'=> 200));
		}
	}
	
	public function pjActionExportVotes()
	{
		$result = $this->pjActionGetvotes($_GET['id']);
		$arr = array();
		foreach($result['vote_arr'] as $k => $v)
		{
			$row = array();
			$row[__('lblInstance', true)] = !empty($v['instance_id']) ? $v['instance_id'] : __('lblNA', true);
			$row[__('lblTotal', true)] = $v['cnt_votes'];
			foreach($result['choice_arr'] as $choice)
			{
				$cnt = 0;
				if(isset($result['stat_arr'][$v['instance_id']][$choice['id']]))
				{
					$cnt = $result['stat_arr'][$v['instance_id']][$choice['id']];
				}
				$row[$choice['choice_title']] = $cnt;
			}
			$arr[$k] = $row;
		}
		$csv = new pjCSV();
		$csv
			->setHeader(true)
			->setName("Export-".time().".csv")
			->process($arr)
			->download();
		exit;
	}
	
	private function pjActionGetvotes($item_id)
	{
		$arr = pjItemModel::factory()
			->find($item_id)
			->getData();
			
		$vote_records_arr = pjVoteModel::factory()
			->select('t1.*')
			->where('t1.item_id', $item_id)
			->findAll()
			->getData();

        $vote_arr = array();
        foreach($vote_records_arr as $k=>$row){
            if(!isset($vote_arr[$row['instance_id']])){
                $vote_arr[$row['instance_id']] = $row;
                $vote_arr[$row['instance_id']]['cnt_votes'] = 1;
            } else {
                $vote_arr[$row['instance_id']]['cnt_votes']++;
            }

        }
			
		$_arr =  pjVoteModel::factory()
			->where('t1.item_id', $item_id)
			->findAll()
			->getData();
			
		$choice_arr = pjChoiceModel::factory()
			->where('t1.item_id', $item_id)
			->findAll()
			->getData();
			
		$stat_arr = array();
		foreach($_arr as $k => $v)
		{
			if(isset($stat_arr[$v['instance_id']][$v['choice_id']]))
			{
				$stat_arr[$v['instance_id']][$v['choice_id']] += 1;
			}else{
				$stat_arr[$v['instance_id']][$v['choice_id']] = 1;
			}
		}
		
		return compact('arr', 'vote_arr', 'choice_arr', 'stat_arr');
	}
}
?>
