<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{	
	public $defaultCaptcha = 'pjStarsRate_Captcha';
	
	public $defaultLocale = 'pjStarsRate_LocaleId';
	
	public $defaultLangMenu = 'pjStarsRate_Layout';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
		self::allowCORS();
	}

	public function isXHR()
	{
		return parent::isXHR() || isset($_SERVER['HTTP_ORIGIN']);
	}
	
	static protected function allowCORS()
	{
		$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '*';
		header("Access-Control-Allow-Origin: $origin");
		header("Access-Control-Allow-Credentials: true");
		header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
		header("Access-Control-Allow-Headers: Origin, X-Requested-With");
	}
	
	public function afterFilter()
	{		
		if (!isset($_GET['hide']) || (isset($_GET['hide']) && (int) $_GET['hide'] !== 1) &&
			in_array($_GET['action'], array()))
		{
			$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file, t2.title')
				->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
				->where('t2.file IS NOT NULL')
				->orderBy('t1.sort ASC')->findAll()->getData();
			
			$this->set('locale_arr', $locale_arr);
		}
	}
	
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		if (!in_array($_GET['action'], array('pjActionLoadCss')))
		{
			$this->loadSetFields();
		}
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionLocale()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['locale_id']))
			{
				$this->pjActionSetLocale($_GET['locale_id']);
				
				$this->loadSetFields(true);
				
				$day_names = __('day_names', true);
				ksort($day_names, SORT_NUMERIC);
				
				$months = __('months', true);
				ksort($months, SORT_NUMERIC);
				
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Locale have been changed.', 'opts' => array(
					'day_names' => array_values($day_names),
					'month_names' => array_values($months)
				)));
			}
		}
		exit;
	}
	private function pjActionSetLocale($locale)
	{
		if ((int) $locale > 0)
		{
			$_SESSION[$this->defaultLocale] = (int) $locale;
		}
		return $this;
	}
	
	public function pjActionGetLocale()
	{
		return isset($_SESSION[$this->defaultLocale]) && (int) $_SESSION[$this->defaultLocale] > 0 ? (int) $_SESSION[$this->defaultLocale] : FALSE;
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		$Captcha = new pjCaptcha(PJ_INSTALL_PATH . 'app/web/obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_INSTALL_PATH . 'app/web/img/button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
	}

	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
		exit;
	}
	
	public function pjActionLoadCss()
	{
		$layout = isset($_GET['layout']) ? $_GET['layout'] : $this->option_arr['o_layout'];
		if((int) $layout > 0)
		{
			$layout = 'layout' . $layout;
		}
		$arr = array(
			array('file' => "$layout.css", 'path' => PJ_CSS_PATH . 'layouts/')
		);
		header("Content-Type: text/css; charset=utf-8");
		foreach ($arr as $item)
		{
			ob_start();
			@readfile($item['path'] . $item['file']);
			$string = ob_get_contents();
			ob_end_clean();
				
			if ($string !== FALSE)
			{
				echo str_replace(
						array('images/', 'pjSrWrapper'),
						array(
								PJ_INSTALL_URL . PJ_IMG_PATH . 'frontend/',
								"pjSrWrapper_" . $layout
						),
						$string
				) . "\n";
			}
		}
		exit;
	}
	
	public function pjActionLoad()
	{
		ob_start();
		header("Content-Type: text/javascript; charset=utf-8");
		
		if(isset($_GET['id']) && (int) $_GET['id'] > 0)
		{
			$total_votes = 0;
			$avg = 0;
			$total_rates = 0;
			
			$arr = pjItemModel::factory()->find($_GET['id'])->getData();
			
			$choice_arr = pjChoiceModel::factory()->where('t1.item_id', $_GET['id'])->findAll()->getData();
			$vote_arr = pjVoteModel::factory()
				->where('t1.item_id', $_GET['id'])
				->where('t1.instance_id', $_GET['instance_id'])
				->findAll()
				->getData();

			$total_votes = count($vote_arr);
			$_choice_arr = array();
			if($total_votes > 0)
			{
				foreach($vote_arr as $v)
				{
					$total_rates += $v['rate'];
					if(isset($_choice_arr[$v['choice_id']]['votes']))
					{
						$_choice_arr[$v['choice_id']]['votes'] += 1;
					}else{
						$_choice_arr[$v['choice_id']]['votes'] = 1;
					}
				}
				$avg = round($total_rates / $total_votes);
			}
			foreach($choice_arr as $k => $v)
			{
				$v['votes'] = isset($_choice_arr[$v['id']]['votes']) ? $_choice_arr[$v['id']]['votes'] : 0;
				$choice_arr[$k] = $v;
			} 
			
			$this->set('arr', $arr);
			$this->set('choice_arr', $choice_arr);
			$this->set('avg', $avg);
			$this->set('total_votes', $total_votes);
		}
	}
	
	public function pjActionRate()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			
			$can_vote = true;
			$ip = pjUtil::getClientIp(); 
			
			$arr = pjItemModel::factory()->find($_POST['id'])->getData();
			
			$pjVoteModel = pjVoteModel::factory();
			if (!empty($arr)) 
			{
				if(!empty($arr['vote_once_every']))
				{
					$cnt_votes = $pjVoteModel
						->where('t1.item_id', $arr['id'])
						->where('t1.instance_id', $_POST['instance_id'])
						->where('t1.ip', $ip)
						->where("((t1.created + INTERVAL ".$arr['vote_once_every']." DAY) > NOW())")
						->findCount()
						->getData();
					if($cnt_votes > 0)
					{
						$can_vote = false;
					}
				}
				if($can_vote == false)
				{
					$response['code'] = '100';
					$response['message'] = __('front_you_already_voted', true);
				}else{
					$data = array();
					$data['item_id'] = $arr['id'];
					$data['choice_id'] = $_POST['choice_id'];
					$data['instance_id'] = $_POST['instance_id'];
					$data['rate'] = $_POST['rate'];
					$data['ip'] = $ip;
					$data['created'] = ':NOW()';
					
					$on_vote_show = __('on_vote_show', true);
					
					$vote_id = $pjVoteModel->reset()->setAttributes($data)->insert()->getInsertId();
					if ($vote_id !== false && (int) $vote_id > 0)
					{
						$response['code'] = '200';
						
						switch (intval($arr['on_vote_show'])) {
							case 1:
								$cnt_votes = $pjVoteModel
									->reset()
									->where('t1.item_id', $arr['id'])
									->where('t1.instance_id', $_POST['instance_id'])
									->findCount()
									->getData();
								$response['message'] = sprintf($on_vote_show[1], $cnt_votes);
								break;
							case 2:
								$cnt_votes = $pjVoteModel
									->reset()
									->where('t1.item_id', $arr['id'])
									->where('t1.instance_id', $_POST['instance_id'])
									->findCount()
									->getData();
								$response['message'] = sprintf($on_vote_show[2], $cnt_votes);
								break;
							case 3:
								$cnt_votes = $pjVoteModel
									->reset()
									->where('t1.item_id', $arr['id'])
									->where('t1.instance_id', $_POST['instance_id'])
									->findCount()
									->getData();
								$cnt_choice_votes = $pjVoteModel
									->reset()
									->where('t1.item_id', $arr['id'])
									->where('t1.instance_id', $_POST['instance_id'])
									->where('t1.choice_id', $_POST['choice_id'])
									->findCount()
									->getData();
								
								$response['message'] = sprintf($on_vote_show[3], $cnt_votes > 0 ? round($cnt_choice_votes/$cnt_votes*100, 2)."%" : '0%');
								break;
							case 4:
								$cnt_votes = $pjVoteModel
									->reset()
									->where('t1.item_id', $arr['id'])
									->where('t1.instance_id', $_POST['instance_id'])
									->findCount()
									->getData();
								$cnt_choice_votes = $pjVoteModel
									->reset()
									->where('t1.item_id', $arr['id'])
									->where('t1.instance_id', $_POST['instance_id'])
									->where('t1.choice_id', $_POST['choice_id'])
									->findCount()
									->getData();
								$response['message'] = sprintf($on_vote_show[4], $cnt_choice_votes, $cnt_votes);
								break;
							case 5:
								
								$cnt_votes = $pjVoteModel
									->reset()
									->where('t1.item_id', $arr['id'])
									->where('t1.instance_id', $_POST['instance_id'])
									->findCount()
									->getData();
								$cnt_choice_votes = $pjVoteModel
									->reset()
									->where('t1.item_id', $arr['id'])
									->where('t1.instance_id', $_POST['instance_id'])
									->where('t1.choice_id', $_POST['choice_id'])
									->findCount()
									->getData();
								$response['message'] = sprintf($on_vote_show[5], $cnt_votes > 0 ? round($cnt_choice_votes/$cnt_votes*100, 2)."%" : '0%', $cnt_votes);
								break;
							default:
								$response['message'] = $on_vote_show[6];
								break;
						}
					}
				}
			}else{
				$response['code'] = '100';
				$response['message'] = __('front_item_not_found', true);
			}
			pjAppController::jsonResponse($response);
		}
	}
}
?>