<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	?>
	<div class="bold b10"><?php __('lblTitle');?>: <?php echo pjSanitize::html($tpl['arr']['item_title']);?></div>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminItems&amp;action=pjActionUpdate" method="post" id="frmUpdateItem" class="form pj-form" autocomplete="off">
		<input type="hidden" name="item_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id'];?>" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('tabGeneral');?></a></li>
				<li><a href="#tabs-2"><?php __('tabOptions');?></a></li>
				<li><a href="#tabs-3"><?php __('tabInstall');?></a></li>
				<li><a href="#tabs-4"><?php __('tabStatistic');?></a></li>
			</ul>
			<div id="tabs-1">
				<?php pjUtil::printNotice(__('infoGeneralInfoTitle', true), __('infoGeneralInfoDesc', true)); ?>
				<p>
					<label class="title"><?php __('lblDesign');?></label>
					<span class="inline_block">
						<select name="layout" id="layout" class="pj-form-field block float_left r5 w150">
							<?php
							$layout_arr = pjUtil::sortArrayByArray( __('layout_arr', true), array('layout1', 'layout2', 'layout3', 'layout4', 'layout5', 'layout6', 'layout7', 'layout8', 'layout9', 'layout10'));
							foreach ($layout_arr as $k => $el)
							{
								if ($k == $tpl['arr']['layout'])
								{
									?><option value="<?php echo $k; ?>" selected="selected"><?php echo stripslashes($el); ?></option><?php
								} else {
									?><option value="<?php echo $k; ?>"><?php echo stripslashes($el); ?></option><?php
								}
							}
							?>
						</select>
					</span>
				</p>
				<div class="pjSrPreview">
					<link href="<?php echo PJ_INSTALL_FOLDER; ?>/index.php?controller=pjFront&action=pjActionLoadCss&layout=<?php echo $tpl['arr']['layout'];?>" type="text/css" rel="stylesheet" />
					<script type="text/javascript" src="<?php echo PJ_INSTALL_FOLDER; ?>index.php?controller=pjFront&action=pjActionLoad&id=<?php echo $tpl['arr']['id'];?>&instance_id=0&layout=<?php echo $tpl['arr']['layout'];?>"></script>
				</div>
				<p>
					<label class="title"><?php __('lblItemTitle'); ?></label>
					<span class="inline_block">
						<input type="text" name="item_title" id="item_title" value="<?php echo pjSanitize::html($tpl['arr']['item_title']);?>" class="pj-form-field w300 required" data-msg-required="<?php __('lblFieldRequired');?>"/>
					</span>
				</p>
				<?php
				foreach($tpl['choice_arr'] as $k => $v)
				{ 
					?>
					<p>
						<label class="title"><?php __('lblStar');?> #<?php echo $k+1;?></label>
						<span class="inline-block">
							<input type="text" name="choice_title[<?php echo $v['id'];?>]" value="<?php echo pjSanitize::html($v['choice_title']);?>" class="pj-form-field w300 required" data-msg-required="<?php __('lblFieldRequired');?>"/>
						</span>
					</p>
					<?php
				}
				?>
				<p>
					<label class="title"><?php __('lblStatus'); ?></label>
					<span class="inline_block">
						<select name="status" id="status" class="pj-form-field required" data-msg-required="<?php __('lblFieldRequired');?>" >
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach (__('u_statarr', true) as $k => $v)
							{
								?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : null;?>><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminItems&action=pjActionIndex';" />
				</p>
			</div>
			<div id="tabs-2">
				<?php pjUtil::printNotice(__('infoItemOptionsTitle', true), __('infoItemOptionsDesc', true)); ?>
				<p>
					<label class="title160"><?php __('lblPeopleCanVote'); ?></label>
					<span class="inline_block">
						<input type="text" name="vote_once_every" id="vote_once_every" value="<?php echo (int) $tpl['arr']['vote_once_every'];?>" class="pj-form-field w60 field-int"/>
						<label class="block float_left t5 l10"><?php __('lblDaysPutZero'); ?></label>
					</span>
				</p>
				<p>
					<label class="title160"><?php __('lblOnHoverShow'); ?></label>
					<span class="block float_left t5">
						<?php
						foreach(__('hover_arr', true) as $k => $v)
						{
							?>
							<label class="block b10">
								<input type="radio" value="<?php echo $k;?>" name="on_hover_show"<?php echo $k==$tpl['arr']['on_hover_show'] ? ' checked="checked"' : NULL;?>>
								<?php echo $v;?>
							</label>
							<?php
						} 
						?>
					</span>
				</p>
				<p>
					<label class="title160"><?php __('lblOnVoteShow'); ?></label>
					<span class="block float_left t5">
						<?php
						foreach(__('vote_arr', true) as $k => $v)
						{
							?>
							<label class="block b10">
								<input type="radio" value="<?php echo $k;?>" name="on_vote_show"<?php echo $k==$tpl['arr']['on_vote_show'] ? ' checked="checked"' : NULL;?>>
								<?php echo $v;?>
							</label>
							<?php
						} 
						?>
					</span>
				</p>
				<p>
					<label class="title160">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminItems&action=pjActionIndex';" />
				</p>
			</div><!-- tabs-2 -->
			<div id="tabs-3">
				<?php pjUtil::printNotice(NULL, __('infoInstallItemDesc', true), false); ?>
				<p>
					<label class="title"><?php __('lblInstance');?></label>
					<span class="inline_block ">
						<?php
						$instance_arr = pjUtil::sortArrayByArray(__('instance_arr', true), array('default', 'existing', 'add', 'generate'));
						foreach($instance_arr as $k => $v)
						{
							if($k == 'existing' && count($tpl['instance_arr']) == 0)
							{
								continue;
							}
							?>
							<label class="block float_left t5 r20">
								<input type="radio" value="<?php echo $k;?>"<?php echo $k=='default' ? ' checked="checked"' : NULL;?> name="instance" class="block float_left r3"><span class="block float_left"><?php echo $v;?></span>
							</label>
							<?php
						} 
						?>
					</span>
				</p>
				
				<p class="existingBox pjSrInstanceBox">
					<label class="title">&nbsp;</label>
					<span class="inline_block ">
						<select name="instance_id" id="instance_id" class="pj-form-field w150">
							<?php
							if(count($tpl['instance_arr']) > 0)
							{
								foreach ($tpl['instance_arr'] as $v)
								{
									?><option value="<?php echo $v['instance_id']; ?>"><?php echo !empty($v['instance_id']) ? $v['instance_id'] : __('lblNA', true); ?></option><?php
								}
							}
							?>
						</select>
					</span>
				</p>
				<p class="addBox pjSrInstanceBox">
					<label class="title"><?php __('lblEnterID');?></label>
					<span class="inline_block ">
						<input type="text" name="entered_id" id="entered_id" class="pj-form-field w150"/>
					</span>
				</p>
				
				<p class="generateBox pjSrInstanceBox">
					<label class="title"><?php __('lblID');?></label>
					<span class="inline_block ">
						<input type="text" name="generated_id" id="generated_id" readonly="readonly" class="pj-form-field w150"/>
					</span>
				</p>
				
				<p style="margin: 20px 0 7px; font-weight: bold"><?php __('lblInstallJs1_1', false, true); ?></p>
				<textarea class="pj-form-field textarea_install" id="pjSrCSSCode" style="overflow: auto; height:40px; width: 726px;"></textarea>
				<p style="margin: 20px 0 7px; font-weight: bold"><?php __('lblInstallJs1_2'); ?></p>
				<textarea class="pj-form-field textarea_install" id="pjSrJSCode" style="overflow: auto; height:40px; width: 726px;"></textarea>
			</div><!-- tabs-3 -->
			<div id="tabs-4">
				<?php pjUtil::printNotice(__('infoItemStatisticTitle', true), __('infoItemStatisticDesc', true)); ?>
				<div class="pj-loader-outer">
					<div class="pj-loader"></div>
					<div id="pjSrStatisticList"></div>
				</div>
			</div>
		</div>
	</form>
	
	<div style="display:none" id="pjSrCSSClone">&lt;link href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&action=pjActionLoadCss" type="text/css" rel="stylesheet" /&gt;</div>
	<div style="display:none" id="pjSrJSClone">&lt;script type="text/javascript" src="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&action=pjActionLoadJS"&gt;&lt;/script&gt;</div>
	<div id="dialogReset" title="<?php __('lblResetVotes')?>"><?php __('lblResetStatistic');?></div>
	
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{
	$tab_id = explode("-", $_GET['tab_id']);
	$tab_id = (int) $tab_id[1] - 1;
	$tab_id = $tab_id < 0 ? 0 : $tab_id;
	?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "selected", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
}
?>