var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmCreateItem = $("#frmCreateItem"),
			$frmUpdateItem = $("#frmUpdateItem"),
			$dialogReset = $('#dialogReset'),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs"),
			tOpt = {
				select: function (event, ui) {
					$(":input[name='tab_id']").val(ui.panel.id);
				},
				activate: function(event, ui)
				{
					if(ui.newPanel.selector == '#tabs-4')
					{
						$('.pj-loader').css('display', 'block');
						$.ajax({
							type: "GET",
							async: false,
							url: 'index.php?controller=pjAdminItems&action=pjActionGetStatistic&id=' + $frmUpdateItem.find("input[name='id']").val(),
							success: function (data) {
								if(typeof data =='object')
								{
									window.location.href = data.redirect;
								}else{
									$('#pjSrStatisticList').html(data);
									$('.pj-loader').css('display', 'none');
								}
							}
						});
					}
				}
			};
		if ($tabs.length > 0 && tabs) 
		{
			$tabs.tabs(tOpt);
		}
		$(".field-int").spinner({
			min: 0
		});
		if ($frmCreateItem.length > 0 && validate) {
			$frmCreateItem.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
		}
		if ($frmUpdateItem.length > 0 && validate) {
			$frmUpdateItem.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
			
			drawInstallCode();
		}
		if($dialogReset.length > 0)
		{
			$dialogReset.dialog({
				modal: true,
				resizable: false,
				draggable: false,
				autoOpen: false,
				width: 420,
				buttons: (function () {
					var buttons = {};
					buttons[srApp.locale.button.reset] = function () {
						$.ajax({
							type: "GET",
							async: false,
							url: $dialogReset.data('href'),
							success: function (data) {
								$dialogReset.dialog("close");
								$('.pj-loader').css('display', 'block');
								$.ajax({
									type: "GET",
									async: false,
									url: 'index.php?controller=pjAdminItems&action=pjActionGetStatistic&id=' + $frmUpdateItem.find("input[name='id']").val(),
									success: function (data) {
										$('#pjSrStatisticList').html(data);
										$('.pj-loader').css('display', 'none');
									}
								});
							}
						});
					};
					buttons[srApp.locale.button.cancel] = function () {
						$dialogReset.dialog("close");
					};
					return buttons;
				})()
			});
		}
		function formatRatings(str, obj)
		{
			if(str == '0')
			{
				return str;
			}else{
				return '<a href="index.php?controller=pjAdminItems&action=pjActionUpdate&id='+obj.id+'&tab_id=tabs-4">'+str+'</a>';
			}
		}
		function formatThumb(str, obj)
		{
			return '<a href="index.php?controller=pjAdminItems&action=pjActionUpdate&id='+obj.id+'"><img style="width: 100px; height: 40px;" src="'+str+'"/></a>';
		}
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminItems&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminItems&action=pjActionDeleteItem&id={:id}"}
				          ],
				columns: [{text: myLabel.preview, type: "text", sortable: false, editable: false, width: 110, align: 'center', renderer: formatThumb},
				          {text: myLabel.item_title, type: "text", sortable: true, editable: true, width: 210, editableWidth: 190},
				          {text: myLabel.total_ratings, type: "text", sortable: true, editable: false, width: 100, align: 'center', renderer: formatRatings},
				          {text: myLabel.instances, type: "text", sortable: true, editable: false, width: 80, align: 'center'},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 90, options: [
				                                                                                     {label: myLabel.active, value: "T"}, 
				                                                                                     {label: myLabel.inactive, value: "F"}
				                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminItems&action=pjActionGetItem",
				dataType: "json",
				fields: ['thumb', 'item_title', 'cnt_ratings', 'cnt_instances', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminItems&action=pjActionDeleteItemBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminItems&action=pjActionSaveItem&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminItems&action=pjActionGetItem", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminItems&action=pjActionGetItem", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminItems&action=pjActionGetItem", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("change", '#layout', function(e){
			var item_id = $("input[name='id']").val();
			$.ajax({
				type: "GET",
				async: false,
				url: 'index.php?controller=pjAdminItems&action=pjActionUpdateLayout&id='+item_id+'&layout=' + $(this).val(),
				success: function (data) {
					window.location.href = "index.php?controller=pjAdminItems&action=pjActionUpdate&id=" + item_id;
				}
			});
		}).on("change", '#instance_id', function(e){
			drawInstallCode();
		}).on("focusin", ".textarea_install", function (e) {
			$(this).select();
		}).on("change", "input:radio[name='instance']", function (e) {
			var insance = $("input:radio[name='instance']:checked").val();
			if(insance == 'generate')
			{
				var seconds = Math.floor(Date.now() / 1000);
				$("input[name='generated_id']").val(seconds);
			}
			drawInstallCode();
		}).on("keyup", "input[name='entered_id']", function (e) {
			var enter_id = $(this).val();
			if(/^[a-zA-Z0-9]+$/.test(enter_id))
			{
				drawInstallCode();
			}
		}).on("click", ".pjSrResetVotes", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				href = $this.attr('href');
			$dialogReset.data('href', href).dialog('open');
		});
		
		function drawInstallCode()
		{
			var item_id = $("input[name='id']").val();
			var layout = $("select[name='layout']").find("option:selected").val();
			var insance = $("input:radio[name='instance']:checked").val();
			var css_code = $("#pjSrCSSClone").text();
			var js_code = $("#pjSrJSClone").text();
			var instance_id = 0;
			
			layout = layout != '' ? "&layout=" + layout : "";
			item_id = "&id=" + item_id;
			
			$('.pjSrInstanceBox').hide();
			switch (insance) {
				case 'existing':
					instance_id = $("select[name='instance_id']").val();
					$("input[name='entered_id']").val('');
					$("input[name='generated_id']").val('');
					break;
				case 'add':
					if($(":input[name='entered_id']").val() != '')
					{
						instance_id = $(":input[name='entered_id']").val();
					}
					$("select[name='instance_id']").val('0');
					$("input[name='generated_id']").val('');
					break;
				case 'generate':
					var $generated_id = $("input[name='generated_id']");
					
					if($generated_id.val() != '')
					{
						instance_id = $generated_id.val();
					}
					$("select[name='instance_id']").val('0');
					$("input[name='entered_id']").val('');
					break;
			}
			instance_id = "&instance_id=" + instance_id;
			$('.'+insance+'Box').show();
			
			css_code = css_code.replace(/&action=pjActionLoadCss/g, function(match) {
	            return ["&action=pjActionLoadCss", layout].join("");
	        });
			
			js_code = js_code.replace(/&action=pjActionLoadJS/g, function(match) {
	            return ["&action=pjActionLoad", item_id, instance_id, layout].join("");
	        });
			
			$("#pjSrCSSCode").text(css_code);
			$("#pjSrJSCode").text(js_code);
		}
	});
})(jQuery_1_8_2);