BEGIN;

DROP TABLE IF EXISTS `phpreview_rating_types`;
CREATE TABLE IF NOT EXISTS `phpreview_rating_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpreview_ratings_rating_types`;
CREATE TABLE IF NOT EXISTS `phpreview_ratings_rating_types` (
 `rating_id` int(10) unsigned NOT NULL,
 `rating_type_id` int(10) unsigned NOT NULL,
 `rate` int(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`rating_id`,`rating_type_id`),
  KEY `rating_id` (`rating_id`),
  KEY `rating_type_id` (`rating_type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpreview_user_types`;
CREATE TABLE IF NOT EXISTS `phpreview_user_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpreview_ratings_user_types`;
CREATE TABLE IF NOT EXISTS `phpreview_ratings_user_types` (
 `rating_id` int(10) unsigned NOT NULL,
 `user_type_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`rating_id`,`user_type_id`),
  KEY `rating_id` (`rating_id`),
  KEY `user_type_id` (`user_type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpreview_raters`;
CREATE TABLE IF NOT EXISTS `phpreview_raters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `website` varchar(255) DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `avatar_path` varchar(255) DEFAULT NULL,
  `avatar_name` varchar(255) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `last_login` datetime default NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `id` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpreview_ratings`;
CREATE TABLE IF NOT EXISTS `phpreview_ratings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rater_id` int(10) unsigned NOT NULL,
  `thread_id` int(10) unsigned NOT NULL,
  `overall` varchar(255) DEFAULT NULL,
  `pros` text,
  `cons` text,
  `likes` int(11) NOT NULL,
  `dislikes` int(11) NOT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `id` (`id`),
  KEY `thread_id` (`thread_id`),
  KEY `rater_id` (`rater_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpreview_votes`;
CREATE TABLE `phpreview_votes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rating_id` int(11) DEFAULT NULL,
  `user_ip` varchar(20) DEFAULT NULL,
  `vote_value` enum('up','down') DEFAULT NULL,
  `voted_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpreview_threads`;
CREATE TABLE IF NOT EXISTS `phpreview_threads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `thread` varchar(255) DEFAULT NULL,
  `page_url` varchar(255) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpreview_password`;
CREATE TABLE IF NOT EXISTS `phpreview_password` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpreview_users_notifications`;
CREATE TABLE IF NOT EXISTS `phpreview_users_notifications` (
  `user_id` int(10) unsigned NOT NULL,
  `notification_id` tinyint(3) unsigned NOT NULL,
  `type` enum('email','sms') NOT NULL,
  PRIMARY KEY (`user_id`,`notification_id`,`type`),
  UNIQUE KEY `user_id` (`user_id`,`notification_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpreview_fields`;
CREATE TABLE IF NOT EXISTS `phpreview_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpreview_multi_lang`;
CREATE TABLE IF NOT EXISTS `phpreview_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned NOT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpreview_options`;
CREATE TABLE IF NOT EXISTS `phpreview_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned NOT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpreview_roles`;
CREATE TABLE IF NOT EXISTS `phpreview_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpreview_users`;
CREATE TABLE IF NOT EXISTS `phpreview_users` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) default NULL,
  `password` blob,
  `name` varchar(255) default NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime default NULL,
  `status` enum('T','F') NOT NULL default 'T',
  `is_active` enum('T','F') NOT NULL default 'F',
  `ip` varchar(15) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `phpreview_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(147, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(254, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(255, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(256, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(308, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(360, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(361, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(480, 'infoUsersTitle', 'backend', 'Infobox / List of users', 'script', NULL),
(481, 'infoUsersDesc', 'backend', 'Infobox / List of users', 'script', NULL),
(482, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(483, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(484, 'gridEmptyBody', 'backend', 'Grid / You need to select at least a single record.', 'script', NULL),
(485, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(486, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(487, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(488, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(489, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(490, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(491, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(492, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(493, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(595, 'menuThreads', 'backend', 'Menu / Threads', 'script', NULL),
(596, 'menuRatings', 'backend', 'Menu / Ratings', 'script', NULL),
(597, 'menuRaters', 'backend', 'Menu / Raters', 'script', NULL),
(598, 'menuPreviewInstall', 'backend', 'Menu / Install & Preview', 'script', NULL),
(599, 'infoThreadsTitle', 'backend', 'Infobox / List of threads', 'script', NULL),
(600, 'infoThreadsDesc', 'backend', 'Infobox / List of threads', 'script', NULL),
(601, 'btnAddThread', 'backend', 'Button / + Add thread', 'script', NULL),
(602, 'lblID', 'backend', 'Label / ID', 'script', NULL),
(603, 'lblThread', 'backend', 'Label / Thread', 'script', NULL),
(604, 'lblExportRatings', 'backend', 'Label / Export ratings', 'script', NULL),
(605, 'infoAddThreadTitle', 'backend', 'Infobox / Add thread', 'script', NULL),
(606, 'infoAddThreadDesc', 'backend', 'Infobox / Add thread', 'script', NULL),
(607, 'lblFieldRequired', 'backend', 'Label / This field is required.', 'script', NULL),
(608, 'lblPageURLInvalid', 'backend', 'Label / Page URL is invalid.', 'script', NULL),
(609, 'lblPageURL', 'backend', 'Label / Page URL', 'script', NULL),
(610, 'lblReferenceID', 'backend', 'Label / Reference ID', 'script', NULL),
(611, 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', NULL),
(612, 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL),
(613, 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', NULL),
(614, 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', NULL),
(615, 'error_titles_ARRAY_AT04', 'arrays', 'error_titles_ARRAY_AT04', 'script', NULL),
(616, 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL),
(617, 'error_titles_ARRAY_AT08', 'arrays', 'error_titles_ARRAY_AT08', 'script', NULL),
(618, 'error_bodies_ARRAY_AT08', 'arrays', 'error_bodies_ARRAY_AT08', 'script', NULL),
(619, 'infoUpdateThreadTitle', 'backend', 'Infobox / Update thread', 'script', NULL),
(620, 'infoUpdateThreadDesc', 'backend', 'Infobox / Update thread', 'script', NULL),
(621, 'tabRatingTypes', 'backend', 'Tab / Rating types', 'script', NULL),
(622, 'tabUserTypes', 'backend', 'Tab / User types', 'script', NULL),
(623, 'opt_o_review_order', 'backend', 'Options / Ratings order', 'script', NULL),
(624, 'opt_o_items_per_page', 'backend', 'Options / Items per page', 'script', NULL),
(625, 'enum_arr_ARRAY_new_on_top', 'arrays', 'enum_arr_ARRAY_new_on_top', 'script', NULL),
(626, 'enum_arr_ARRAY_new_at_bottom', 'arrays', 'enum_arr_ARRAY_new_at_bottom', 'script', NULL),
(627, 'enum_arr_ARRAY_mail', 'arrays', 'enum_arr_ARRAY_mail', 'script', NULL),
(628, 'enum_arr_ARRAY_smtp', 'arrays', 'enum_arr_ARRAY_smtp', 'script', NULL),
(629, 'infoGeneralOptionTitle', 'backend', 'Infobox / General options', 'script', NULL),
(630, 'infoGeneralOptionDesc', 'backend', 'Infobox / General options', 'script', NULL),
(631, 'infoUserTypesTitle', 'backend', 'Infobox / User types', 'script', NULL),
(632, 'infoUserTypesDesc', 'backend', 'Infobox / User types', 'script', NULL),
(633, 'btnAddUserType', 'backend', 'Button / + Add user type', 'script', NULL),
(634, 'lblUserType', 'backend', 'Label / User type', 'script', NULL),
(635, 'lblUserTypeUsed', 'backend', 'Label / User type is already used.', 'script', NULL),
(636, 'infoAddUserTypeTitle', 'backend', 'Infobox / Add user type', 'script', NULL),
(637, 'infoAddUserTypeDesc', 'backend', 'Infobox / Add user type', 'script', NULL),
(638, 'infoUpdateUserTypeTitle', 'backend', 'Infobox / Update user type', 'script', NULL),
(639, 'infoUpdateUserTypeDesc', 'backend', 'Infobox / Update user type', 'script', NULL),
(640, 'error_titles_ARRAY_ATP01', 'arrays', 'error_titles_ARRAY_ATP01', 'script', NULL),
(641, 'error_bodies_ARRAY_ATP01', 'arrays', 'error_bodies_ARRAY_ATP01', 'script', NULL),
(642, 'error_titles_ARRAY_ATP03', 'arrays', 'error_titles_ARRAY_ATP03', 'script', NULL),
(643, 'error_bodies_ARRAY_ATP03', 'arrays', 'error_bodies_ARRAY_ATP03', 'script', NULL),
(644, 'error_titles_ARRAY_ATP04', 'arrays', 'error_titles_ARRAY_ATP04', 'script', NULL),
(645, 'error_bodies_ARRAY_ATP04', 'arrays', 'error_bodies_ARRAY_ATP04', 'script', NULL),
(646, 'error_titles_ARRAY_ATP08', 'arrays', 'error_titles_ARRAY_ATP08', 'script', NULL),
(647, 'error_bodies_ARRAY_ATP08', 'arrays', 'error_bodies_ARRAY_ATP08', 'script', NULL),
(648, 'lblEmailInvalid', 'backend', 'Label / Email is invalid.', 'script', NULL),
(649, 'lblRatingType', 'backend', 'Label / Rating type', 'script', NULL),
(650, 'infoRatingTypesTitle', 'backend', 'Infobox / List of rating types', 'script', NULL),
(651, 'infoRatingTypesDesc', 'backend', 'Infobox / List of rating types', 'script', NULL),
(652, 'btnAddRatingType', 'backend', 'Button / + Add rating type', 'script', NULL),
(653, 'infoAddRatingTypeTitle', 'backend', 'Infobox / Add rating type', 'script', NULL),
(654, 'infoAddRatingTypeDesc', 'backend', 'Infobox / Add rating type', 'script', NULL),
(655, 'error_titles_ARRAY_ART01', 'arrays', 'error_titles_ARRAY_ART01', 'script', NULL),
(656, 'error_bodies_ARRAY_ART01', 'arrays', 'error_bodies_ARRAY_ART01', 'script', NULL),
(657, 'error_titles_ARRAY_ART03', 'arrays', 'error_titles_ARRAY_ART03', 'script', NULL),
(658, 'error_bodies_ARRAY_ART03', 'arrays', 'error_bodies_ARRAY_ART03', 'script', NULL),
(659, 'error_titles_ARRAY_ART04', 'arrays', 'error_titles_ARRAY_ART04', 'script', NULL),
(660, 'error_bodies_ARRAY_ART04', 'arrays', 'error_bodies_ARRAY_ART04', 'script', NULL),
(661, 'error_titles_ARRAY_ART08', 'arrays', 'error_titles_ARRAY_ART08', 'script', NULL),
(662, 'error_bodies_ARRAY_ART08', 'arrays', 'error_bodies_ARRAY_ART08', 'script', NULL),
(663, 'lblRatingTypeUsed', 'backend', 'Label / Rating type is already used.', 'script', NULL),
(664, 'infoUpdateRatingTypeTitle', 'backend', 'Infobox / Update rating type', 'script', NULL),
(665, 'infoUpdateRatingTypeDesc', 'backend', 'Infobox / Update rating type', 'script', NULL),
(666, 'error_titles_ARRAY_AM01', 'arrays', 'error_titles_ARRAY_AM01', 'script', NULL),
(667, 'error_bodies_ARRAY_AM01', 'arrays', 'error_bodies_ARRAY_AM01', 'script', NULL),
(668, 'error_titles_ARRAY_AM03', 'arrays', 'error_titles_ARRAY_AM03', 'script', NULL),
(669, 'error_bodies_ARRAY_AM03', 'arrays', 'error_bodies_ARRAY_AM03', 'script', NULL),
(670, 'error_titles_ARRAY_AM04', 'arrays', 'error_titles_ARRAY_AM04', 'script', NULL),
(671, 'error_bodies_ARRAY_AM04', 'arrays', 'error_bodies_ARRAY_AM04', 'script', NULL),
(672, 'error_titles_ARRAY_AM08', 'arrays', 'error_titles_ARRAY_AM08', 'script', NULL),
(673, 'error_bodies_ARRAY_AM08', 'arrays', 'error_bodies_ARRAY_AM08', 'script', NULL),
(674, 'infoRatersTitle', 'backend', 'Infobox / List of raters', 'script', NULL),
(675, 'infoRatersDesc', 'backend', 'Infobox / List of raters', 'script', NULL),
(676, 'btnAddRater', 'backend', 'Button / +Add rater', 'script', NULL),
(677, 'infoAddRaterTitle', 'backend', 'Infobox / Add rater', 'script', NULL),
(678, 'infoAddRaterDesc', 'backend', 'Infobox / Add rater', 'script', NULL),
(679, 'infoUpdateRaterTitle', 'backend', 'Infobox / Update rater', 'script', NULL),
(680, 'infoUpdateRaterDesc', 'backend', 'Infobox / Update rater', 'script', NULL),
(681, 'lblFirstRating', 'backend', 'Label / First rating', 'script', NULL),
(682, 'lblEmailUsed', 'backend', 'Label / Email is already used.', 'script', NULL),
(683, 'lblEmailNotification', 'backend', 'Label / Email notification', 'script', NULL),
(684, 'lblSmsNotification', 'backend', 'Label / SMS notification', 'script', NULL),
(685, 'notify_email_ARRAY_1', 'arrays', 'notify_email_ARRAY_1', 'script', NULL),
(686, 'notify_sms_ARRAY_1', 'arrays', 'notify_sms_ARRAY_1', 'script', NULL),
(688, 'tabNotifications', 'backend', 'Tab / Notifications', 'script', NULL),
(689, 'tabEmails', 'backend', 'Tab / Emails', 'script', NULL),
(690, 'tabSms', 'backend', 'Tab / Sms', 'script', NULL),
(691, 'infoNotificationsEmailTitle', 'backend', 'Infobox / Email notifications', 'script', NULL),
(692, 'infoNotificationsEmailBody', 'backend', 'Infobox / Email notifications', 'script', NULL),
(693, 'infoNotificationsSmsTitle', 'backend', 'Infobox / Sms notifications', 'script', NULL),
(694, 'infoNotificationsSmsBody', 'backend', 'Infobox / Sms notifications', 'script', NULL),
(695, 'opt_o_email_new_rating', 'backend', 'Options / New rating notification', 'script', NULL),
(696, 'opt_subject', 'backend', 'Options / Subject', 'script', NULL),
(697, 'opt_body_new_rating', 'backend', 'Options / Message', 'script', NULL),
(698, 'opt_o_sms_new_rating', 'backend', 'Options / New rating posted', 'script', NULL),
(700, 'rating_statuses_ARRAY_T', 'arrays', 'rating_statuses_ARRAY_T', 'script', NULL),
(701, 'rating_statuses_ARRAY_F', 'arrays', 'rating_statuses_ARRAY_F', 'script', NULL),
(702, 'infoRatingsTitle', 'backend', 'Infobox / Ratings', 'script', NULL),
(703, 'infoRatingsDesc', 'backend', 'Infobox / Ratings', 'script', NULL),
(704, 'lblNoAccessToFeed', 'backend', 'Label / No access to feed.', 'script', NULL),
(705, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(706, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(707, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(708, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(709, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(710, 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
(711, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(712, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(713, 'lblRating', 'backend', 'Label / Rating', 'script', NULL),
(714, 'btnAddRating', 'backend', 'Button / + Add rating', 'script', NULL),
(715, 'existing_arr_ARRAY_T', 'arrays', 'existing_arr_ARRAY_T', 'script', NULL),
(716, 'existing_arr_ARRAY_F', 'arrays', 'existing_arr_ARRAY_F', 'script', NULL),
(717, 'infoAddRatingTitle', 'backend', 'Infobox / Add rating', 'script', NULL),
(718, 'infoAddRatingDesc', 'backend', 'Infobox / Add rating', 'script', NULL),
(719, 'lblRater', 'backend', 'Label / Rater', 'script', NULL),
(720, 'lblOverall', 'backend', 'Label / Overall', 'script', NULL),
(721, 'lblPros', 'backend', 'Label / Pros', 'script', NULL),
(722, 'lblCons', 'backend', 'Label / Cons', 'script', NULL),
(724, 'lblInactive', 'backend', 'Label / Inactive', 'script', NULL),
(725, 'infoUpdateRatingTitle', 'backend', 'Infobox / Update rating', 'script', NULL),
(726, 'infoUpdateRatingDesc', 'backend', 'Infobox / Update rating', 'script', NULL),
(727, 'lblDeleteRatingTitle', 'backend', 'Label / Delete rating', 'script', NULL),
(728, 'lblDeleteRatingConfirmation', 'backend', 'Label / Delete rating confirmation', 'script', NULL),
(729, 'lblDateTime', 'backend', 'Label / Date & time', 'script', NULL),
(730, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(731, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(732, 'buttons_ARRAY_yes', 'arrays', 'buttons_ARRAY_yes', 'script', NULL),
(733, 'buttons_ARRAY_no', 'arrays', 'buttons_ARRAY_no', 'script', NULL),
(734, 'infoExportFeedTitle', 'backend', 'Infobox / Export ratings', 'script', NULL),
(735, 'infoExportFeedDesc', 'backend', 'Infobox / Export ratings', 'script', NULL),
(737, 'export_formats_ARRAY_xml', 'arrays', 'export_formats_ARRAY_xml', 'script', NULL),
(738, 'export_formats_ARRAY_csv', 'arrays', 'export_formats_ARRAY_csv', 'script', NULL),
(739, 'peirod_arr_ARRAY_1', 'arrays', 'peirod_arr_ARRAY_1', 'script', NULL),
(740, 'peirod_arr_ARRAY_2', 'arrays', 'peirod_arr_ARRAY_2', 'script', NULL),
(741, 'peirod_arr_ARRAY_3', 'arrays', 'peirod_arr_ARRAY_3', 'script', NULL),
(742, 'peirod_arr_ARRAY_4', 'arrays', 'peirod_arr_ARRAY_4', 'script', NULL),
(743, 'peirod_arr_ARRAY_5', 'arrays', 'peirod_arr_ARRAY_5', 'script', NULL),
(744, 'peirod_arr_ARRAY_6', 'arrays', 'peirod_arr_ARRAY_6', 'script', NULL),
(745, 'lblFormat', 'backend', 'Label / Format', 'script', NULL),
(746, 'lblEnterPassword', 'backend', 'Label / Enter password', 'script', NULL),
(747, 'lblPeriod', 'backend', 'Label / Period', 'script', NULL),
(748, 'btnGetFeedURL', 'backend', 'Button / Get Feed URL', 'script', NULL),
(749, 'infoRatingsFeedTitle', 'backend', 'Infobox / Ratings feed', 'script', NULL),
(750, 'infoRatingsFeedDesc', 'backend', 'Infobox / Ratings feed', 'script', NULL),
(751, 'lblAllThreads', 'backend', 'Label / All threads', 'script', NULL),
(752, 'lblThreads', 'backend', 'Label / Threads', 'script', NULL),
(753, 'lblRatings', 'backend', 'Label / Ratings', 'script', NULL),
(754, 'lblMostPopularThreads', 'backend', 'Label / Most popular threads', 'script', NULL),
(755, 'lblLatestRatings', 'backend', 'Label / Latest ratings', 'script', NULL),
(756, 'lblTopRaters', 'backend', 'Label / Top raters', 'script', NULL),
(757, 'lblDashNoRatingsFound', 'backend', 'Label / No ratings found', 'script', NULL),
(758, 'lblBy', 'backend', 'Label / by', 'script', NULL),
(759, 'lblDashNoThreadsFound', 'backend', 'Label / No threads found', 'script', NULL),
(760, 'lblLastRating', 'backend', 'Label / Last rating', 'script', NULL),
(761, 'lblDashNoRatersFound', 'backend', 'Label / No raters found', 'script', NULL),
(762, 'infoInstallTitle', 'backend', 'Infobox / Install code', 'script', NULL),
(763, 'infoInstallDesc', 'backend', 'Infobox / Install code', 'script', NULL),
(764, 'lblNoThreadsMessage', 'backend', 'Label / No threads message', 'script', NULL),
(765, 'lblSelectThread', 'backend', 'Label / Select thread', 'script', NULL),
(766, 'lblSelectTheme', 'backend', 'Label / Select theme', 'script', NULL),
(767, 'btnPreview', 'backend', 'Button / Preview', 'script', NULL),
(768, 'btnGetInstallCode', 'backend', 'Button / Get Install Code', 'script', NULL),
(769, 'lblInstallPhp1_1', 'backend', 'Label / Install step 1', 'script', NULL),
(770, 'lblInstallPhp1_2', 'backend', 'Label / Install step 2', 'script', NULL),
(771, 'lblInstallPhp1_3', 'backend', 'Label / Install step 3', 'script', NULL),
(772, 'front_rating_score', 'frontend', 'Label / Rating score', 'script', NULL),
(773, 'front_based_on', 'frontend', 'Label / Based on', 'script', NULL),
(774, 'front_ratings', 'frontend', 'Label / Ratings', 'script', NULL),
(775, 'front_rating', 'frontend', 'Label / Rating', 'script', NULL),
(776, 'front_score_breakdown', 'frontend', 'Label / Score breakdown', 'script', NULL),
(777, 'front_btn_post_a_rating', 'frontend', 'Button / Post a Rating', 'script', NULL),
(778, 'front_show_ratings_from', 'frontend', 'Label / Show ratings from', 'script', NULL),
(779, 'front_all_ratings', 'frontend', 'Label / All ratings', 'script', NULL),
(881, 'front_paging_previous', 'frontend', 'Label /prev', 'script', NULL),
(882, 'front_paging_next', 'frontend', 'Label / next', 'script', NULL),
(883, 'front_thank_you', 'frontend', 'Label / Thank you', 'script', NULL),
(884, 'front_thank_you_desc', 'frontend', 'Label / Thank you desciption', 'script', NULL),
(885, 'front_personal_details', 'frontend', 'Label / Personal details', 'script', NULL),
(886, 'front_your_email', 'frontend', 'Label / Your email', 'script', NULL),
(887, 'front_your_name', 'frontend', 'Label / Your name', 'script', NULL),
(888, 'front_overall', 'frontend', 'Label / Overall', 'script', NULL),
(889, 'front_max_characters', 'frontend', 'Label / 200 characters', 'script', NULL),
(890, 'front_pros', 'frontend', 'Label / Pros', 'script', NULL),
(891, 'front_cons', 'frontend', 'Label / Cons', 'script', NULL),
(892, 'front_i_am', 'frontend', 'Label / I am', 'script', NULL),
(893, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(894, 'front_btn_post_my_rating', 'frontend', 'Button / Post my rating', 'script', NULL),
(895, 'front_btn_cancel', 'frontend', 'Button / Cancel', 'script', NULL),
(896, 'front_sys_ARRAY_name_required', 'arrays', 'front_sys_ARRAY_name_required', 'script', NULL),
(897, 'front_sys_ARRAY_email_required', 'arrays', 'front_sys_ARRAY_email_required', 'script', NULL),
(898, 'front_sys_ARRAY_email_inv', 'arrays', 'front_sys_ARRAY_email_inv', 'script', NULL),
(899, 'front_sys_ARRAY_overall_required', 'arrays', 'front_sys_ARRAY_overall_required', 'script', NULL),
(900, 'front_sys_ARRAY_cons_required', 'arrays', 'front_sys_ARRAY_cons_required', 'script', NULL),
(901, 'front_sys_ARRAY_pros_required', 'arrays', 'front_sys_ARRAY_pros_required', 'script', NULL),
(902, 'front_sys_ARRAY_iam_required', 'arrays', 'front_sys_ARRAY_iam_required', 'script', NULL),
(903, 'front_sys_ARRAY_captcha_required', 'arrays', 'front_sys_ARRAY_captcha_required', 'script', NULL),
(904, 'front_sys_ARRAY_captcha_inc', 'arrays', 'front_sys_ARRAY_captcha_inc', 'script', NULL),
(905, 'front_err_ARRAY_PR01', 'arrays', 'front_err_ARRAY_PR01', 'script', NULL),
(906, 'front_err_ARRAY_PR02', 'arrays', 'front_err_ARRAY_PR02', 'script', NULL),
(907, 'front_err_ARRAY_PR03', 'arrays', 'front_err_ARRAY_PR03', 'script', NULL),
(908, 'front_err_ARRAY_PR04', 'arrays', 'front_err_ARRAY_PR04', 'script', NULL),
(909, 'front_err_ARRAY_PR05', 'arrays', 'front_err_ARRAY_PR05', 'script', NULL),
(910, 'front_err_ARRAY_PR06', 'arrays', 'front_err_ARRAY_PR06', 'script', NULL),
(911, 'front_err_ARRAY_PR07', 'arrays', 'front_err_ARRAY_PR07', 'script', NULL),
(912, 'front_err_ARRAY_PR08', 'arrays', 'front_err_ARRAY_PR08', 'script', NULL),
(913, 'front_err_ARRAY_PR09', 'arrays', 'front_err_ARRAY_PR09', 'script', NULL),
(914, 'front_err_ARRAY_PR10', 'arrays', 'front_err_ARRAY_PR10', 'script', NULL),
(915, 'front_err_ARRAY_PR11', 'arrays', 'front_err_ARRAY_PR11', 'script', NULL),
(916, 'front_err_ARRAY_PR12', 'arrays', 'front_err_ARRAY_PR12', 'script', NULL),
(917, 'front_err_ARRAY_PR13', 'arrays', 'front_err_ARRAY_PR13', 'script', NULL),
(918, 'front_err_ARRAY_PR14', 'arrays', 'front_err_ARRAY_PR14', 'script', NULL),
(919, 'front_err_ARRAY_PR15', 'arrays', 'front_err_ARRAY_PR15', 'script', NULL),
(920, 'front_rating_not_existing', 'frontend', 'Label / Rating does not exist.', 'script', NULL),
(921, 'front_thank_you_posted', 'frontend', 'Label / Thank you posted description', 'script', NULL),
(922, 'front_back_to_ratings', 'frontend', 'Label / Back to Ratings', 'script', NULL),
(923, 'front_no_ratings_found', 'frontend', 'Label / No ratings found.', 'script', NULL),
(924, 'opt_o_review_status', 'backend', 'Options / New reviews status', 'script', NULL),
(925, 'enum_arr_ARRAY_approved', 'arrays', 'enum_arr_ARRAY_approved', 'script', NULL),
(926, 'enum_arr_ARRAY_not_approved', 'arrays', 'enum_arr_ARRAY_not_approved', 'script', NULL),
(927, 'front_thank_you_posted2', 'frontend', 'Label / Thannk you posted description', 'script', NULL),
(928, 'lblReviewerTypes', 'backend', 'Label / Reviewer types', 'script', NULL),
(929, 'lblNoReviewersAvailable', 'backend', 'Label / No reviewers available', 'script', NULL),
(930, 'lblNoTheadsMessage', 'backend', 'Label / No threads message', 'script', NULL);

INSERT INTO `phpreview_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next ', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'List of users', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Below you can see all users who have access to the PHP Review Script admin pages. There are two types of users - Administrator and Editor. Click on "+ Add user" button to add a new user.', 'script'),
(NULL, 482, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'You can add administrator user who has full access to administration page or add an editor user who will only be able to access categories, products, offers and will not be able to modify options, other users.', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'You can make any change on the form below and click "Save" button to update user information.', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Here you can set the General options for the Menu Builder.', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'Reviews', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Ratings', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Reviewers', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'Install & Preview', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'List of reviews', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'Below you can see a list of available reviews. You can create an unlimited number of reviews or change the settings for existing reviews.', 'script'),
(NULL, 601, 'pjField', 1, 'title', '+ Add review', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'ID', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Review', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'Export ratings', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Add review', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'Enter page URL where the review will be placed. You can use the reference ID field as a short reference for the review.', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'Page URL is invalid.', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'Page where the review will be placed', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'Reference ID', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Review updated!', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'Changes made to this review have been saved.', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Review added!', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'New review has been added into the list.', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'Review not added!', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'New review could not be added. Please try again.', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'Review not found!', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'The review you are looking for is missing. Please try again.', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Update review', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Use the form below to change page URL and reference ID for this review.', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'Rating criteria', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'User types', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Ratings order', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'New on top', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'New at bottom', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'PHP mail()', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'SMTP', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'Here you can set the General options for the system.', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'User types', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'Below is a list of all user types. If you want to add a new user type, click on the button "+ Add user type". Click on the pencil icon on the corresponding entry to view or update a user type.', 'script'),
(NULL, 633, 'pjField', 1, 'title', '+ Add user type', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'User type', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'User type is already used.', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'Add user type', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'Fill in the form below and click "Save" button to add new user type.', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'Update user type', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'You can make changes to the form below and click "Save" to update user type.', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'User type updated!', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'Changes made to the user type have been saved.', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'User type added!', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'User type has been added into the list.', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'User type not added!', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'User type could not be added. Please try again.', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'User type not found!', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'User type you are looking for is missing. Please try again.', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'Rating criterion', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'List of rating criteria', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'Below is a list of predefined rating criteria. If you want to add a new rating criterion, click on the button "+ Add criterion type".', 'script'),
(NULL, 652, 'pjField', 1, 'title', '+ Add rating criterion', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Add rating criterion', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'Fill in the form below and click "Save" button to add new rating criterion.', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Rating criterion updated!', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'Changes made to the rating criterion have been saved.', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'Rating criterion added!', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'New rating criterion has been added into the list.', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Rating criterion not added!', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'Rating criterion could not be added. Please try again.', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'Rating criterion not found!', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Rating criterion you are looking for is missing. Please try again.', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'Rating criterion is already used.', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'Update rating criterion', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'Make changes on the form below and click "Save" button to update rating criterion.', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Reviewer updated!', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Changes made to the reviewer have been saved.', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'Reviewer added!', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'New reviewer has been added into the list.', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'Reviewer not added!', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'Reviewer could not be saved. Please try again.', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'Reviewer not found!', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'Reviewer you are looking for is missing. Please try again.', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'List of reviewers', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'Below is a list of all reviewers. If you want to add a new reviewer, click on the button "+Add reviewer".', 'script'),
(NULL, 676, 'pjField', 1, 'title', '+Add reviewer', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'Add reviewer', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Fill in the form below and click "Save" button to add new reviewer.', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'Update reviewer', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'You can make changes on the form below and click "Save" button to update reviewer information.', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'First rating', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'Email is already used.', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'Email notification', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'SMS notification', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'New rating posted', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'New rating posted', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'Email notifications', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'You can enable and edit email notifications which will be sent to Admins and Editors when new rating has been posted. To specify which users should be notified, just go to the Users menu and tick the respective checkbox.', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'SMS notifications', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'The system can send SMS notifications to users when a new rating has been posted. Define who should get notified from the Users menu. To activate the SMS functionality, you need to put an API key for our SMS gateway. Click on the SMS tab above.', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'New rating notification', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'Message<br/><br/>Available tokens:<br/>{RatingID}<br/>{ReviewReferenceId}<br/>{Overall}<br/>{Pros}<br/>{Cons}', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'New rating posted', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'Approved', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'Not approved', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'Ratings', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'Below you can find all ratings posted to all reviews. You can filter the ratings by their status or search for a rating. ', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'No access to feed.', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'Rating updated!', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'Changes made to the rating have been saved.', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'Rating added!', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'New rating has been added into the system.', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'Rating not added!', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'Rating could not be added. Please try again.', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'Rating not found!', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'Rating you are looking for is missing. Please try again.', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'Rating', 'script'),
(NULL, 714, 'pjField', 1, 'title', '+ Add rating', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'Select existing reviewer', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'Add new reviewer', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'Add rating', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'Fill in the form below and click "Save" button to add new rating.', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'Reviewer', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'Overall', 'script'),
(NULL, 721, 'pjField', 1, 'title', 'Pros', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'Cons', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'Update rating', 'script'),
(NULL, 726, 'pjField', 1, 'title', 'You can make changes to the form below and click "Save" button to update rating information.', 'script'),
(NULL, 727, 'pjField', 1, 'title', 'Delete rating', 'script'),
(NULL, 728, 'pjField', 1, 'title', 'Are you sure that you want to delete this rating?', 'script'),
(NULL, 729, 'pjField', 1, 'title', 'Date & time', 'script'),
(NULL, 730, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 731, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 732, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 733, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'Export ratings', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'Create a CSV or XML feed for the ratings posted. You can password protect the feed so that others cannot access it. Define the period to specify which ratings to be included in the feed.', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'XML', 'script'),
(NULL, 738, 'pjField', 1, 'title', 'CSV', 'script'),
(NULL, 739, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 740, 'pjField', 1, 'title', 'Yesterday', 'script'),
(NULL, 741, 'pjField', 1, 'title', 'This week', 'script'),
(NULL, 742, 'pjField', 1, 'title', 'Last week', 'script'),
(NULL, 743, 'pjField', 1, 'title', 'This month', 'script'),
(NULL, 744, 'pjField', 1, 'title', 'Last month', 'script'),
(NULL, 745, 'pjField', 1, 'title', 'Format', 'script'),
(NULL, 746, 'pjField', 1, 'title', 'Enter password', 'script'),
(NULL, 747, 'pjField', 1, 'title', 'Period', 'script'),
(NULL, 748, 'pjField', 1, 'title', 'Get Feed URL', 'script'),
(NULL, 749, 'pjField', 1, 'title', 'Ratings Feed URL', 'script'),
(NULL, 750, 'pjField', 1, 'title', 'Use the URL below to have access to all ratings. Please, note that if you change the password the URL will change too as password is used in the URL itself so no one else can open it.', 'script'),
(NULL, 751, 'pjField', 1, 'title', 'All reviews', 'script'),
(NULL, 752, 'pjField', 1, 'title', 'Reviews', 'script'),
(NULL, 753, 'pjField', 1, 'title', 'Ratings', 'script'),
(NULL, 754, 'pjField', 1, 'title', 'Most popular reviews', 'script'),
(NULL, 755, 'pjField', 1, 'title', 'Latest ratings', 'script'),
(NULL, 756, 'pjField', 1, 'title', 'Top reviewers', 'script'),
(NULL, 757, 'pjField', 1, 'title', 'No ratings found', 'script'),
(NULL, 758, 'pjField', 1, 'title', 'by', 'script'),
(NULL, 759, 'pjField', 1, 'title', 'No reviews found', 'script'),
(NULL, 760, 'pjField', 1, 'title', 'Last rating', 'script'),
(NULL, 761, 'pjField', 1, 'title', 'No reviewers found', 'script'),
(NULL, 762, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 763, 'pjField', 1, 'title', 'Select the review and the theme you want to use. You can preview the front-end and get the installation code. You need to put the PHP code for the review on a .php page.', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'No reviews available. Please click {STAG}here{ETAG} to add one.', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'Select review', 'script'),
(NULL, 766, 'pjField', 1, 'title', 'Select theme', 'script'),
(NULL, 767, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 768, 'pjField', 1, 'title', 'Get Install Code', 'script'),
(NULL, 769, 'pjField', 1, 'title', 'Step 1. Copy and paste following code at very top of your page, before any other code.', 'script'),
(NULL, 770, 'pjField', 1, 'title', 'Step 2. Copy and paste following code inside your html code, where the PHP Review form will be displayed.', 'script'),
(NULL, 771, 'pjField', 1, 'title', 'Step 3. Copy and paste following code at very bottom of your page, after all the code.', 'script'),
(NULL, 772, 'pjField', 1, 'title', 'Rating score', 'script'),
(NULL, 773, 'pjField', 1, 'title', 'Based on', 'script'),
(NULL, 774, 'pjField', 1, 'title', 'Ratings', 'script'),
(NULL, 775, 'pjField', 1, 'title', 'Rating', 'script'),
(NULL, 776, 'pjField', 1, 'title', 'Score breakdown', 'script'),
(NULL, 777, 'pjField', 1, 'title', 'Post a Rating', 'script'),
(NULL, 778, 'pjField', 1, 'title', 'Show ratings for', 'script'),
(NULL, 779, 'pjField', 1, 'title', 'All ratings', 'script'),
(NULL, 881, 'pjField', 1, 'title', 'prev', 'script'),
(NULL, 882, 'pjField', 1, 'title', 'next', 'script'),
(NULL, 883, 'pjField', 1, 'title', 'Thank you!', 'script'),
(NULL, 884, 'pjField', 1, 'title', '<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.</p><p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae </p>', 'script'),
(NULL, 885, 'pjField', 1, 'title', 'Personal details', 'script'),
(NULL, 886, 'pjField', 1, 'title', 'Your email', 'script'),
(NULL, 887, 'pjField', 1, 'title', 'Your name', 'script'),
(NULL, 888, 'pjField', 1, 'title', 'Overall', 'script'),
(NULL, 889, 'pjField', 1, 'title', '200 characters', 'script'),
(NULL, 890, 'pjField', 1, 'title', 'Pros', 'script'),
(NULL, 891, 'pjField', 1, 'title', 'Cons', 'script'),
(NULL, 892, 'pjField', 1, 'title', 'User type', 'script'),
(NULL, 893, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 894, 'pjField', 1, 'title', 'Post my rating', 'script'),
(NULL, 895, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 896, 'pjField', 1, 'title', 'Your name is required.', 'script'),
(NULL, 897, 'pjField', 1, 'title', 'Your email is required.', 'script'),
(NULL, 898, 'pjField', 1, 'title', 'Your email is invalid.', 'script'),
(NULL, 899, 'pjField', 1, 'title', 'Overall is required.', 'script'),
(NULL, 900, 'pjField', 1, 'title', 'Cons is required.', 'script'),
(NULL, 901, 'pjField', 1, 'title', 'Pros is required.', 'script'),
(NULL, 902, 'pjField', 1, 'title', 'You need to select at least one.', 'script'),
(NULL, 903, 'pjField', 1, 'title', 'Captcha is required.', 'script'),
(NULL, 904, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 905, 'pjField', 1, 'title', 'Your name is missing.', 'script'),
(NULL, 906, 'pjField', 1, 'title', 'Your name cannot be empty.', 'script'),
(NULL, 907, 'pjField', 1, 'title', 'Your email is missing.', 'script'),
(NULL, 908, 'pjField', 1, 'title', 'Your email cannot be empty.', 'script'),
(NULL, 909, 'pjField', 1, 'title', 'Your email is not valid.', 'script'),
(NULL, 910, 'pjField', 1, 'title', 'Overall is missing.', 'script'),
(NULL, 911, 'pjField', 1, 'title', 'Overall cannot be empty.', 'script'),
(NULL, 912, 'pjField', 1, 'title', 'Pros is missing.', 'script'),
(NULL, 913, 'pjField', 1, 'title', 'Pros cannot be empty.', 'script'),
(NULL, 914, 'pjField', 1, 'title', 'Cons is missing.', 'script'),
(NULL, 915, 'pjField', 1, 'title', 'Cons cannot be empty.', 'script'),
(NULL, 916, 'pjField', 1, 'title', 'You need to select at least one options in I am field.', 'script'),
(NULL, 917, 'pjField', 1, 'title', 'Captcha is missing.', 'script'),
(NULL, 918, 'pjField', 1, 'title', 'Captcha cannot be empty.', 'script'),
(NULL, 919, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 920, 'pjField', 1, 'title', 'Rating does not exist.', 'script'),
(NULL, 921, 'pjField', 1, 'title', '<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. </p>', 'script'),
(NULL, 922, 'pjField', 1, 'title', 'Back to Ratings', 'script'),
(NULL, 923, 'pjField', 1, 'title', 'No ratings found.', 'script'),
(NULL, 924, 'pjField', 1, 'title', 'New reviews status', 'script'),
(NULL, 925, 'pjField', 1, 'title', 'Approved', 'script'),
(NULL, 926, 'pjField', 1, 'title', 'Not approved', 'script'),
(NULL, 927, 'pjField', 1, 'title', 'We will check your review and will approved it.', 'script'),
(NULL, 928, 'pjField', 1, 'title', 'Reviewer types', 'script'),
(NULL, 929, 'pjField', 1, 'title', 'No reviewers available. Please click {STAG}here{ETAG} to add one.', 'script'),
(NULL, 930, 'pjField', 1, 'title', 'No threads available. Please click {STAG}here{ETAG} to add one.', 'script');

INSERT INTO `phpreview_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 4, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 5, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 6, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 7, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 8, 1, NULL),
(1, 'o_review_status', 1, 'approved|not_approved::approved', 'Approved|No approved', 'enum', 9, 1, NULL),
(1, 'o_review_order', 1, 'new_on_top|new_at_bottom::new_on_top', 'New on top|New at bottom', 'enum', 10, 1, NULL),
(1, 'o_items_per_page', 1, '5', NULL, 'int', 11, 1, NULL),
(1, 'o_allow_review_rating', 2, 'Yes|No::Yes', NULL, 'enum', 1, 1, NULL),
(1, 'o_banned_words', 2, NULL, NULL, 'text', 2, 1, NULL),
(1, 'o_email_new_rating_subject', 3, 'New rating has been posted', NULL, 'string', 5, 1, NULL),
(1, 'o_email_new_rating', 3, 'New rating has been posted.\r\n\r\nRating ID: {RatingID}\r\nThread: {ThreadReferenceId}\r\nOverall: {Overall}\r\nPros: {Pros}\r\nCons: {Cons}', NULL, 'text', 6, 1, NULL),
(1, 'o_sms_new_rating', 4, 'New rating has been posted.', NULL, 'text', 2, 1, NULL),
(1, 'o_theme', 99, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10|theme11::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10|Theme 11', 'enum', 6, 0, NULL),
(1, 'o_multi_lang', 99, '1|0::0', 'Yes|No', 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `phpreview_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

COMMIT;