<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminRatings extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['rating_create']))
			{
				$data = array();
				$data['ip'] = pjUtil::getClientIp();
				
				$pjRaterModel = pjRaterModel::factory();
				
				if($_POST['is_existing'] == 'F'){
					$email = $_POST['email'];
					$rater_arr = $pjRaterModel->where("t1.email='$email'")->findAll()->getData();
					if(count($rater_arr) > 0)
					{
						$data['rater_id'] = $rater_arr[0]['id'];
					}else{
						$rater_data = array();
						$rater_data['name'] = $_POST['name'];
						$rater_data['email'] = $_POST['email'];
						$rater_data['password'] = pjToolkit::getRandomPassword();
						$data['rater_id'] = $pjRaterModel->reset()->setAttributes($rater_data)->insert()->getInsertId();
					}
					unset($_POST['rater_id']);
				}
								
				$id = pjRatingModel::factory(array_merge($_POST, $data))->insert()->getInsertId();
				
				if ($id !== false && (int) $id > 0)
				{
					$pjRatingRatingTypeModel = pjRatingRatingTypeModel::factory();
					if (isset($_POST['rating']) && is_array($_POST['rating']) && count($_POST['rating']) > 0)
					{
						$pjRatingRatingTypeModel->begin();
						foreach ($_POST['rating'] as $rating_type_id => $rate)
						{
							$pjRatingRatingTypeModel
								->reset()
								->set('rating_id', $id)
								->set('rating_type_id', $rating_type_id)
								->set('rate', $rate)
								->insert();
						}
						$pjRatingRatingTypeModel->commit();
					}
					$pjRatingUserTypeModel = pjRatingUserTypeModel::factory();
					if (isset($_POST['user_type']) && is_array($_POST['user_type']) && count($_POST['user_type']) > 0)
					{
						$pjRatingUserTypeModel->begin();
						foreach ($_POST['user_type'] as $user_type_id => $whatever)
						{
							$pjRatingUserTypeModel
								->reset()
								->set('rating_id', $id)
								->set('user_type_id', $user_type_id)
								->insert();
						}
						$pjRatingUserTypeModel->commit();
					}
					$err = 'AC03';
				} else {
					$err = 'AC04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminRatings&action=pjActionIndex&err=$err");
			} else {

				$rater_arr = pjRaterModel::factory()->orderBy('t1.name ASC')->findAll()->getData();
				$thread_arr = pjThreadModel::factory()->where("t1.status = 'T'")->orderBy('t1.thread ASC')->findAll()->getData();
				
				$user_type_arr = pjUserTypeModel::factory()->where('t1.status', 'T')->orderBy('title ASC')->findAll()->getData();
				$rating_type_arr = pjRatingTypeModel::factory()->where('t1.status', 'T')->orderBy('title ASC')->findAll()->getData();
				
				$this->set('rater_arr', $rater_arr);
				$this->set('thread_arr', $thread_arr);
				$this->set('user_type_arr', $user_type_arr);
				$this->set('rating_type_arr', $rating_type_arr);
				
				$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'harvest/chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'harvest/chosen/');
								
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminRatings.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteRating()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjRatingModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjVoteModel::factory()->where('rating_id', $_GET['id'])->eraseAll();
				pjRatingRatingTypeModel::factory()->where('rating_id', $_GET['id'])->eraseAll();
				pjRatingUserTypeModel::factory()->where('rating_id', $_GET['id'])->eraseAll();
				
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteRatingBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjRatingModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				
				pjVoteModel::factory()->whereIn('rating_id', $_POST['id'])->eraseAll();
				pjRatingRatingTypeModel::factory()->whereIn('rating_id', $_POST['record'])->eraseAll();
				pjRatingUserTypeModel::factory()->whereIn('rating_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionExportRating()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjRatingModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Ratings-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionGetRating()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjRatingModel = pjRatingModel::factory();
			$tb_rating_user_type = pjRatingUserTypeModel::factory()->getTable();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjRatingModel->where("(t1.overall LIKE '%$q%' OR t1.pros LIKE '%$q%' OR t1.cons LIKE '%$q%')");
			}

			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjRatingModel->where('t1.status', $_GET['status']);
			}
			if (isset($_GET['rater_id']))
			{
				$pjRatingModel->where('t1.rater_id', $_GET['rater_id']);
			}
			if (isset($_GET['thread_id']))
			{
				$pjRatingModel->where('t1.thread_id', $_GET['thread_id']);
			}
			if (isset($_GET['user_type_id']))
			{
				$pjRatingModel->where("t1.id IN (SELECT TRUT.rating_id FROM `".$tb_rating_user_type."` AS TRUT WHERE TRUT.user_type_id='".$_GET['user_type_id']."')");
			}	
			$column = 'id';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}
			$total = $pjRatingModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			$data = array();
			$arr = $pjRatingModel
				->select("t1.*, t2.name AS rater, t2.status AS rater_status, t3.thread,
						(IF(CHAR_LENGTH(t1.overall) >= 80, CONCAT(SUBSTRING(t1.overall, 1, 80), ' ...'), t1.overall)) as rating")
				->join('pjRater', 't2.id=t1.rater_id', 'left')
				->join('pjThread', 't3.id=t1.thread_id', 'left')
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()->getData();

			foreach($arr as $k => $v)
			{
				$v['rating'] = pjSanitize::clean($v['rating']);
				$data[$k] = $v;
			}	
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminRatings.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveRating()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjRatingModel = pjRatingModel::factory();
	
			$pjRatingModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['rating_update']))
			{
				$data = array();
				$data['ip'] = pjUtil::getClientIp();
								
				pjRatingModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				
				$pjRatingRatingTypeModel = pjRatingRatingTypeModel::factory();
				$pjRatingRatingTypeModel->where('rating_id', $_POST['id'])->eraseAll();
				if (isset($_POST['rating']) && is_array($_POST['rating']) && count($_POST['rating']) > 0)
				{
					$pjRatingRatingTypeModel->begin();
					foreach ($_POST['rating'] as $rating_type_id => $rate)
					{
						$pjRatingRatingTypeModel
							->reset()
							->set('rating_id', $_POST['id'])
							->set('rating_type_id', $rating_type_id)
							->set('rate', $rate)
							->insert();
					}
					$pjRatingRatingTypeModel->commit();
				}
				$pjRatingUserTypeModel = pjRatingUserTypeModel::factory();
				$pjRatingUserTypeModel->where('rating_id', $_POST['id'])->eraseAll();
				if (isset($_POST['user_type']) && is_array($_POST['user_type']) && count($_POST['user_type']) > 0)
				{
					$pjRatingUserTypeModel->begin();
					foreach ($_POST['user_type'] as $user_type_id => $whatever)
					{
						$pjRatingUserTypeModel
							->reset()
							->set('rating_id', $_POST['id'])
							->set('user_type_id', $user_type_id)
							->insert();
					}
					$pjRatingUserTypeModel->commit();
				}
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminRatings&action=pjActionIndex&err=AC01");
				
			} else {
				
				$pjRatingModel = pjRatingModel::factory();
				
				$arr = $pjRatingModel
					->select('t1.*, t2.page_url')
					->join('pjThread', 't1.thread_id = t2.id', 'left')
					->find($_GET['id'])
					->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminRatings&action=pjActionIndex&err=AC08");
				}
								
				$rater_arr = pjRaterModel::factory()->orderBy('t1.name ASC')->findAll()->getData();
				$thread_arr = pjThreadModel::factory()->where("t1.status = 'T'")->orderBy('t1.thread ASC')->findAll()->getData();
				
				$user_type_arr = pjUserTypeModel::factory()->where('t1.status', 'T')->orderBy('title ASC')->findAll()->getData();
				$rating_type_arr = pjRatingTypeModel::factory()->where('t1.status', 'T')->orderBy('title ASC')->findAll()->getData();
				
				$arr['rating'] = pjRatingRatingTypeModel::factory()->where('t1.rating_id', $_GET['id'])->findAll()->getDataPair('rating_type_id', 'rate');
				$arr['user_type'] = pjRatingUserTypeModel::factory()->where('t1.rating_id', $_GET['id'])->findAll()->getDataPair('user_type_id', 'user_type_id');
				
				$this->set('arr', $arr);
				$this->set('thread_arr', $thread_arr);
				$this->set('rater_arr', $rater_arr);
				$this->set('user_type_arr', $user_type_arr);
				$this->set('rating_type_arr', $rating_type_arr);
								
				$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'harvest/chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'harvest/chosen/');
								
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminRatings.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionFeed()
	{
		$this->checkLogin();
	
		if ($this->isAdmin()|| $this->isEditor())
		{
			if(isset($_POST['rating_feed']))
			{
				$pjPasswordModel = pjPasswordModel::factory();
				$password = md5($_POST['password'].PJ_SALT);
				$arr = $pjPasswordModel
					->where("t1.password", $password)
					->limit(1)
					->findAll()
					->getData();
				if (count($arr) != 1)
				{
					$pjPasswordModel->setAttributes(array('password' => $password))->insert();
				}
				$this->set('password', $password);
			}
	
			$thread_arr = pjThreadModel::factory()
				->where('t1.status', 'T')
				->orderBy("`thread` ASC")
				->findAll()
				->getData();
			
			$this->set('thread_arr', $thread_arr);
			
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('pjAdminRatings.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionExportFeed()
	{
		$this->setLayout('pjActionEmpty');
		$access = true;
		if(isset($_GET['p']))
		{
			$pjPasswordModel = pjPasswordModel::factory();
			$arr = $pjPasswordModel
				->where('t1.password', $_GET['p'])
				->limit(1)
				->findAll()
				->getData();
			if (count($arr) != 1)
			{
				$access = false;
			}
		}else{
			$access = false;
		}
		if($access == true)
		{
			$arr = $this->pjGetFeedData($_GET);
			
			if(!empty($arr))
			{
				if($_GET['format'] == 'xml')
				{
					$xml = new pjXML();
					echo $xml
						->setEncoding('UTF-8')
						->process($arr)
						->getData();
	
				}
				if($_GET['format'] == 'csv')
				{
					$csv = new pjCSV();
					echo $csv
						->setHeader(true)
						->process($arr)
						->getData();
	
				}
			}
		}else{
			__('lblNoAccessToFeed');
		}
		exit;
	}
	
	public function pjGetFeedData($get)
	{
		$arr = array();
		$status = true;
		$period = '';
		if(isset($get['period']))
		{
			if(!ctype_digit($get['period']))
			{
				$status = false;
			}else{
				$period = $get['period'];
			}
		}else{
			$status = false;
		}
		
		if($status == true && $period != '')
		{
			$pjRatingModel = pjRatingModel::factory();
				
			$column = 'created';
			$direction = 'DESC';
			$where_str = pjUtil::getWhereClause($period, 1);
			if($where_str != '')
			{
				$pjRatingModel->where($where_str);
			}
			if(isset($get['thread_id']))
			{
				$pjRatingModel->where('t1.thread_id', $get['thread_id']);
			}
			$arr= $pjRatingModel
				->select('t1.*,t2.name, t3.thread')
				->join('pjRater', "t1.rater_id=t2.id", 'left')
				->join('pjThread', "t1.thread_id=t3.id", 'left')
				->orderBy("$column $direction")
				->findAll()
				->getData();
		}
		return $arr;
	}
}
?>