<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{
	public $defaultCaptcha = 'StivaSoftCaptcha';
	
	public $defaultLocale = 'front_locale_id';
	
	public $defaultRater = 'front_rater';
	
	public $defaultThread = 'front_thread_id';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
	}

	public function afterFilter()
	{
		
		$theme = $this->getTheme();
		if($theme == false)
		{
			$theme = $this->option_arr['o_theme'];
		}
		$this->appendCss('pj.bootstrap.min.css', PJ_FRAMEWORK_LIBS_PATH . 'pj/css/');
		$this->appendCss('css?family=Open+Sans:400,600,700', "https://fonts.googleapis.com/", true);
		$this->appendCss('font-awesome.min.css', PJ_LIBS_PATH . 'pjQ/css/');
		$this->appendCss('front.css', PJ_CSS_PATH);
		$this->appendCss($theme.'.css', PJ_CSS_PATH . 'themes/');
	}
	
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		if(isset($_GET['thread_id']))
		{
			$thread_id = pjObject::escapeString($_GET['thread_id']);
			if((int) $thread_id > 0)
			{
				$this->setThread(pjObject::escapeString($_GET['thread_id']));
			}
		}
		if(isset($_GET['theme']))
		{
			$theme = pjObject::escapeString($_GET['theme']);
			if(!empty($theme))
			{
				$this->setTheme($theme);
			}
		}else{
			if(!isset($_SESSION[$this->defaultTheme]))
			{
				$this->setTheme($this->option_arr['o_theme']);
			}
		}
		
		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		$this->loadSetFields();
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		
		$Captcha = new pjCaptcha(PJ_INSTALL_PATH . 'app/web/obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_INSTALL_PATH . 'app/web/img/button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
	}


	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
				
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
	}
	
	public function pjActionSetLocale()
	{
		$this->setLocaleId(@$_GET['locale']);
		pjUtil::redirect($_SERVER['HTTP_REFERER']);
	}
	

	protected function getReceivedEmail($notification_id)
	{
		$arr = array();
		$recipients = pjUserNotificationModel::factory()
			->select('t1.type, t2.email, t2.phone')
			->join('pjUser', "t2.id=t1.user_id", 'inner')
			->where('t1.notification_id', $notification_id)
			->where('`type`', 'email')
			->findAll()
			->getData();
		foreach ($recipients as $recipient)
		{
			if (empty($recipient['email']))
			{
				continue;
			}
			$arr[] = $recipient['email'];
		}
		return $arr;
	}
	protected function getReceivedPhone($notification_id)
	{
		$arr = array();
		$recipients = pjUserNotificationModel::factory()
			->select('t1.type, t2.email, t2.phone')
			->join('pjUser', "t2.id=t1.user_id", 'inner')
			->where('t1.notification_id', $notification_id)
			->where('`type`', 'sms')
			->findAll()
			->getData();
		foreach ($recipients as $recipient)
		{
			if (empty($recipient['phone']))
			{
				continue;
			}
			$arr[] = $recipient['phone'];
		}
		return $arr;
	}
	
	protected function sendRatingEmail($rating_id)
	{
		$receiver_arr = $this->getReceivedEmail(1);
		$receiver_arr = array_unique($receiver_arr);
	
		$pjRatingModel = pjRatingModel::factory();
	
		$arr = $pjRatingModel->select("t1.*, t2.thread")
			->join('pjThread', 't2.id=t1.thread_id', 'left')
			->find($rating_id)->getData();
	
		$message = str_replace(array('{RatingID}', '{ThreadReferenceId}', '{Overall}', '{Pros}', '{Cons}'), array(@$arr['id'], @$arr['thread'], @$arr['overall'], @$arr['pros'], @$arr['cons']), $this->option_arr['o_email_new_rating']);
		$subject = $this->option_arr['o_email_new_rating_subject'];
	
		$pjEmail = new pjEmail();
		if ($this->option_arr['o_send_email'] == 'smtp')
		{
			$pjEmail
				->setTransport('smtp')
				->setSmtpHost($this->option_arr['o_smtp_host'])
				->setSmtpPort($this->option_arr['o_smtp_port'])
				->setSmtpUser($this->option_arr['o_smtp_user'])
				->setSmtpPass($this->option_arr['o_smtp_pass'])
			;
		}
		$message = pjUtil::textToHtml($message);
		$pjEmail
			->setContentType('text/html')
			->setFrom($this->getFromEmail());
		foreach($receiver_arr as $v)
		{
			$pjEmail
				->setTo($v)
				->setSubject($subject)
				->send($message);
		}
	}
	
	protected function sendRatingSMS($notification_id){
	
		$text = '';
		$text = $this->option_arr['o_sms_new_rating'];
	
		$recipients = $this->getReceivedPhone(1);
	
		$smsPlugin = (pjObject::getPlugin('pjSms') !== NULL);
		foreach ($recipients as $recipient)
		{
			if (empty($recipient['phone']) || !$smsPlugin)
			{
				continue;
			}
			$this->requestAction(array(
					'controller' => 'pjSms',
					'action' => 'pjActionSend',
					'params' => array(
							'number' => $recipient['phone'],
							'text' => $text,
							'key' => md5($this->option_arr['private_key'] . PJ_SALT)
					)
			), array('return'));
		}
	}
}
?>