<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}

class pjLoad extends pjFront
{
	private $isoDatePattern = '/\d{4}-\d{2}-\d{2}/';
	
	public function pjActionIndex()
	{	
		$thread_id = $this->getThread();
		$tb_rating = pjRatingModel::factory()->getTable();
		$tb_rating_user_type = pjRatingUserTypeModel::factory()->getTable();
		
		$fitler_str = '';
		$where_str = '';
		if(isset($_GET['user_type_id']) && (int) $_GET['user_type_id'] > 0)
		{
			$fitler_str = "AND TR.id IN(SELECT TRUT.rating_id FROM `".$tb_rating_user_type."` AS TRUT WHERE TRUT.user_type_id='".$_GET['user_type_id']."')";
			$where_str = "t1.id IN(SELECT TRUT.rating_id FROM `".$tb_rating_user_type."` AS TRUT WHERE TRUT.user_type_id='".$_GET['user_type_id']."')";
		}
		
		$thread_arr = pjThreadModel::factory()		
			->select("t1.*,
					  (SELECT COUNT(*) FROM `".$tb_rating."` AS TR WHERE TR.status='T' AND TR.thread_id=t1.id $fitler_str) AS cnt_ratings")
			->find($thread_id)
			->getData();
		if(empty($thread_arr))
		{
			if($_GET['action'] != 'pjActionNoThread')
			{
				pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionNoThread&err=0' . (isset($_POST['iframe']) ? '&iframe' : NULL));
			}
		}else{
			if($thread_arr['status'] == 'F' && $_GET['action'] != 'pjActionNoThread')
			{
				pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionNoThread&err=1' . (isset($_POST['iframe']) ? '&iframe' : NULL));
			}
		}
		
		$total_ratings = pjRatingModel::factory()
			->where('t1.status', 'T')
			->where('t1.thread_id', $thread_id)
			->findCount()
			->getData();
		
		$rating_type_arr = pjRatingTypeModel::factory()
			->select("t1.*,
					  (SELECT AVG(TRRT.rate) FROM `".pjRatingRatingTypeModel::factory()->getTable()."` AS `TRRT` WHERE `TRRT`.rating_type_id=t1.id AND `TRRT`.rating_id IN (SELECT TR.id FROM `".$tb_rating."` AS `TR` WHERE TR.status='T' AND TR.thread_id = '$thread_id' $fitler_str) ) AS avg_rate")
			->where('t1.status', 'T')
			->orderBy("title ASC")
			->findAll()
			->getData();
		
		$score = 0;
		$sum = 0;
		if(!empty($rating_type_arr))
		{
			foreach($rating_type_arr as $k => $v)
			{
				$avg = $v['avg_rate'];
				$percentage = ($v['avg_rate'] * 100) / 5;
				$percentage_format = number_format($percentage / 10, 1);
				
				$sum += $percentage / 10;
				$v['percentage'] = $percentage;
				$v['percentage_format'] = $percentage_format;
				$rating_type_arr[$k] = $v;
			}
			$score = $sum / count($rating_type_arr);
		}
		$thread_arr['score'] = number_format($score, 1);
		
		$user_type_arr = pjUserTypeModel::factory()
			->select("t1.*")
		  	->where('t1.status', 'T')
		  	->orderBy("title ASC")
		  	->findAll()
		  	->getData();
		
		$pjRatingModel = pjRatingModel::factory();
		$pjRatingModel->where("t1.status", 'T');
		$pjRatingModel->where("t1.rater_id IN(SELECT TR.id FROM `".pjRaterModel::factory()->getTable()."` AS TR WHERE TR.status='T')");
		if(isset($_GET['user_type_id']) && (int) $_GET['user_type_id'] > 0)
		{
			$pjRatingModel->where($where_str);
		}
		if ($this->getThread())
		{
			$pjRatingModel->where('t1.thread_id', $thread_id);
		}
		$column = 'created';
		if($this->option_arr['o_review_order'] == 'new_on_top')
		{
			$direction = 'DESC';
		}else{
			$direction = 'ASC';
		}
		$total = $pjRatingModel->findCount()->getData();
		$rowCount = $this->option_arr['o_items_per_page'];
		$pages = ceil($total / $rowCount);
		$page = isset($_GET['pjPage']) && (int) $_GET['pjPage'] > 0 ? intval($_GET['pjPage']) : 1;
		$offset = ((int) $page - 1) * $rowCount;
		if ($page > $pages)
		{
			$page = $pages;
		}
		$arr = $pjRatingModel
			->select("t1.*, t2.name AS rater, t3.thread,
					  (SELECT (AVG(rate) * 10) / 5 FROM `".pjRatingRatingTypeModel::factory()->getTable()."` AS `TRRT` WHERE TRRT.rating_id=t1.id) AS avg,
					  (SELECT GROUP_CONCAT(TUT.title SEPARATOR '~:~') FROM `".pjUserTypeModel::factory()->getTable()."` AS `TUT` WHERE `TUT`.id IN(SELECT `TRUT`.user_type_id FROM `".pjRatingUserTypeModel::factory()->getTable()."` AS `TRUT` WHERE `TRUT`.rating_id=t1.id) ) AS user_types")
			->join('pjRater', 't2.id=t1.rater_id', 'left')
			->join('pjThread', 't3.id=t1.thread_id', 'left')
			->orderBy("$column $direction")
			->limit($rowCount, $offset)
			->findAll()
			->toArray("user_types", "~:~")
			->getData();
		
		$this->set('arr', $arr);
		$this->set('paginator', array('pages' => $pages, 'total' => $total));
		
		$this->set('thread_arr', $thread_arr);
		$this->set('total_ratings', $total_ratings);
		$this->set('rating_type_arr', $rating_type_arr);
		$this->set('user_type_arr', $user_type_arr);
	}
	
	public function pjActionPost()
	{
		if(isset($_POST['post_rating']))
		{
			$err = '';
			if (!isset($_POST['name']))
			{
				$err = 'PR01';
			}
			if (isset($_POST['name']) && !pjValidation::pjActionNotEmpty($_POST['name']))
			{
				$err = 'PR02';
			}
			if (!isset($_POST['email']))
			{
				$err = 'PR03';
			}
			if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
			{
				$err = 'PR04';
			}
			if (isset($_POST['email']) && pjValidation::pjActionNotEmpty($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
			{
				$err = 'PR05';
			}
			if (!isset($_POST['overall']))
			{
				$err = 'PR06';
			}
			if (isset($_POST['overall']) && !pjValidation::pjActionNotEmpty($_POST['overall']))
			{
				$err = 'PR07';
			}
			if (!isset($_POST['pros']))
			{
				$err = 'PR08';
			}
			if (isset($_POST['pros']) && !pjValidation::pjActionNotEmpty($_POST['pros']))
			{
				$err = 'PR09';
			}
			if (!isset($_POST['cons']))
			{
				$err = 'PR10';
			}
			if (isset($_POST['cons']) && !pjValidation::pjActionNotEmpty($_POST['cons']))
			{
				$err = 'PR11';
			}
			if (isset($_POST['user_type']) && empty($_POST['user_type']))
			{
				$err = 'PR12';
			}
			if (!isset($_POST['captcha']))
			{
				$err = 'PR13';
			}
			if (isset($_POST['captcha']) && !pjValidation::pjActionNotEmpty($_POST['captcha']))
			{
				$err = 'PR14';
			}
			if ($_SESSION[$this->defaultCaptcha]=="" || $_POST['captcha']=="" || strtoupper($_POST['captcha']) != $_SESSION[$this->defaultCaptcha])
			{
				$err = 'PR15';
			}
			if ($err != '')
			{
				if (isset($_SESSION[$this->defaultCaptcha]))
				{
					$_SESSION[$this->defaultCaptcha] = NULL;
					unset($_SESSION[$this->defaultCaptcha]);
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionPost&err=' . $err . (isset($_POST['iframe']) ? '&iframe' : NULL));
			}
			
			$data = array();
			$err = 'PR20';
			
			$pjRaterModel = pjRaterModel::factory();
			$pjRatingModel = pjRatingModel::factory();
			
			$email = $_POST['email'];
			$rater_arr = $pjRaterModel->where("t1.email", $email)->findAll()->getData();
			$data['thread_id'] = $this->getThread();
			if($this->option_arr['o_review_status'] == 'approved')
			{
				$data['status'] = 'T';
			}else{
				$data['status'] = 'F';
				$err = 'PR21';
			}
			$data['ip'] = pjUtil::getClientIp();
			if(count($rater_arr) > 0)
			{
				$data['rater_id'] = $rater_arr[0]['id'];
			}else{
				$rater_data = array();
				$rater_data['name'] = $_POST['name'];
				$rater_data['email'] = $_POST['email'];
				$rater_data['password'] = pjToolkit::getRandomPassword();
					
				$data['rater_id'] = $pjRaterModel->reset()->setAttributes($rater_data)->insert()->getInsertId();
			}
			
			$id = $pjRatingModel->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
			if ($id !== false && (int) $id > 0)
			{
				$pjRatingRatingTypeModel = pjRatingRatingTypeModel::factory();
				if (isset($_POST['rating']) && is_array($_POST['rating']) && count($_POST['rating']) > 0)
				{
					$pjRatingRatingTypeModel->begin();
					foreach ($_POST['rating'] as $rating_type_id => $rate)
					{
						$pjRatingRatingTypeModel
							->reset()
							->set('rating_id', $id)
							->set('rating_type_id', $rating_type_id)
							->set('rate', $rate)
							->insert();
					}
					$pjRatingRatingTypeModel->commit();
				}
				$pjRatingUserTypeModel = pjRatingUserTypeModel::factory();
				if (isset($_POST['user_type']) && is_array($_POST['user_type']) && count($_POST['user_type']) > 0)
				{
					$pjRatingUserTypeModel->begin();
					foreach ($_POST['user_type'] as $user_type_id => $whatever)
					{
						$pjRatingUserTypeModel
							->reset()
							->set('rating_id', $id)
							->set('user_type_id', $user_type_id)
							->insert();
					}
					$pjRatingUserTypeModel->commit();
				}
				
				$this->sendRatingEmail($id);
				$this->sendRatingSMS(1);
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionRating&id=' . $id . '&err=' . $err . (isset($_POST['iframe']) ? '&iframe' : NULL));
			}
		}else{
			$rating_type_arr = pjRatingTypeModel::factory()
			  	->where('t1.status', 'T')
			  	->orderBy("title ASC")
			  	->findAll()
			  	->getData();
			$user_type_arr = pjUserTypeModel::factory()
				->select("t1.*")
				->where('t1.status', 'T')
				->orderBy("title ASC")
				->findAll()
				->getData();
			
			$this->set('rating_type_arr', $rating_type_arr);
			$this->set('user_type_arr', $user_type_arr);
		}
	}
	
	public function pjActionRating()
	{
		if(isset($_GET['id']))
		{
			$arr = pjRatingModel::factory()
				->select("t1.*, t2.name AS rater, t3.thread,
					  (SELECT (AVG(rate) * 10) / 5 FROM `".pjRatingRatingTypeModel::factory()->getTable()."` AS `TRRT` WHERE TRRT.rating_id=t1.id) AS avg,
					  (SELECT GROUP_CONCAT(TUT.title SEPARATOR '~:~') FROM `".pjUserTypeModel::factory()->getTable()."` AS `TUT` WHERE `TUT`.id IN(SELECT `TRUT`.user_type_id FROM `".pjRatingUserTypeModel::factory()->getTable()."` AS `TRUT` WHERE `TRUT`.rating_id=t1.id) ) AS user_types")
			  	->join('pjRater', 't2.id=t1.rater_id', 'left')
			  	->join('pjThread', 't3.id=t1.thread_id', 'left')
			  	->find($_GET['id'])
				->toArray("user_types", "~:~")
				->getData();
			if(!empty($arr))
			{
				$this->set('arr', $arr);
				$this->set('status', 'OK');
			}else{
				$this->set('status', 'ERR');
			}
		}else{
			$this->set('status', 'ERR');
		}
	}
	
	public function pjActionVote()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$rating_id = $_GET['id'];
			$direction =  $_GET['direction'];
			
			$is_can_vote = true;
			$is_update = 0;
			if(isset($_COOKIE[$this->defaultVote . $rating_id])){
				if($_COOKIE[$this->defaultVote . $rating_id] == $direction){
					$is_can_vote = false;
				}else{
					$is_update = 1;
				}
			}
			$pjRatingModel = pjRatingModel::factory();
			if($is_can_vote == true){
				$arr = $pjRatingModel->find($rating_id)->getData();
				
				$expire = time() + 60*60*24;
				setcookie($this->defaultVote . $rating_id, $direction, $expire);
				if(!empty($arr)){
					$data = array();
					if($is_update == 1){
						if($direction == 'up'){
							$data['likes'] = intval($arr['likes']) + 1;
							$data['dislikes'] = intval($arr['dislikes']) - 1;
						}else{
							$data['likes'] = intval($arr['likes']) - 1;
							$data['dislikes'] = intval($arr['dislikes']) + 1;
						}
						$pjRatingModel->reset()->where('id', $rating_id)->limit(1)->modifyAll($data);
					}else{
						if($direction == 'up'){
							$data['likes'] = intval($arr['likes']) + 1;
						}else{
							$data['dislikes'] = intval($arr['dislikes']) + 1;
						}
						$pjRatingModel->reset()->where('id', $rating_id)->limit(1)->modifyAll($data);
					}
					
				}
			}
			$arr = $pjRatingModel->reset()->find($rating_id)->getData();
			$arr['likes'] = '+' . intval($arr['likes']);
			$arr['dislikes'] = '-' . intval($arr['dislikes']);
			pjAppController::jsonResponse($arr);
		}
		exit;
	}
}
?>