<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/ratingmenu.php';
	pjUtil::printNotice(__('infoUpdateRatingTitle', true), __('infoUpdateRatingDesc', true));
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminRatings&amp;action=pjActionUpdate" method="post" id="frmUpdateRating" class="form pj-form" enctype="multipart/form-data">
		<input type="hidden" name="rating_update" value="1" />
		<input type="hidden" id="rating_id" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		<div class="w350 float_left">
			<p>
				<label class="title"><?php __('lblDateTime'); ?></label>
				<span class="inline_block">
					<label class="content"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created']));?>, <?php echo date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created']));?></label>
				</span>
			</p>
		</div>
		<div class="w350 float_right">
			<div class="pjCpRatingVote">
				<span class="pjCpLike">+ <?php echo $tpl['arr']['likes'];?></span>
				<div class="pjCpHand"></div>
				<span class="pjCpDislike">- <?php echo $tpl['arr']['dislikes'];?></span>
			</div>
		</div>
		<div style="clear:both;"></div>
		<p>
			<label class="title"><?php __('lblIp'); ?></label>
			<span class="inline_block">
				<label class="content"><?php echo $tpl['arr']['ip'];?></label>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblRater'); ?></label>
			<span class="inline_block">
				<select name="rater_id" id="rater_id" class="pj-form-field required w200" data-msg-required="<?php __('lblFieldRequired');?>">
					<option value="">-- <?php __('lblChoose'); ?>--</option>
					<?php
					foreach ($tpl['rater_arr'] as $k => $v)
					{
						$name = $v['name'] . ($v['status'] == 'F' ? ' ('.__('pc_inactive', true).')' : NULL);
						if($tpl['arr']['rater_id'] == $v['id'])
						{
							?><option value="<?php echo $v['id']; ?>" selected="selected"><?php echo $name; ?></option><?php
						}else{
							?><option value="<?php echo $v['id']; ?>"><?php echo $name; ?></option><?php
						}
					}
					?>
				</select>
				<a id="pjPcEditRater" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminRaters&amp;action=pjActionUpdate&amp;id=<?php echo $tpl['arr']['rater_id'];?>" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminRaters&amp;action=pjActionUpdate&amp;id={ID}" class="pjPcEdit"></a>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblThread'); ?></label>
			<span class="inline_block">
				<select name="thread_id" id="thread_id" class="pj-form-field required w300" data-msg-required="<?php __('lblFieldRequired');?>">
					<option value="">-- <?php __('lblChoose'); ?>--</option>
					<?php
					foreach ($tpl['thread_arr'] as $k => $v)
					{
						if($tpl['arr']['thread_id'] == $v['id'])
						{
							?><option value="<?php echo $v['id']; ?>" selected="selected" data-url="<?php echo $v['page_url'];?>"><?php echo $v['thread']; ?></option><?php
						}else{
							?><option value="<?php echo $v['id']; ?>" data-url="<?php echo $v['page_url'];?>"><?php echo $v['thread']; ?></option><?php
						}
					}
					?>
				</select>
				<a id="pjPcEditThread" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminThreads&amp;action=pjActionUpdate&amp;id=<?php echo $tpl['arr']['thread_id'];?>" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminThreads&amp;action=pjActionUpdate&amp;id={ID}" class="pjPcEdit"></a>
				<a id="pjPcPreviewThread" href="<?php echo $tpl['arr']['page_url'];?>" class="pjPcPreview pjPcTopPreview" target="_blank"></a>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblOverall'); ?></label>
			<span class="inline_block">
				<input type="text" name="overall" value="<?php echo pjSanitize::html($tpl['arr']['overall']);?>" class="pj-form-field required w400" data-msg-required="<?php __('lblFieldRequired');?>"/>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblPros'); ?></label>
			<span class="inline_block">
				<textarea name="pros" class="pj-form-field w568 h100"><?php echo stripslashes($tpl['arr']['pros']);?></textarea>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblCons'); ?></label>
			<span class="inline_block">
				<textarea name="cons" class="pj-form-field w568 h100"><?php echo stripslashes($tpl['arr']['cons']);?></textarea>
			</span>
		</p>
		
		<?php
		if(!empty($tpl['rating_type_arr']))
		{
			foreach($tpl['rating_type_arr'] as $k => $v)
			{
				$rating_value = 0;
				if(isset($tpl['arr']['rating']))
				{
					$rating_value = (int) $tpl['arr']['rating'][$v['id']];
				}
				?>
				<p>
					<label class="title"><?php echo $v['title']; ?></label>
					<input type="hidden" id="rating_value_<?php echo $v['id'];?>" name="rating[<?php echo $v['id'];?>]" value="<?php echo $rating_value;?>" class="rating-value" data-id="<?php echo $v['id'];?>"/>
					<span class="rating" data-id="<?php echo $v['id'];?>">
						<span id="star_<?php echo $v['id'];?>_1" class="star" lang="1"></span>
						<span id="star_<?php echo $v['id'];?>_2" class="star" lang="2"></span>
						<span id="star_<?php echo $v['id'];?>_3" class="star" lang="3"></span>
						<span id="star_<?php echo $v['id'];?>_4" class="star" lang="4"></span>
						<span id="star_<?php echo $v['id'];?>_5" class="star" lang="5"></span>
					</span>
				</p>
				<?php
			}
		} 
		
		if(!empty($tpl['user_type_arr']))
		{
			?>
			<p>
				<label class="title"><?php __('lblUserType'); ?></label>
				<span class="inline_block">
					<?php
					foreach ($tpl['user_type_arr'] as $k => $v)
					{
						?><span class="block t6"><input type="checkbox" name="user_type[<?php echo $v['id']?>]" id="user_type_<?php echo $v['id'];?>" value="<?php echo $v['id'];?>"<?php echo isset($tpl['arr']['user_type'][$v['id']]) ? ' checked="checked"' : NULL;?> class="block float_left r5"/><label for="user_type_<?php echo $v['id'];?>"><?php echo $v['title'];?></label></span><?php
					}
					?>
				</span>
			</p>
			<?php
		} 
		?>
		<p>
			<label class="title"><?php __('lblStatus'); ?></label>
			<span class="inline_block">
				<select name="status" id="status" class="pj-form-field required" data-msg-required="<?php __('lblFieldRequired');?>">
					<option value="">-- <?php __('lblChoose'); ?>--</option>
					<?php
					foreach (__('rating_statuses', true) as $k => $v)
					{
						if($tpl['arr']['status'] == $k)
						{
							?><option value="<?php echo $k; ?>" selected="selected"><?php echo $v; ?></option><?php
						}else{
							?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
						}
					}
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title">&nbsp;</label>
			<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
			<input type="button" value="<?php __('btnDelete'); ?>" class="pj-button pj-delete-rating" data-id="<?php echo $tpl['arr']['id']; ?>"/>
			<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminRatings&action=pjActionIndex';" />
		</p>
	</form>
	
	<div id="dialogDeleteRating" title="<?php __('lblDeleteRatingTitle'); ?>" style="display:none;">
		<div class="t15">
			<?php __('lblDeleteRatingConfirmation'); ?>
		</div>
	</div>
	<?php
}
?>