var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmCreateRating = $("#frmCreateRating"),
			$frmUpdateRating = $("#frmUpdateRating"),
			$frmXMLFeed = $('#frmXMLFeed'),
			$dialogDeleteRating = $('#dialogDeleteRating'),
			dialog = ($.fn.dialog !== undefined),
			chosen = ($.fn.chosen !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);
		function raterType(type){
			if(type == 'F')
			{
				$('#new_container').css('display', 'block');
				$('#name').addClass('required');
				$('#email').addClass('required email');
				$('#existing_container').css('display', 'none');
				$('#rater_id').removeClass('required');
				$('#rater_id').val('');$('#rater_id').trigger("liszt:updated");
			}else if(type == 'T'){
				$('#existing_container').css('display', 'block');
				$('#rater_id').addClass('required');
				$('#new_container').css('display', 'none');
				$('#name').removeClass('required');
				$('#name').val('');
				$('#email').removeClass('required email');
				$('#email').val('');
			}else{
				$('#new_container').css('display', 'none');
				$('#name').removeClass('required');
				$('#name').val('');
				$('#email').removeClass('required email');
				$('#email').val('');
				$('#existing_container').css('display', 'none');
				$('#rater_id').removeClass('required');
				$('#rater_id').val('');$('#rater_id').trigger("liszt:updated");
			}
		}
		function starHover(star, id)
		{
			for(var i = 1; i <= 5; i++)
			{
				if(i <= star)
				{	
					$('#star_'+id+'_' + i).addClass('star-hover');
				}else{
					$('#star_'+id+'_' + i).removeClass('star-hover');
				}
			}
		}
		$('span.star').hover(
			function () {
				var star = $(this).attr("lang"),
					id = $(this).parent().attr('data-id');
				starHover.apply(null, [star, id]);
			}, 
			function () {
				var id = $(this).parent().attr('data-id'),
					star = $("#rating_value_" + id).val();
				starHover.apply(null, [star, id]);
			}
		);
		$('span.star').on('click', function(e){
			e.preventDefault();
			var star = $(this).attr("lang"),
				id = $(this).parent().attr('data-id');
			$("#rating_value_" + id).val(star);
		});
		
		if ($frmCreateRating.length > 0 && validate) {
			$frmCreateRating.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ''
			});
			
			$frmCreateRating.on('submit', function(e) {
				if($('#is_existing').val() == 'T')
				{
					if(!$('#rater_id').valid()) {
				        e.preventDefault();
				    }
				}
				if($('#thread_id').length > 0)
				{
					if(!$('#thread_id').valid()) {
				        e.preventDefault();
				    }
				}
			}); 
			$('#is_existing').on("change", function(e){
				raterType($(this).val());
			});
			if (chosen) {
				$("#rater_id").chosen();
			}
			if (chosen) {
				$("#thread_id").chosen();
			}
			
			$('#pjPcEditThread').hide();
			$('#pjPcPreviewThread').hide();
			$('#pjPcEditRater').hide();
		}
		if ($frmUpdateRating.length > 0 && validate) {
			$frmUpdateRating.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ''
			});
			
			$frmUpdateRating.on('submit', function(e) {
				if($('#is_existing').val() == 'T')
				{
					if(!$('#rater_id').valid()) {
				        e.preventDefault();
				    }
				}
				if(!$('#thread_id').valid()) {
			        e.preventDefault();
			    }
			}); 
			$('#is_existing').on("change", function(e){
				raterType($(this).val());
			});

			if (chosen) {
				$("#rater_id").chosen();
			}
			if (chosen) {
				$("#thread_id").chosen();
			}
			
			$('.rating-status').on('click', function(e){
				e.preventDefault();
				var status = $(this).attr('data-value');
				var $this = $(this);
				$( ".rating-status" ).each(function() {
					$(this).removeClass( "status-focus" );
				});
				$('#status').val(status);
				$this.addClass("status-focus");
			});
			if($('.rating-value').length > 0)
			{
				$('.rating-value').each(function(index, e){
					var star = $(this).val(),
						id = $(this).attr('data-id');
					starHover.apply(null, [star, id]);
				});
			}
			
			if($dialogDeleteRating.length > 0 && dialog)
			{
				$dialogDeleteRating.dialog({
					autoOpen: false,
					resizable: false,
					draggable: false,
					modal: true,
					height: 160,
					width: 320,
					buttons: (function () {
						var buttons = {};
						buttons[prApp.locale.button.delete] = function () {
							$.ajax({
								type: "GET",
								dataType: "json",
								url: "index.php?controller=pjAdminRatings&action=pjActionDeleteRating&id=" + $dialogDeleteRating.data('rating_id'),
								success: function (res) {
									if(res.code == 200)
									{
										$dialogDeleteRating.dialog('close');
										window.location.href = 'index.php?controller=pjAdminRatings';
									}
								}
							});
						};
						buttons[prApp.locale.button.cancel] = function () {
							$dialogDeleteRating.dialog("close");
						};
						
						return buttons;
					})()
				});
			}
		}
		
		if ($("#grid").length > 0 && datagrid) {
			
			function onBeforeShow (obj) {
				if (parseInt(obj.id, 10) === pjGrid.currentRatingId) {
					return false;
				}
				return true;
			}
			function formatRater(str, obj){
				if(obj.rater_status == 'T')
				{
					return '<a href="index.php?controller=pjAdminRaters&action=pjActionUpdate&id=' + obj.rater_id + '">' + str + '</a>';
				}else{
					return '<a href="index.php?controller=pjAdminRaters&action=pjActionUpdate&id=' + obj.rater_id + '">' + str + '</a><br/><span class="red">' + myLabel.inactive + '</span>';
				}
			}
			function formatThread(str, obj){
				return '<a href="index.php?controller=pjAdminThreads&action=pjActionUpdate&id=' + obj.thread_id + '">' + str + '</a>';
			}
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminRatings&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminRatings&action=pjActionDeleteRating&id={:id}", beforeShow: onBeforeShow}
				          ],
				columns: [{text: myLabel.rating, type: "text", sortable: false, editable: false, width: 260},
				          {text: myLabel.thread, type: "text", sortable: true, editable: false, renderer: formatThread, width: 105},
				          {text: myLabel.rater, type: "text", sortable: true, editable: false, renderer: formatRater, width: 110},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 120, options: [
				                                                                                     {label: myLabel.approved, value: "T"}, 
				                                                                                     {label: myLabel.notapproved, value: "F"}
				                                                                                     ], applyClass: "pj-rating-status"}],
				dataUrl: "index.php?controller=pjAdminRatings&action=pjActionGetRating" + pjGrid.queryString,
				dataType: "json",
				fields: ['rating', 'thread', 'rater', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminRatings&action=pjActionDeleteRatingBulk", render: true, confirmation: myLabel.delete_confirmation},
					   {text: myLabel.exported, url: "index.php?controller=pjAdminRatings&action=pjActionExportRating", ajax: false}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminRatings&action=pjActionSaveRating&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		if ($frmXMLFeed.length > 0 && validate) {
			$frmXMLFeed.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ".ignore"
			});
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminRatings&action=pjActionGetRating", "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminRatings&action=pjActionGetRating", "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminRatings&action=pjActionGetRating", "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".pj-delete-rating", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$dialogDeleteRating.data('rating_id', $(this).attr('data-id')).dialog('open');
		}).on("change", "#rater_id", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var id = $(this).val();
			if(id == '')
			{
				$('#pjPcEditRater').hide();
			}else{
				var href = $('#pjPcEditRater').attr('data-href');
				href = href.replace(/\{ID\}/g, id);
				$('#pjPcEditRater').attr('href', href);
				$('#pjPcEditRater').show();
			}
			
			return false;
		}).on("change", "#thread_id", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var id = $(this).val(),
				page_url = $('option:selected', this).attr('data-url');
			if(id == '')
			{
				$('#pjPcEditThread').hide();
				$('#pjPcPreviewThread').hide();
			}else{
				var href = $('#pjPcEditThread').attr('data-href');
				href = href.replace(/\{ID\}/g, id);
				$('#pjPcEditThread').attr('href', href);
				$('#pjPcEditThread').show();
				
				$('#pjPcPreviewThread').attr('href', page_url);
				$('#pjPcPreviewThread').show();
			}
			
			return false;
		});
	});
})(jQuery_1_8_2);